/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.time.zone.ZoneRules;

public abstract class DateTimeZone {
    static final long MILLIS_PER_HOUR = 3600000L;
    private final String iID;

    protected DateTimeZone(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = id;
    }

    public final String getID() {
        return this.iID;
    }

    public abstract int getOffset(long var1);

    public abstract int getStandardOffset(long var1);

    public boolean isStandardOffset(long instant) {
        return this.getOffset(instant) == this.getStandardOffset(instant);
    }

    public int getOffsetFromLocal(long instantLocal) {
        int offsetPrev;
        int diff;
        long prev;
        long instantAdjusted;
        int offsetAdjusted;
        int offsetLocal = this.getOffset(instantLocal);
        if (offsetLocal != (offsetAdjusted = this.getOffset(instantAdjusted = instantLocal - (long)offsetLocal))) {
            if (offsetLocal - offsetAdjusted < 0) {
                long nextAdjusted;
                long nextLocal = this.nextTransition(instantAdjusted);
                if (nextLocal == instantLocal - (long)offsetLocal) {
                    nextLocal = Long.MAX_VALUE;
                }
                if ((nextAdjusted = this.nextTransition(instantLocal - (long)offsetAdjusted)) == instantLocal - (long)offsetAdjusted) {
                    nextAdjusted = Long.MAX_VALUE;
                }
                if (nextLocal != nextAdjusted) {
                    return offsetLocal;
                }
            }
        } else if (offsetLocal >= 0 && (prev = this.previousTransition(instantAdjusted)) < instantAdjusted && instantAdjusted - prev <= (long)(diff = (offsetPrev = this.getOffset(prev)) - offsetLocal)) {
            return offsetPrev;
        }
        return offsetAdjusted;
    }

    public long convertUTCToLocal(long instantUTC) {
        int offset = this.getOffset(instantUTC);
        long instantLocal = instantUTC + (long)offset;
        if ((instantUTC ^ instantLocal) < 0L && (instantUTC ^ (long)offset) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return instantLocal;
    }

    public long convertLocalToUTC(long instantLocal, boolean strict, long originalInstantUTC) {
        int offsetOriginal = this.getOffset(originalInstantUTC);
        long instantUTC = instantLocal - (long)offsetOriginal;
        int offsetLocalFromOriginal = this.getOffset(instantUTC);
        if (offsetLocalFromOriginal == offsetOriginal) {
            return instantUTC;
        }
        return this.convertLocalToUTC(instantLocal, strict);
    }

    public long convertLocalToUTC(long instantLocal, boolean strict) {
        long instantUTC;
        int offset;
        int offsetLocal = this.getOffset(instantLocal);
        if (offsetLocal != (offset = this.getOffset(instantLocal - (long)offsetLocal)) && (strict || offsetLocal < 0)) {
            long nextAdjusted;
            long nextLocal = this.nextTransition(instantLocal - (long)offsetLocal);
            if (nextLocal == instantLocal - (long)offsetLocal) {
                nextLocal = Long.MAX_VALUE;
            }
            if ((nextAdjusted = this.nextTransition(instantLocal - (long)offset)) == instantLocal - (long)offset) {
                nextAdjusted = Long.MAX_VALUE;
            }
            if (nextLocal != nextAdjusted) {
                if (strict) {
                    throw new RuntimeException(this.getID());
                }
                offset = offsetLocal;
            }
        }
        if ((instantLocal ^ (instantUTC = instantLocal - (long)offset)) < 0L && (instantLocal ^ (long)offset) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return instantUTC;
    }

    public long getMillisKeepLocal(DateTimeZone newZone, long oldInstant) {
        if (newZone == this) {
            return oldInstant;
        }
        long instantLocal = this.convertUTCToLocal(oldInstant);
        return newZone.convertLocalToUTC(instantLocal, false, oldInstant);
    }

    public long adjustOffset(long instant, boolean earlierOrLater) {
        long offsetAfter;
        long instantBefore = instant - 10800000L;
        long instantAfter = instant + 10800000L;
        long offsetBefore = this.getOffset(instantBefore);
        if (offsetBefore <= (offsetAfter = (long)this.getOffset(instantAfter))) {
            return instant;
        }
        long diff = offsetBefore - offsetAfter;
        long transition = this.nextTransition(instantBefore);
        long overlapStart = transition - diff;
        long overlapEnd = transition + diff;
        if (instant < overlapStart || instant >= overlapEnd) {
            return instant;
        }
        long afterStart = instant - overlapStart;
        if (afterStart >= diff) {
            return earlierOrLater ? instant : instant - diff;
        }
        return earlierOrLater ? instant + diff : instant;
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public abstract ZoneRules asZoneRules();
}

