/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.jar;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class TJarUtils {
    private TJarUtils() {
    }

    static boolean asciiEqualsIgnoreCase(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Character.toLowerCase((char)a[i]) == Character.toLowerCase((char)b[i])) continue;
            return false;
        }
        return true;
    }

    static byte[] readFullyAndClose(InputStream input) throws IOException {
        ByteBuffer result = ByteBuffer.wrap(new byte[Math.min(512, input.available())]);
        while (true) {
            int actuallyRead;
            if (result.remaining() == 0) {
                result = ByteBuffer.wrap(Arrays.copyOf(result.array(), result.capacity() * 2));
            }
            if ((actuallyRead = input.read(result.array(), result.position(), result.remaining())) == -1) break;
            result.position(result.position() + actuallyRead);
        }
        byte[] b = Arrays.copyOf(result.array(), result.position());
        input.close();
        return b;
    }
}

