/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.classlib.java.nio.TShortBufferImpl;

abstract class TShortBufferOverByteBuffer
extends TShortBufferImpl {
    TByteBufferImpl byteBuffer;
    private boolean readOnly;
    int start;
    private int capacity;

    TShortBufferOverByteBuffer(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(position, limit);
        this.start = start;
        this.capacity = capacity;
        this.byteBuffer = byteBuffer;
        this.readOnly = readOnly;
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    short[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    void getImpl(int index, short[] dst, int offset, int length) {
        while (length-- > 0) {
            dst[offset++] = this.getElement(index++);
        }
    }

    @Override
    void putImpl(int index, short[] src, int offset, int length) {
        while (length-- > 0) {
            this.putElement(index++, src[offset++]);
        }
    }

    @Override
    void putImpl(int index, TShortBuffer src, int offset, int length) {
        if (src instanceof TShortBufferOverByteBuffer && src.order() == this.order()) {
            TShortBufferOverByteBuffer srcImpl = (TShortBufferOverByteBuffer)src;
            System.arraycopy(srcImpl.byteBuffer.array, srcImpl.start + index * 2, this.byteBuffer.array, this.start + offset * 2, length * 2);
        } else {
            while (length-- > 0) {
                this.putElement(index++, src.getElement(offset++));
            }
        }
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }
}

