/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import java.nio.BufferUnderflowException;
import java.util.Objects;
import org.teavm.backend.c.runtime.Memory;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TOutOfMemoryError;
import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TByteBufferJsImpl;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteBufferWasmGC;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;
import org.teavm.classlib.java.nio.TShortBuffer;
import org.teavm.interop.Address;
import org.teavm.jso.core.JSObjects;
import org.teavm.jso.typedarrays.Int8Array;
import org.teavm.runtime.GC;
import org.teavm.runtime.RuntimeBuffer;
import org.teavm.runtime.heap.Heap;

public abstract class TByteBuffer
extends TBuffer
implements TComparable<TByteBuffer> {
    TByteOrder order = TByteOrder.BIG_ENDIAN;

    TByteBuffer() {
    }

    public static TByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            TByteBufferJsImpl result = new TByteBufferJsImpl(null, 0, new Int8Array(capacity), true, false);
            result.limit = capacity;
            return result;
        }
        if (PlatformDetector.isC()) {
            Address memory = Memory.malloc((int)capacity);
            TByteBufferNative result = new TByteBufferNative(null, null, 0, null, memory, capacity, false);
            GC.registerDirectBuffer((RuntimeBuffer)((RuntimeBuffer)Address.ofObject((Object)result).toStructure()));
            result.limit = capacity;
            return result;
        }
        if (PlatformDetector.isWebAssembly()) {
            byte[] array = new byte[capacity];
            TByteBufferNative result = new TByteBufferNative(null, array, 0, array, Address.ofData((byte[])array), array.length, false);
            result.limit = capacity;
            return result;
        }
        if (PlatformDetector.isWebAssemblyGC()) {
            Address addr = Heap.alloc((int)capacity);
            if (addr == null) {
                throw new TOutOfMemoryError();
            }
            TByteBufferWasmGC result = new TByteBufferWasmGC(null, null, 0, null, addr, capacity, false);
            result.regKey = JSObjects.create();
            result.regToken = JSObjects.create();
            result.limit = capacity;
            TJSBufferHelper.WasmGC.register(result.regKey, addr, result.regToken);
            return result;
        }
        return new TByteBufferImpl(capacity, true);
    }

    public static TByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        if (PlatformDetector.isJavaScript()) {
            byte[] array = new byte[capacity];
            TByteBufferJsImpl result = new TByteBufferJsImpl(array, 0, Int8Array.fromJavaArray((byte[])array), false, false);
            result.limit = capacity;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            byte[] array = new byte[capacity];
            TByteBufferNative result = new TByteBufferNative(null, array, 0, array, Address.ofData((byte[])array), array.length, false);
            result.limit = capacity;
            return result;
        }
        return new TByteBufferImpl(capacity, false);
    }

    public static TByteBuffer wrap(byte[] array, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, array.length);
        if (PlatformDetector.isJavaScript()) {
            Int8Array data = Int8Array.fromJavaArray((byte[])array);
            TByteBufferJsImpl result = new TByteBufferJsImpl(array, 0, data, false, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        if (PlatformDetector.isC() || PlatformDetector.isWebAssembly()) {
            TByteBufferNative result = new TByteBufferNative(null, array, 0, array, Address.ofData((byte[])array), array.length, false);
            result.position = offset;
            result.limit = offset + length;
            return result;
        }
        return new TByteBufferImpl(0, array.length, array, offset, offset + length, false, false);
    }

    public static TByteBuffer wrap(byte[] array) {
        return TByteBuffer.wrap(array, 0, array.length);
    }

    public abstract TByteBuffer slice();

    public abstract TByteBuffer duplicate();

    public abstract TByteBuffer asReadOnlyBuffer();

    public abstract byte get();

    public abstract TByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract TByteBuffer put(int var1, byte var2);

    public TByteBuffer get(byte[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.getImpl(this.position, dst, offset, length);
        this.position += length;
        return this;
    }

    public TByteBuffer get(int index, byte[] dst) {
        return this.get(index, dst, 0, dst.length);
    }

    public TByteBuffer get(int index, byte[] dst, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > dst.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.getImpl(index, dst, offset, length);
        return this;
    }

    abstract void getImpl(int var1, byte[] var2, int var3, int var4);

    public TByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TByteBuffer put(TByteBuffer src) {
        return this.put(this.position(), src, src.position(), src.remaining());
    }

    public TByteBuffer put(int index, TByteBuffer src, int offset, int length) {
        if (src.remaining() == 0) {
            return this;
        }
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.limit() || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(index, src, offset, length);
        return this;
    }

    abstract void putImpl(int var1, TByteBuffer var2, int var3, int var4);

    public TByteBuffer put(byte[] src, int offset, int length) {
        if (length == 0) {
            return this;
        }
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.remaining()) {
            throw new TBufferOverflowException();
        }
        this.putImpl(src, offset, this.position, length);
        this.position += length;
        return this;
    }

    public final TByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public TByteBuffer put(int index, byte[] src) {
        return this.put(index, src, 0, src.length);
    }

    public TByteBuffer put(int index, byte[] src, int offset, int length) {
        if (length == 0) {
            return this;
        }
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (length < 0 || offset < 0 || offset + length > src.length || index < 0 || index + length > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.putImpl(src, offset, index, length);
        return this;
    }

    abstract void putImpl(byte[] var1, int var2, int var3, int var4);

    @Override
    public final boolean hasArray() {
        return this.hasArrayImpl();
    }

    public final byte[] array() {
        return this.arrayImpl();
    }

    @Override
    public final int arrayOffset() {
        return this.arrayOffsetImpl();
    }

    abstract boolean hasArrayImpl();

    abstract byte[] arrayImpl();

    abstract int arrayOffsetImpl();

    public abstract TByteBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[ByteBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity() + ", mark " + (String)(this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position();
        for (int i = this.position(); i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.get(pos);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TByteBuffer)) {
            return false;
        }
        TByteBuffer other = (TByteBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position();
        int b = other.position();
        for (int i = 0; i < sz; ++i) {
            if (this.get(a++) == other.get(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TByteBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position();
        int b = other.position();
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Byte.compare(this.get(a++), other.get(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public final TByteOrder order() {
        return this.order;
    }

    public final TByteBuffer order(TByteOrder bo) {
        this.order = bo;
        this.onOrderChanged();
        return this;
    }

    void onOrderChanged() {
    }

    public abstract char getChar();

    public abstract TByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract TByteBuffer putChar(int var1, char var2);

    public abstract TCharBuffer asCharBuffer();

    public abstract short getShort();

    public abstract TByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract TByteBuffer putShort(int var1, short var2);

    public abstract TShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract TByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract TByteBuffer putInt(int var1, int var2);

    public abstract TIntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract TByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract TByteBuffer putLong(int var1, long var2);

    public abstract TLongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract TByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract TByteBuffer putFloat(int var1, float var2);

    public abstract TFloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract TByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract TByteBuffer putDouble(int var1, double var2);

    public abstract TDoubleBuffer asDoubleBuffer();

    @Override
    public final TByteBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TByteBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TByteBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TByteBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TByteBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TByteBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TByteBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

