/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;

public class TShort
extends TNumber
implements TComparable<TShort> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Short.TYPE;
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    private static TShort[] shortCache;
    private final short value;

    public TShort(short value) {
        this.value = value;
    }

    public TShort(String s) throws TNumberFormatException {
        this(TShort.parseShort(s));
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    public static TShort valueOf(short i) {
        if (i >= -128 && i <= 127) {
            TShort.ensureShortCache();
            return shortCache[i + 128];
        }
        return new TShort(i);
    }

    private static void ensureShortCache() {
        if (shortCache == null) {
            shortCache = new TShort[256];
            for (int j = 0; j < shortCache.length; ++j) {
                TShort.shortCache[j] = new TShort((short)(j - 128));
            }
        }
    }

    public static String toString(short value) {
        return "" + value;
    }

    @Override
    public String toString() {
        return TShort.toString(this.value);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof TShort && ((TShort)other).value == this.value;
    }

    @Override
    public int hashCode() {
        return TShort.hashCode(this.value);
    }

    public static int hashCode(short value) {
        return value;
    }

    public static int compare(short a, short b) {
        return a - b;
    }

    public static int compareUnsigned(short a, short b) {
        return (a & 0xFFFF) - (b & 0xFFFF);
    }

    @Override
    public int compareTo(TShort other) {
        return TShort.compare(this.value, other.value);
    }

    public static int toUnsignedInt(short value) {
        return value & 0xFFFF;
    }

    public static long toUnsignedLong(short value) {
        return value & 0xFFFF;
    }

    public static short parseShort(String s, int radix) throws TNumberFormatException {
        int value = TInteger.parseInt(s, radix);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new TNumberFormatException();
        }
        return (short)value;
    }

    public static short parseShort(String s) throws TNumberFormatException {
        return TShort.parseShort(s, 10);
    }

    public static TShort valueOf(String s, int radix) throws TNumberFormatException {
        return TShort.valueOf(TShort.parseShort(s, radix));
    }

    public static TShort valueOf(String s) throws TNumberFormatException {
        return TShort.valueOf(TShort.parseShort(s));
    }

    public static TShort decode(String s) throws TNumberFormatException {
        int value = TInteger.decode(s).intValue();
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new TNumberFormatException();
        }
        return TShort.valueOf((short)value);
    }

    public static short reverseBytes(short i) {
        return (short)(i << 8 | (i & 0xFF00) >> 8);
    }
}

