/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.classlib.impl.Base64Impl;
import org.teavm.classlib.java.lang.ClassLoaderNativeGenerator;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TSystemClassLoader;
import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSIndexer;
import org.teavm.jso.JSObject;

public abstract class TClassLoader
extends TObject {
    private TClassLoader parent;
    private static TSystemClassLoader systemClassLoader = new TSystemClassLoader();
    private static ResourceContainer resources;

    protected TClassLoader() {
        this(null);
    }

    protected TClassLoader(TClassLoader parent) {
        this.parent = parent;
    }

    public TClassLoader getParent() {
        return this.parent;
    }

    public static TClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    public InputStream getResourceAsStream(String name) {
        JSObject data;
        String dataString;
        if (resources == null) {
            resources = TClassLoader.supplyResources();
        }
        if ((dataString = TClassLoader.resourceToString(data = resources.getResource(name))) == null) {
            return null;
        }
        byte[] bytes = new byte[dataString.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)dataString.charAt(i);
        }
        return new ByteArrayInputStream(Base64Impl.decode(bytes));
    }

    public static InputStream getSystemResourceAsStream(String name) {
        return TClassLoader.getSystemClassLoader().getResourceAsStream(name);
    }

    @JSBody(params={"resource"}, script="return resource !== null && resource !== void 0 ? resource : null;")
    private static native String resourceToString(JSObject var0);

    @InjectedBy(value=ClassLoaderNativeGenerator.class)
    @NoSideEffects
    private static native ResourceContainer supplyResources();

    static interface ResourceContainer
    extends JSObject {
        @JSIndexer
        public JSObject getResource(String var1);
    }
}

