/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import java.io.OutputStream;
import org.teavm.classlib.java.io.TPipedInputStream;

public class TPipedOutputStream
extends OutputStream {
    private TPipedInputStream dest;

    public TPipedOutputStream() {
    }

    public TPipedOutputStream(TPipedInputStream dest) throws IOException {
        this.connect(dest);
    }

    @Override
    public void close() throws IOException {
        if (this.dest != null) {
            this.dest.done();
            this.dest = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(TPipedInputStream stream) throws IOException {
        if (null == stream) {
            throw new NullPointerException();
        }
        if (this.dest != null) {
            throw new IOException();
        }
        TPipedInputStream tPipedInputStream = stream;
        synchronized (tPipedInputStream) {
            if (stream.isConnected) {
                throw new IOException();
            }
            stream.buffer = new byte[1024];
            stream.isConnected = true;
            this.dest = stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.dest != null) {
            TPipedInputStream tPipedInputStream = this.dest;
            synchronized (tPipedInputStream) {
                this.dest.notifyAll();
            }
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        super.write(buffer, offset, count);
    }

    @Override
    public void write(int oneByte) throws IOException {
        if (this.dest == null) {
            throw new IOException();
        }
        this.dest.receive(oneByte);
    }
}

