/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import org.teavm.classlib.java.io.TFileFilter;
import org.teavm.classlib.java.io.TFilenameFilter;
import org.teavm.classlib.java.util.TRandom;
import org.teavm.runtime.fs.VirtualFile;
import org.teavm.runtime.fs.VirtualFileSystem;
import org.teavm.runtime.fs.VirtualFileSystemProvider;

public class TFile
implements Serializable,
Comparable<TFile> {
    private String path;
    public static final char separatorChar = (char)(TFile.fs().isWindows() ? 92 : 47);
    public static final String separator = String.valueOf(separatorChar);
    public static final char pathSeparatorChar = (char)(TFile.fs().isWindows() ? 59 : 58);
    public static final String pathSeparator = String.valueOf(pathSeparatorChar);
    private static int counter;

    public TFile(TFile dir, String name) {
        Objects.requireNonNull(name);
        this.path = dir == null ? TFile.fixSlashes(name) : TFile.calculatePath(dir.getPath(), name);
    }

    public TFile(String path) {
        Objects.requireNonNull(path);
        this.path = TFile.fixSlashes(path);
    }

    public TFile(String dir, String name) {
        Objects.requireNonNull(name);
        this.path = dir == null ? TFile.fixSlashes(name) : TFile.calculatePath(dir, name);
    }

    public TFile(URI uri) {
        this.checkURI(uri);
        String path = uri.getPath();
        if (TFile.fs().isWindows() && path.startsWith("/") && path.length() >= 4 && TFile.isDriveLetter(path.charAt(1)) && path.charAt(2) == ':' && path.charAt(3) == '/') {
            path = path.substring(1);
        }
        this.path = TFile.fixSlashes(path);
    }

    private void checkURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (!uri.getRawSchemeSpecificPart().startsWith("/")) {
            throw new IllegalArgumentException();
        }
        String temp = uri.getScheme();
        if (temp == null || !temp.equals("file")) {
            throw new IllegalArgumentException();
        }
        temp = uri.getRawPath();
        if (temp == null || temp.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException();
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException();
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException();
        }
    }

    public boolean canRead() {
        VirtualFile virtualFile = this.findVirtualFile();
        return virtualFile != null && virtualFile.canRead();
    }

    public boolean canWrite() {
        VirtualFile virtualFile = this.findVirtualFile();
        return virtualFile != null && virtualFile.canWrite();
    }

    @Override
    public int compareTo(TFile o) {
        return this.path.compareTo(o.path);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        int separatorIndex = this.path.lastIndexOf(separator);
        return separatorIndex < 0 ? this.path : this.path.substring(separatorIndex + 1, this.path.length());
    }

    private static VirtualFileSystem fs() {
        return VirtualFileSystemProvider.getInstance();
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        String userdir = TFile.fs().getUserDir();
        if (this.path.isEmpty()) {
            return userdir;
        }
        int length = userdir.length();
        StringBuilder result = new StringBuilder(userdir);
        if (userdir.charAt(length - 1) != separatorChar) {
            if (this.path.charAt(0) != separatorChar) {
                result.append(separator);
            }
        } else if (TFile.fs().isWindows() && this.path.charAt(0) == separatorChar) {
            result.setLength(3);
        }
        result.append(this.path);
        return result.toString();
    }

    public TFile getAbsoluteFile() {
        return new TFile(this.getAbsolutePath());
    }

    public boolean isAbsolute() {
        return this.isAbsolutePath(this.path);
    }

    private boolean isAbsolutePath(String path) {
        if (TFile.fs().isWindows()) {
            if (path.length() < 3) {
                return false;
            }
            return TFile.isDriveLetter(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '\\';
        }
        return !path.isEmpty() && path.charAt(0) == separatorChar;
    }

    private static boolean isDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public boolean isDirectory() {
        VirtualFile virtualFile = this.findVirtualFile();
        return virtualFile != null && virtualFile.isDirectory();
    }

    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public boolean isFile() {
        VirtualFile virtualFile = this.findVirtualFile();
        return virtualFile != null && virtualFile.isFile();
    }

    public String getCanonicalPath() throws IOException {
        return TFile.fs().canonicalize(this.getCanonicalPathImpl());
    }

    private String getCanonicalPathImpl() {
        String result = this.getAbsolutePath();
        int numSeparators = 1;
        for (int i = 0; i < result.length(); ++i) {
            if (result.charAt(i) != separatorChar) continue;
            ++numSeparators;
        }
        int[] sepLocations = new int[numSeparators];
        int rootLoc = TFile.fs().isWindows() ? 2 : 0;
        char[] newResult = new char[result.length() + 1];
        int newLength = 0;
        int lastSlash = 0;
        int foundDots = 0;
        sepLocations[lastSlash] = rootLoc;
        for (int i = 0; i <= result.length(); ++i) {
            if (i < rootLoc) {
                newResult[newLength++] = result.charAt(i);
                continue;
            }
            if (i == result.length() || result.charAt(i) == separatorChar) {
                if (i == result.length() && foundDots == 0) break;
                if (foundDots == 1) {
                    foundDots = 0;
                    continue;
                }
                if (foundDots > 1) {
                    lastSlash = lastSlash > foundDots - 1 ? lastSlash - (foundDots - 1) : 0;
                    newLength = sepLocations[lastSlash] + 1;
                    foundDots = 0;
                    continue;
                }
                sepLocations[++lastSlash] = newLength;
                newResult[newLength++] = separatorChar;
                continue;
            }
            if (result.charAt(i) == '.') {
                ++foundDots;
                continue;
            }
            if (foundDots > 0) {
                for (int j = 0; j < foundDots; ++j) {
                    newResult[newLength++] = 46;
                }
            }
            newResult[newLength++] = result.charAt(i);
            foundDots = 0;
        }
        if (newLength > rootLoc + 1 && newResult[newLength - 1] == separatorChar) {
            --newLength;
        }
        return new String(newResult, 0, newLength);
    }

    public TFile getCanonicalFile() throws IOException {
        return new TFile(this.getCanonicalPath());
    }

    public String getParent() {
        int length = this.path.length();
        int index = this.path.lastIndexOf(separatorChar);
        if (index == -1 || this.path.charAt(length - 1) == separatorChar) {
            return null;
        }
        if (this.path.indexOf(separatorChar) == index && (this.isAbsolutePath(this.path) || index == 0)) {
            return this.path.substring(0, index + 1);
        }
        return this.path.substring(0, index);
    }

    public TFile getParentFile() {
        String path = this.getParent();
        return path != null ? new TFile(this.getParent()) : null;
    }

    public static TFile[] listRoots() {
        return new TFile[]{new TFile("/")};
    }

    public String[] list() {
        VirtualFile virtualFile = this.findVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile.listFiles();
    }

    public String[] list(TFilenameFilter filter) {
        String[] result = this.list();
        if (result == null) {
            return null;
        }
        int j = 0;
        for (String name : result) {
            if (!filter.accept(this, name)) continue;
            result[j++] = name;
        }
        if (j < result.length) {
            result = Arrays.copyOf(result, j);
        }
        return result;
    }

    public TFile[] listFiles() {
        VirtualFile virtualFile = this.findVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String[] entries = virtualFile.listFiles();
        if (entries == null) {
            return null;
        }
        TFile[] files = new TFile[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            files[i] = new TFile(this, entries[i]);
        }
        return files;
    }

    public TFile[] listFiles(TFileFilter filter) {
        TFile[] result = this.listFiles();
        if (result == null) {
            return null;
        }
        int j = 0;
        for (TFile file : result) {
            if (!filter.accept(file)) continue;
            result[j++] = file;
        }
        if (j < result.length) {
            result = Arrays.copyOf(result, j);
        }
        return result;
    }

    public TFile[] listFiles(TFilenameFilter filter) {
        TFile[] result = this.listFiles();
        if (result == null) {
            return null;
        }
        int j = 0;
        for (TFile file : result) {
            if (!filter.accept(this, file.getName())) continue;
            result[j++] = file;
        }
        if (j < result.length) {
            result = Arrays.copyOf(result, j);
        }
        return result;
    }

    public boolean exists() {
        VirtualFile virtualFile = this.findVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return virtualFile.isDirectory() || virtualFile.isFile();
    }

    public long lastModified() {
        VirtualFile virtualFile = this.findVirtualFile();
        return virtualFile != null ? virtualFile.lastModified() : 0L;
    }

    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        VirtualFile file = this.findVirtualFile();
        if (file == null) {
            return false;
        }
        return file.setLastModified(time);
    }

    public boolean setReadOnly() {
        VirtualFile file = this.findVirtualFile();
        if (file == null) {
            return false;
        }
        return file.setReadOnly(true);
    }

    public boolean setWritable(boolean writable) {
        VirtualFile file = this.findVirtualFile();
        return file.setReadOnly(!writable);
    }

    public long length() {
        VirtualFile virtualFile = this.findVirtualFile();
        return virtualFile != null && virtualFile.isFile() ? (long)virtualFile.length() : 0L;
    }

    public boolean createNewFile() throws IOException {
        VirtualFile parentVirtualFile = this.findParentFile();
        if (parentVirtualFile == null || !parentVirtualFile.isDirectory()) {
            throw new IOException("Can't create file " + this.getPath() + " since parent directory does not exist");
        }
        return parentVirtualFile.createFile(this.getName());
    }

    public boolean mkdir() {
        VirtualFile virtualFile = this.findParentFile();
        return virtualFile != null && virtualFile.isDirectory() && virtualFile.createDirectory(this.getName());
    }

    public boolean mkdirs() {
        VirtualFile file;
        String path = this.getCanonicalPathImpl();
        if (path.indexOf(separatorChar) < 0) {
            return false;
        }
        int i = path.length();
        while (!(file = TFile.fs().getFile(path.substring(0, i))).isDirectory()) {
            if (file.isFile()) {
                return false;
            }
            int next = path.lastIndexOf(separatorChar, i - 1);
            if (next >= 0 && (i = next) != 0) continue;
            break;
        }
        while (i < path.length()) {
            int next = path.indexOf(separatorChar, i + 1);
            if (next < 0) {
                next = path.length();
            }
            if (next == i + 1) break;
            String dirPath = i == 0 && path.startsWith("/") ? "/" : path.substring(0, i);
            VirtualFile file2 = TFile.fs().getFile(dirPath);
            if (!file2.createDirectory(path.substring(i + 1, next))) {
                return false;
            }
            i = next;
        }
        return true;
    }

    public boolean delete() {
        VirtualFile virtualFile = this.findVirtualFile();
        return virtualFile.delete();
    }

    public void deleteOnExit() {
    }

    public boolean renameTo(TFile dest) {
        VirtualFile targetDir = dest.findParentFile();
        if (targetDir == null) {
            return false;
        }
        VirtualFile virtualFile = this.findVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return targetDir.adopt(virtualFile, dest.getName());
    }

    public URI toURI() {
        String name = this.getAbsoluteName();
        try {
            if (!name.startsWith("/")) {
                return new URI("file", null, "/" + name, null, null);
            }
            if (name.startsWith("//")) {
                return new URI("file", "", name, null);
            }
            return new URI("file", null, name, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getAbsoluteName() {
        TFile f = this.getAbsoluteFile();
        String name = f.getPath();
        if (f.isDirectory() && name.charAt(name.length() - 1) != separatorChar) {
            name = new StringBuilder(name.length() + 1).append(name).append('/').toString();
        }
        if (TFile.fs().isWindows()) {
            name = name.replace(separatorChar, '/');
        }
        return name;
    }

    public static TFile createTempFile(String prefix, String suffix) throws IOException {
        return TFile.createTempFile(prefix, suffix, null);
    }

    public static TFile createTempFile(String prefix, String suffix, TFile directory) throws IOException {
        TFile result;
        TFile tmpDirFile;
        String newSuffix;
        if (prefix.length() < 3) {
            throw new IllegalArgumentException();
        }
        String string = newSuffix = suffix == null ? ".tmp" : suffix;
        if (directory == null) {
            String tmpDir = System.getProperty("java.io.tmpdir", ".");
            tmpDirFile = new TFile(tmpDir);
            if (!tmpDirFile.mkdirs()) {
                throw new IOException("Could not access temp dir");
            }
        } else {
            tmpDirFile = directory;
        }
        while (!(result = TFile.genTempFile(prefix, newSuffix, tmpDirFile)).createNewFile()) {
        }
        return result;
    }

    private static TFile genTempFile(String prefix, String suffix, TFile directory) {
        if (counter == 0) {
            int newInt = new TRandom().nextInt();
            counter = (newInt / 65535 & 0xFFFF) + 10000;
        }
        int identify = counter++;
        StringBuilder newName = new StringBuilder();
        newName.append(prefix);
        newName.append(counter);
        newName.append(identify);
        newName.append(suffix);
        return new TFile(directory, newName.toString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TFile)) {
            return false;
        }
        return TFile.fs().isWindows() ? this.path.equalsIgnoreCase(((File)obj).getPath()) : this.path.equals(((File)obj).getPath());
    }

    public int hashCode() {
        return TFile.fs().isWindows() ? this.path.toLowerCase().hashCode() : this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    private static String fixSlashes(String origPath) {
        int length = origPath.length();
        int newLength = 0;
        if (TFile.fs().isWindows() && length == 3 && TFile.isDriveLetter(origPath.charAt(0)) && origPath.charAt(1) == ':' && (origPath.charAt(2) == '/' || origPath.charAt(2) == '\\')) {
            return origPath.substring(0, 2) + "\\";
        }
        boolean foundSlash = false;
        char[] newPath = origPath.toCharArray();
        for (int i = 0; i < length; ++i) {
            char pathChar = newPath[i];
            if (pathChar == '/' || pathChar == separatorChar) {
                if (foundSlash && i != 0) continue;
                newPath[newLength++] = separatorChar;
                foundSlash = true;
                continue;
            }
            newPath[newLength++] = pathChar;
            foundSlash = false;
        }
        if (foundSlash && (newLength > 1 || newPath[0] != '/')) {
            --newLength;
        }
        return new String(newPath, 0, newLength);
    }

    private static String calculatePath(String dirPath, String name) {
        dirPath = TFile.fixSlashes(dirPath);
        if (!name.isEmpty() || dirPath.isEmpty()) {
            int separatorIndex;
            name = TFile.fixSlashes(name);
            for (separatorIndex = 0; separatorIndex < name.length() && name.charAt(separatorIndex) == separatorChar; ++separatorIndex) {
            }
            if (separatorIndex > 0) {
                name = name.substring(separatorIndex);
            }
            if (!dirPath.isEmpty() && dirPath.charAt(dirPath.length() - 1) == separatorChar) {
                return dirPath + name;
            }
            return dirPath + separatorChar + name;
        }
        return dirPath;
    }

    VirtualFile findVirtualFile() {
        return TFile.fs().getFile(this.getCanonicalPathImpl());
    }

    VirtualFile findParentFile() {
        String path = this.getCanonicalPathImpl();
        if (path.isEmpty() || path.equals("/")) {
            return null;
        }
        return new TFile(path).getParentFile().findVirtualFile();
    }

    private boolean isRoot(String path) {
        if (TFile.fs().isWindows()) {
            return path.length() == 3 && this.isAbsolutePath(path);
        }
        return path.equals("/");
    }
}

