/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.console;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public abstract class JsConsolePrintStream
extends PrintStream {
    private ByteEncoder byteEncoder;
    private Runnable flushAction;

    public JsConsolePrintStream() {
        super(null, false, (Charset)null);
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.print("\n");
    }

    @Override
    public void print(int i) {
        this.print(Integer.toString(i));
    }

    @Override
    public void print(char c) {
        this.print(Character.toString(c));
    }

    @Override
    public void print(long l) {
        this.print(Long.toString(l));
    }

    @Override
    public void print(double d) {
        super.print(d);
    }

    @Override
    public void print(Object s) {
        this.print(Objects.toString(s));
    }

    @Override
    public void print(char[] s) {
        this.print(new String(s));
    }

    @Override
    public void println() {
        this.print("\n");
    }

    @Override
    public void println(int i) {
        this.println(Integer.toString(i));
    }

    @Override
    public void println(char c) {
        this.println(Character.toString(c));
    }

    @Override
    public void println(long l) {
        this.println(Long.toString(l));
    }

    @Override
    public void println(float d) {
        this.println(Float.toString(d));
    }

    @Override
    public void println(double d) {
        this.println(Double.toString(d));
    }

    @Override
    public void println(boolean b) {
        this.println(Boolean.toString(b));
    }

    @Override
    public void println(Object s) {
        this.println(Objects.toString(s));
    }

    @Override
    public void write(int b) {
        this.ensureByteEncoder().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureByteEncoder().write(b, off, len);
    }

    protected void print(char[] s, int begin, int end) {
        this.print(new String(s, begin, end));
    }

    protected void print(CharSequence s, int begin, int end) {
        this.print(s.subSequence(begin, end).toString());
    }

    @Override
    public void flush() {
        if (this.flushAction != null) {
            this.flushAction = null;
            this.flushAction.run();
        }
    }

    private ByteEncoder ensureByteEncoder() {
        if (this.byteEncoder == null) {
            this.byteEncoder = new ByteEncoder();
        }
        return this.byteEncoder;
    }

    @Override
    public abstract void print(String var1);

    private class ByteEncoder {
        private ByteBuffer buffer = ByteBuffer.wrap(new byte[32]);
        private char[] outChars = new char[32];
        private CharBuffer outBuffer = CharBuffer.wrap(this.outChars);
        private CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

        private ByteEncoder() {
        }

        void write(int b) {
            this.postponeFlush();
            if (!this.buffer.hasRemaining()) {
                this.output();
            }
            this.buffer.put((byte)b);
        }

        void write(byte[] b, int off, int len) {
            this.postponeFlush();
            while (len > 0) {
                int count = Math.min(len, this.buffer.remaining());
                this.buffer.put(b, off, count);
                len -= count;
                this.output();
            }
        }

        void postponeFlush() {
            if (JsConsolePrintStream.this.flushAction == null) {
                JsConsolePrintStream.this.flushAction = this::flush;
            }
        }

        private void flush() {
            if (this.buffer.position() > 0) {
                this.output(true);
            }
        }

        private void output() {
            this.output(false);
        }

        private void output(boolean endOfInput) {
            CoderResult result;
            this.buffer.flip();
            do {
                result = this.decoder.decode(this.buffer, this.outBuffer, endOfInput);
                JsConsolePrintStream.this.print(new String(this.outChars, 0, this.outBuffer.position()));
                this.outBuffer.rewind();
            } while (result == CoderResult.OVERFLOW);
            this.buffer.compact();
        }
    }
}

