/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

public class SystemClassTransformer
implements ClassHolderTransformer {
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        for (MethodHolder method : cls.getMethods()) {
            if (method.getProgram() == null) continue;
            this.transformProgram(method.getProgram());
        }
    }

    private void transformProgram(Program program) {
        for (BasicBlock block : program.getBasicBlocks()) {
            for (Instruction insn : block) {
                GetFieldInstruction getField;
                FieldReference field;
                if (!(insn instanceof GetFieldInstruction) || !(field = (getField = (GetFieldInstruction)insn).getField()).getClassName().equals("java.lang.System")) continue;
                switch (field.getFieldName()) {
                    case "err": 
                    case "out": 
                    case "in": {
                        InvokeInstruction invoke = new InvokeInstruction();
                        invoke.setType(InvocationType.SPECIAL);
                        invoke.setMethod(new MethodReference("java.lang.System", field.getFieldName(), new ValueType[]{getField.getFieldType()}));
                        invoke.setReceiver(getField.getReceiver());
                        invoke.setLocation(insn.getLocation());
                        insn.replace((Instruction)invoke);
                        break;
                    }
                }
            }
        }
    }
}

