/*
 *  Copyright 2023 Alexey Andreev.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.teavm.classlib.impl.text;

import java.math.BigInteger;

public final class FloatSynthesizerGenerator {
    private FloatSynthesizerGenerator() {
    }

    public static void main(String[] args) {
        var mantissaList = new int[100];
        var expList = new int[100];

        var binOneShift = 256;
        var binOne = BigInteger.ONE.shiftLeft(binOneShift);
        var dec = BigInteger.valueOf(100000000);
        for (var i = 0; i <= 50; ++i) {
            var quot = binOne.divide(dec);
            mantissaList[50 - i] = extractInt(quot);
            var exp = quot.bitLength() - binOneShift + 30;
            expList[50 - i] = 127 + exp;
            dec = dec.multiply(BigInteger.valueOf(10));
        }

        dec = BigInteger.valueOf(100000000);
        var q = BigInteger.TEN;
        for (var i = 1; i < 50; ++i) {
            var quot = q.shiftLeft(binOneShift).divide(dec);
            mantissaList[50 + i] = extractInt(quot);
            var exp = quot.bitLength() - binOneShift + 30;
            expList[50 + i] = 127 + exp;
            q = q.multiply(BigInteger.TEN);
        }

        System.out.println("[mantissa]");
        for (var value : mantissaList) {
            System.out.println(value + ",");
        }
        System.out.println();

        System.out.println("[exponent]");
        for (var value : expList) {
            System.out.println(value + ",");
        }
    }

    private static int extractInt(BigInteger n) {
        return n.shiftRight(n.bitLength() - 33).add(BigInteger.ONE).shiftRight(1).intValue();
    }
}
