/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashMap;
import java.util.Map;
import org.teavm.classlib.java.util.jar.TAttributes;
import org.teavm.classlib.java.util.jar.TInitManifest;

public class TManifest
implements Cloneable {
    static final int LINE_LENGTH_LIMIT = 72;
    private static final byte[] LINE_SEPARATOR = new byte[]{13, 10};
    private static final byte[] VALUE_SEPARATOR = new byte[]{58, 32};
    private static final TAttributes.Name NAME_ATTRIBUTE = new TAttributes.Name("Name");
    private TAttributes mainAttributes = new TAttributes();
    private HashMap<String, TAttributes> entries = new HashMap();
    private HashMap<String, Chunk> chunks;
    private TInitManifest im;
    private int mainEnd;

    public TManifest() {
    }

    public TManifest(InputStream is) throws IOException {
        this.read(is);
    }

    public TManifest(TManifest man) {
        this.mainAttributes = (TAttributes)man.mainAttributes.clone();
        this.entries = (HashMap)((HashMap)man.getEntries()).clone();
    }

    TManifest(InputStream is, boolean readChunks) throws IOException {
        if (readChunks) {
            this.chunks = new HashMap();
        }
        this.read(is);
    }

    public void clear() {
        this.im = null;
        this.entries.clear();
        this.mainAttributes.clear();
    }

    public TAttributes getAttributes(String name) {
        return this.getEntries().get(name);
    }

    public Map<String, TAttributes> getEntries() {
        return this.entries;
    }

    public TAttributes getMainAttributes() {
        return this.mainAttributes;
    }

    public Object clone() {
        return new TManifest(this);
    }

    public void write(OutputStream os) throws IOException {
        TManifest.write(this, os);
    }

    public void read(InputStream is) throws IOException {
        byte[] buf = this.readFully(is);
        if (buf.length == 0) {
            return;
        }
        byte b = buf[buf.length - 1];
        if (0 == b || 26 == b) {
            buf[buf.length - 1] = 10;
        }
        this.im = new TInitManifest(buf, this.mainAttributes, null);
        this.mainEnd = this.im.getPos();
        this.im.initEntries(this.entries, this.chunks);
        this.im = null;
    }

    private byte[] readFully(InputStream is) throws IOException {
        byte[] buffer = new byte[4096];
        int count = is.read(buffer);
        int nextByte = is.read();
        if (nextByte == -1) {
            byte[] dest = new byte[count];
            System.arraycopy(buffer, 0, dest, 0, count);
            return dest;
        }
        if (!this.containsLine(buffer, count)) {
            throw new IOException("Manifest is too long");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(count * 2);
        baos.write(buffer, 0, count);
        baos.write(nextByte);
        while ((count = is.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        return baos.toByteArray();
    }

    private boolean containsLine(byte[] buffer, int length) {
        for (int i = 0; i < length; ++i) {
            if (buffer[i] != 10 && buffer[i] != 13) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.mainAttributes.hashCode() ^ this.getEntries().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!this.mainAttributes.equals(((TManifest)o).mainAttributes)) {
            return false;
        }
        return this.getEntries().equals(((TManifest)o).getEntries());
    }

    Chunk getChunk(String name) {
        return this.chunks.get(name);
    }

    void removeChunks() {
        this.chunks = null;
    }

    int getMainAttributesEnd() {
        return this.mainEnd;
    }

    static void write(TManifest manifest, OutputStream out) throws IOException {
        CharsetEncoder encoder = Charset.defaultCharset().newEncoder();
        ByteBuffer buffer = ByteBuffer.allocate(512);
        String version = manifest.mainAttributes.getValue(TAttributes.Name.MANIFEST_VERSION);
        if (version != null) {
            TManifest.writeEntry(out, TAttributes.Name.MANIFEST_VERSION, version, encoder, buffer);
            for (Object o : manifest.mainAttributes.keySet()) {
                TAttributes.Name name = (TAttributes.Name)o;
                if (name.equals(TAttributes.Name.MANIFEST_VERSION)) continue;
                TManifest.writeEntry(out, name, manifest.mainAttributes.getValue(name), encoder, buffer);
            }
        }
        out.write(LINE_SEPARATOR);
        for (String key : manifest.getEntries().keySet()) {
            TManifest.writeEntry(out, NAME_ATTRIBUTE, key, encoder, buffer);
            TAttributes attrib = manifest.entries.get(key);
            for (Object o : attrib.keySet()) {
                TAttributes.Name name = (TAttributes.Name)o;
                TManifest.writeEntry(out, name, attrib.getValue(name), encoder, buffer);
            }
            out.write(LINE_SEPARATOR);
        }
    }

    private static void writeEntry(OutputStream os, TAttributes.Name name, String value, CharsetEncoder encoder, ByteBuffer bBuf) throws IOException {
        byte[] out = name.getBytes();
        if (out.length > 72) {
            throw new IOException();
        }
        os.write(out);
        os.write(VALUE_SEPARATOR);
        encoder.reset();
        bBuf.clear().limit(72 - out.length - 2);
        CharBuffer cBuf = CharBuffer.wrap(value);
        while (true) {
            CoderResult r;
            if (CoderResult.UNDERFLOW == (r = encoder.encode(cBuf, bBuf, true))) {
                r = encoder.flush(bBuf);
            }
            os.write(bBuf.array(), bBuf.arrayOffset(), bBuf.position());
            os.write(LINE_SEPARATOR);
            if (CoderResult.UNDERFLOW == r) break;
            os.write(32);
            bBuf.clear().limit(71);
        }
    }

    static class Chunk {
        int start;
        int end;

        Chunk(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

