/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.charset.impl;

import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.TCoderResult;
import org.teavm.classlib.java.nio.charset.impl.TBufferedEncoder;

public class TAsciiEncoder
extends TBufferedEncoder {
    public TAsciiEncoder(TCharset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected TCoderResult arrayEncode(char[] inArray, int inPos, int inSize, byte[] outArray, int outPos, int outSize, TBufferedEncoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            char c;
            if (Character.isHighSurrogate(c = inArray[inPos++])) {
                if (inPos >= inSize) {
                    if (!controller.hasMoreInput(2)) {
                        result = TCoderResult.UNDERFLOW;
                        break;
                    }
                    --inPos;
                    break;
                }
                char next = inArray[inPos];
                if (!Character.isLowSurrogate(next)) {
                    result = TCoderResult.malformedForLength(1);
                    break;
                }
                --inPos;
                result = TCoderResult.unmappableForLength(2);
                break;
            }
            if (Character.isLowSurrogate(c)) {
                result = TCoderResult.malformedForLength(1);
            }
            if (c < '\u0080') {
                outArray[outPos++] = (byte)c;
                continue;
            }
            result = TCoderResult.unmappableForLength(1);
            --inPos;
            break;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }
}

