/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.net;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;

public final class TURLDecoder {
    private TURLDecoder() {
    }

    @Deprecated
    public static String decode(String s) {
        return TURLDecoder.decode(s, StandardCharsets.UTF_8);
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        Objects.requireNonNull(enc);
        if (enc.isEmpty()) {
            throw new UnsupportedEncodingException("Invalid parameter: enc");
        }
        if (s.indexOf(37) == -1) {
            if (s.indexOf(43) == -1) {
                return s;
            }
            char[] str = s.toCharArray();
            for (int i = 0; i < str.length; ++i) {
                if (str[i] != '+') continue;
                str[i] = 32;
            }
            return new String(str);
        }
        Charset charset = null;
        try {
            charset = Charset.forName(enc);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            UnsupportedEncodingException toThrow = new UnsupportedEncodingException();
            toThrow.initCause(e);
            throw toThrow;
        }
        return TURLDecoder.decode(s, charset);
    }

    private static String decode(String s, Charset charset) {
        char[] strBuf = new char[s.length()];
        byte[] buf = new byte[s.length() / 3];
        int bufLen = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '+') {
                strBuf[bufLen] = 32;
            } else {
                if (c == '%') {
                    int len = 0;
                    do {
                        if (i + 2 >= s.length()) {
                            throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                        }
                        int d1 = Character.digit(s.charAt(i + 1), 16);
                        int d2 = Character.digit(s.charAt(i + 2), 16);
                        if (d1 == -1 || d2 == -1) {
                            throw new IllegalArgumentException("Invalid % sequence (" + s.substring(i, i + 3) + ") at " + i);
                        }
                        buf[len++] = (byte)((d1 << 4) + d2);
                    } while ((i += 3) < s.length() && s.charAt(i) == '%');
                    CharBuffer cb = charset.decode(ByteBuffer.wrap(buf, 0, len));
                    len = cb.length();
                    System.arraycopy(cb.array(), 0, strBuf, bufLen, len);
                    bufLen += len;
                    continue;
                }
                strBuf[bufLen] = c;
            }
            ++i;
            ++bufLen;
        }
        return new String(strBuf, 0, bufLen);
    }
}

