/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.teavm.classlib.java.io.TFilterOutputStream;
import org.teavm.classlib.java.io.TUnsupportedEncodingException;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.nio.TByteBuffer;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.nio.charset.TCharsetEncoder;
import org.teavm.classlib.java.nio.charset.TCodingErrorAction;
import org.teavm.classlib.java.nio.charset.TIllegalCharsetNameException;
import org.teavm.classlib.java.nio.charset.TUnsupportedCharsetException;
import org.teavm.classlib.java.nio.charset.impl.TUTF8Charset;
import org.teavm.classlib.java.util.TFormatter;

public class TPrintStream
extends TFilterOutputStream
implements Appendable {
    private boolean autoFlush;
    private boolean errorState;
    private TStringBuilder sb = new TStringBuilder();
    private char[] buffer = new char[32];
    private TCharset charset;

    public TPrintStream(OutputStream out, boolean autoFlush, String encoding) throws TUnsupportedEncodingException {
        super(out);
        this.autoFlush = autoFlush;
        try {
            this.charset = TCharset.forName(encoding.toString());
        }
        catch (TIllegalCharsetNameException | TUnsupportedCharsetException e) {
            throw new TUnsupportedEncodingException(encoding);
        }
    }

    public TPrintStream(OutputStream out, boolean autoFlush) {
        super(out);
        this.autoFlush = autoFlush;
        this.charset = TUTF8Charset.INSTANCE;
    }

    public TPrintStream(OutputStream out, boolean autoFlush, TCharset charset) {
        super(out);
        this.autoFlush = autoFlush;
        this.charset = charset;
    }

    public TPrintStream(OutputStream out, TCharset charset) {
        this(out, false, charset);
    }

    public TPrintStream(OutputStream out) {
        this(out, false);
    }

    public boolean checkError() {
        this.flush();
        return this.errorState;
    }

    protected void setError() {
        this.errorState = true;
    }

    protected void clearError() {
        this.errorState = false;
    }

    @Override
    public void write(int b) {
        if (!this.check()) {
            return;
        }
        try {
            this.out.write(b);
        }
        catch (IOException e) {
            this.errorState = true;
        }
        if (this.autoFlush && !this.errorState) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (!this.check()) {
            return;
        }
        try {
            this.out.write(b, off, len);
        }
        catch (IOException e) {
            this.errorState = true;
        }
    }

    @Override
    public void close() {
        if (!this.checkError()) {
            return;
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.errorState = true;
        }
        finally {
            this.out = null;
        }
    }

    @Override
    public void flush() {
        if (!this.check()) {
            return;
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.errorState = true;
        }
    }

    private boolean check() {
        if (this.out == null) {
            this.errorState = true;
        }
        return !this.errorState;
    }

    public void print(char[] s) {
        this.print(s, 0, s.length);
    }

    protected void print(CharSequence s, int begin, int end) {
        this.printCharBuffer(TCharBuffer.wrap(s, begin, end), begin, end);
    }

    protected void print(char[] s, int begin, int end) {
        this.printCharBuffer(TCharBuffer.wrap(s, begin, end - begin), begin, end);
    }

    private void printCharBuffer(TCharBuffer src, int begin, int end) {
        boolean overflow;
        byte[] destBytes = new byte[TMath.max(16, TMath.min(end - begin, 1024))];
        TByteBuffer dest = TByteBuffer.wrap(destBytes);
        TCharsetEncoder encoder = this.charset.newEncoder().onMalformedInput(TCodingErrorAction.REPLACE).onUnmappableCharacter(TCodingErrorAction.REPLACE);
        do {
            overflow = encoder.encode(src, dest, true).isOverflow();
            this.write(destBytes, 0, dest.position());
            dest.clear();
        } while (overflow);
        do {
            overflow = encoder.flush(dest).isOverflow();
            this.write(destBytes, 0, dest.position());
            dest.clear();
        } while (overflow);
    }

    public void print(char c) {
        this.buffer[0] = c;
        this.print(this.buffer, 0, 1);
    }

    public void print(int i) {
        this.sb.append(i);
        this.printSB();
    }

    public void print(long l) {
        this.sb.append(l);
        this.printSB();
    }

    public void print(double d) {
        this.sb.append(d);
        this.printSB();
    }

    public void print(String s) {
        this.sb.append(s);
        this.printSB();
    }

    public void print(TObject s) {
        this.sb.append(s);
        this.printSB();
    }

    public void println(int i) {
        this.sb.append(i).append('\n');
        this.printSB();
    }

    public void println(long l) {
        this.sb.append(l).append('\n');
        this.printSB();
    }

    public void println(double d) {
        this.sb.append(d).append('\n');
        this.printSB();
    }

    public void println(float d) {
        this.sb.append(d).append('\n');
        this.printSB();
    }

    public void println(char c) {
        this.sb.append(c).append('\n');
        this.printSB();
    }

    public void println(boolean b) {
        this.sb.append(b).append('\n');
        this.printSB();
    }

    public void println(String s) {
        this.sb.append(s).append('\n');
        this.printSB();
    }

    public void println(TObject s) {
        this.sb.append(s).append('\n');
        this.printSB();
    }

    public void println() {
        this.print('\n');
    }

    public TPrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public TPrintStream printf(Locale locale, String format, Object ... args) {
        return this.format(locale, format, args);
    }

    public TPrintStream format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    public TPrintStream format(Locale locale, String format, Object ... args) {
        if (args == null) {
            args = new Object[1];
        }
        TFormatter formatter = new TFormatter(this, locale);
        formatter.format(format, args);
        if (formatter.ioException() != null) {
            this.errorState = true;
        }
        return this;
    }

    private void printSB() {
        char[] buffer = this.sb.length() > this.buffer.length ? new char[this.sb.length()] : this.buffer;
        this.sb.getChars(0, this.sb.length(), buffer, 0);
        this.print(buffer, 0, this.sb.length());
        this.sb.setLength(0);
    }

    @Override
    public TPrintStream append(CharSequence csq) {
        if (csq != null) {
            this.print(csq, 0, csq.length());
        } else {
            this.print("null");
        }
        return this;
    }

    @Override
    public TPrintStream append(CharSequence csq, int start, int end) {
        this.print(csq == null ? "null" : csq, start, end);
        return this;
    }

    @Override
    public TPrintStream append(char c) {
        this.print(c);
        return this;
    }
}

