/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import org.teavm.classlib.java.io.TOutputStream;
import org.teavm.classlib.java.io.TUnsupportedEncodingException;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.nio.charset.TCharset;
import org.teavm.classlib.java.util.TArrays;

public class TByteArrayOutputStream
extends TOutputStream {
    protected byte[] buf;
    protected int count;

    public TByteArrayOutputStream() {
        this(32);
    }

    public TByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.count + len);
        for (int i = 0; i < len; ++i) {
            this.buf[this.count++] = b[off++];
        }
    }

    private void ensureCapacity(int capacity) {
        if (this.buf.length < capacity) {
            capacity = TMath.max(capacity, this.buf.length * 3 / 2);
            this.buf = TArrays.copyOf(this.buf, capacity);
        }
    }

    public byte[] toByteArray() {
        return TArrays.copyOf(this.buf, this.count);
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public TString toString(TString charsetName) throws TUnsupportedEncodingException {
        return new TString(this.buf, 0, this.count, charsetName);
    }

    public TString toString(TCharset charset) {
        return new TString(this.buf, 0, this.count, charset);
    }

    public void writeTo(TOutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }
}

