/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.teavm.classlib.impl.Base46;
import org.teavm.classlib.impl.CharFlow;
import org.teavm.classlib.impl.tz.AliasDateTimeZone;
import org.teavm.classlib.impl.tz.DateTimeZone;
import org.teavm.classlib.impl.tz.StorableDateTimeZone;
import org.teavm.classlib.impl.tz.TimeZoneGenerator;
import org.teavm.classlib.impl.tz.ZoneInfoCompiler;

public class TimeZoneCache {
    public void write(OutputStream output, Collection<StorableDateTimeZone> timeZones) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (StorableDateTimeZone timeZone : timeZones) {
            writer.append(timeZone.getID()).append(' ');
            timeZone.write(sb);
            writer.append(sb);
            sb.setLength(0);
            writer.append('\n');
        }
        writer.flush();
    }

    public Map<String, StorableDateTimeZone> read(InputStream input) throws IOException {
        String line;
        HashMap<String, StorableDateTimeZone> result = new HashMap<String, StorableDateTimeZone>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        ArrayList<String> aliasLines = new ArrayList<String>();
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            int index = line.indexOf(32);
            String id = line.substring(0, index);
            String data = line.substring(index + 1);
            CharFlow flow = new CharFlow(data.toCharArray());
            if (Base46.decodeUnsigned(flow) == 4) {
                aliasLines.add(line);
                continue;
            }
            result.put(id, StorableDateTimeZone.read(id, data));
        }
        for (String aliasLine : aliasLines) {
            int index = aliasLine.indexOf(32);
            String id = aliasLine.substring(0, index);
            String data = aliasLine.substring(index + 1);
            CharFlow flow = new CharFlow(data.toCharArray());
            Base46.decode(flow);
            result.put(id, new AliasDateTimeZone(id, (DateTimeZone)result.get(data.substring(flow.pointer))));
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        ZoneInfoCompiler compiler = new ZoneInfoCompiler();
        TimeZoneGenerator.compile(compiler, TimeZoneCache.class.getClassLoader());
        File file = new File(args[0]);
        file.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(file);){
            new TimeZoneCache().write(output, compiler.compile().values());
        }
    }
}

