/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.flavour.expr.Location;
import org.teavm.flavour.templates.tree.AttributeComponentBinding;
import org.teavm.flavour.templates.tree.DOMAttribute;
import org.teavm.flavour.templates.tree.TemplateNode;
import org.teavm.flavour.templates.tree.TemplateNodeVisitor;

public class DOMElement
extends TemplateNode {
    private String name;
    private List<TemplateNode> childNodes = new ArrayList<TemplateNode>();
    private List<DOMAttribute> attributes = new ArrayList<DOMAttribute>();
    private List<DOMAttribute> readonlyAttributes = Collections.unmodifiableList(this.attributes);
    private List<AttributeComponentBinding> attributeComponents = new ArrayList<AttributeComponentBinding>();

    public DOMElement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TemplateNode> getChildNodes() {
        return this.childNodes;
    }

    public DOMAttribute getAttribute(String name) {
        for (DOMAttribute attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public DOMAttribute createAttribute(String name) {
        return this.createAttribute(name, null);
    }

    public DOMAttribute createAttribute(String name, Location location) {
        DOMAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            attribute = new DOMAttribute(name, "");
            attribute.setLocation(location);
            this.attributes.add(attribute);
        }
        return attribute;
    }

    public void deleteAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!this.attributes.get(i).getName().equals(name)) continue;
            this.attributes.remove(i);
            break;
        }
    }

    public void setAttribute(String name, String value) {
        this.createAttribute(name).setValue(value);
    }

    public void setAttribute(String name, String value, Location location) {
        this.createAttribute(name, location).setValue(value);
    }

    public List<DOMAttribute> getAttributes() {
        return this.readonlyAttributes;
    }

    public List<AttributeComponentBinding> getAttributeComponents() {
        return this.attributeComponents;
    }

    @Override
    public void acceptVisitor(TemplateNodeVisitor visitor) {
        visitor.visit(this);
    }
}

