/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.parsing;

import org.teavm.flavour.expr.Location;
import org.teavm.flavour.expr.plan.ArithmeticCastPlan;
import org.teavm.flavour.expr.plan.ArrayConstructionPlan;
import org.teavm.flavour.expr.plan.ArrayLengthPlan;
import org.teavm.flavour.expr.plan.BinaryPlan;
import org.teavm.flavour.expr.plan.CastFromIntegerPlan;
import org.teavm.flavour.expr.plan.CastPlan;
import org.teavm.flavour.expr.plan.CastToIntegerPlan;
import org.teavm.flavour.expr.plan.ConditionalPlan;
import org.teavm.flavour.expr.plan.ConstantPlan;
import org.teavm.flavour.expr.plan.ConstructionPlan;
import org.teavm.flavour.expr.plan.FieldAssignmentPlan;
import org.teavm.flavour.expr.plan.FieldPlan;
import org.teavm.flavour.expr.plan.GetArrayElementPlan;
import org.teavm.flavour.expr.plan.InstanceOfPlan;
import org.teavm.flavour.expr.plan.InvocationPlan;
import org.teavm.flavour.expr.plan.LambdaPlan;
import org.teavm.flavour.expr.plan.LogicalBinaryPlan;
import org.teavm.flavour.expr.plan.NegatePlan;
import org.teavm.flavour.expr.plan.NotPlan;
import org.teavm.flavour.expr.plan.ObjectPlan;
import org.teavm.flavour.expr.plan.ObjectPlanEntry;
import org.teavm.flavour.expr.plan.Plan;
import org.teavm.flavour.expr.plan.PlanVisitor;
import org.teavm.flavour.expr.plan.ReferenceEqualityPlan;
import org.teavm.flavour.expr.plan.ThisPlan;
import org.teavm.flavour.expr.plan.VariablePlan;

class PlanOffsetVisitor
implements PlanVisitor {
    private int offset;

    PlanOffsetVisitor(int offset) {
        this.offset = offset;
    }

    public void visit(ConstantPlan plan) {
        this.apply((Plan)plan);
    }

    public void visit(VariablePlan plan) {
        this.apply((Plan)plan);
    }

    public void visit(BinaryPlan plan) {
        this.apply((Plan)plan);
        plan.getFirstOperand().acceptVisitor((PlanVisitor)this);
        plan.getSecondOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(NegatePlan plan) {
        this.apply((Plan)plan);
        plan.getOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(ReferenceEqualityPlan plan) {
        this.apply((Plan)plan);
        plan.getFirstOperand().acceptVisitor((PlanVisitor)this);
        plan.getSecondOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(LogicalBinaryPlan plan) {
        this.apply((Plan)plan);
        plan.getFirstOperand().acceptVisitor((PlanVisitor)this);
        plan.getSecondOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(NotPlan plan) {
        this.apply((Plan)plan);
        plan.getOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(CastPlan plan) {
        this.apply((Plan)plan);
        plan.getOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(ArithmeticCastPlan plan) {
        this.apply((Plan)plan);
        plan.getOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(CastFromIntegerPlan plan) {
        this.apply((Plan)plan);
        plan.getOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(CastToIntegerPlan plan) {
        this.apply((Plan)plan);
        plan.getOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(GetArrayElementPlan plan) {
        this.apply((Plan)plan);
        plan.getArray().acceptVisitor((PlanVisitor)this);
        plan.getIndex().acceptVisitor((PlanVisitor)this);
    }

    public void visit(ArrayLengthPlan plan) {
        this.apply((Plan)plan);
        plan.getArray().acceptVisitor((PlanVisitor)this);
    }

    public void visit(FieldPlan plan) {
        this.apply((Plan)plan);
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor((PlanVisitor)this);
        }
    }

    public void visit(FieldAssignmentPlan plan) {
        this.apply((Plan)plan);
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor((PlanVisitor)this);
        }
        plan.getValue().acceptVisitor((PlanVisitor)this);
    }

    public void visit(InstanceOfPlan plan) {
        this.apply((Plan)plan);
        plan.getOperand().acceptVisitor((PlanVisitor)this);
    }

    public void visit(InvocationPlan plan) {
        this.apply((Plan)plan);
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor((PlanVisitor)this);
        }
        for (Plan arg : plan.getArguments()) {
            arg.acceptVisitor((PlanVisitor)this);
        }
    }

    public void visit(ConstructionPlan plan) {
        this.apply((Plan)plan);
        for (Plan arg : plan.getArguments()) {
            arg.acceptVisitor((PlanVisitor)this);
        }
    }

    public void visit(ArrayConstructionPlan plan) {
        this.apply((Plan)plan);
        for (Plan elem : plan.getElements()) {
            elem.acceptVisitor((PlanVisitor)this);
        }
    }

    public void visit(ConditionalPlan plan) {
        this.apply((Plan)plan);
        plan.getCondition().acceptVisitor((PlanVisitor)this);
        plan.getConsequent().acceptVisitor((PlanVisitor)this);
        plan.getAlternative().acceptVisitor((PlanVisitor)this);
    }

    public void visit(ThisPlan plan) {
        this.apply((Plan)plan);
    }

    public void visit(LambdaPlan plan) {
        this.apply((Plan)plan);
        plan.getBody().acceptVisitor((PlanVisitor)this);
    }

    public void visit(ObjectPlan plan) {
        this.apply((Plan)plan);
        for (ObjectPlanEntry entry : plan.getEntries()) {
            entry.getValue().acceptVisitor((PlanVisitor)this);
        }
    }

    private void apply(Plan plan) {
        if (plan.getLocation() != null) {
            plan.setLocation(new Location(plan.getLocation().getStart() + this.offset, plan.getLocation().getEnd() + this.offset));
        }
    }
}

