/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.parsing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import org.apache.commons.lang3.StringUtils;
import org.teavm.flavour.expr.ClassResolver;
import org.teavm.flavour.expr.Compiler;
import org.teavm.flavour.expr.CompilerCommons;
import org.teavm.flavour.expr.Diagnostic;
import org.teavm.flavour.expr.ImportingClassResolver;
import org.teavm.flavour.expr.Location;
import org.teavm.flavour.expr.Scope;
import org.teavm.flavour.expr.TypeEstimator;
import org.teavm.flavour.expr.TypedPlan;
import org.teavm.flavour.expr.ast.Expr;
import org.teavm.flavour.expr.ast.LambdaExpr;
import org.teavm.flavour.expr.ast.ObjectEntry;
import org.teavm.flavour.expr.ast.ObjectExpr;
import org.teavm.flavour.expr.plan.LambdaPlan;
import org.teavm.flavour.expr.plan.ObjectPlan;
import org.teavm.flavour.expr.plan.ObjectPlanEntry;
import org.teavm.flavour.expr.plan.Plan;
import org.teavm.flavour.expr.plan.PlanVisitor;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.MapSubstitutions;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeInference;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.Variance;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.MethodDescriber;
import org.teavm.flavour.templates.OptionalBinding;
import org.teavm.flavour.templates.SettingsObject;
import org.teavm.flavour.templates.parsing.AttributeComponentMetadata;
import org.teavm.flavour.templates.parsing.BaseComponentMetadata;
import org.teavm.flavour.templates.parsing.ComponentAttributeMetadata;
import org.teavm.flavour.templates.parsing.ComponentAttributeType;
import org.teavm.flavour.templates.parsing.ComponentParser;
import org.teavm.flavour.templates.parsing.ElementComponentMetadata;
import org.teavm.flavour.templates.parsing.NestedComponent;
import org.teavm.flavour.templates.parsing.PlanOffsetVisitor;
import org.teavm.flavour.templates.parsing.ResourceProvider;
import org.teavm.flavour.templates.tree.AttributeComponentBinding;
import org.teavm.flavour.templates.tree.ComponentBinding;
import org.teavm.flavour.templates.tree.ComponentFunctionBinding;
import org.teavm.flavour.templates.tree.ComponentVariableBinding;
import org.teavm.flavour.templates.tree.DOMElement;
import org.teavm.flavour.templates.tree.DOMText;
import org.teavm.flavour.templates.tree.NestedComponentBinding;
import org.teavm.flavour.templates.tree.TemplateNode;

public class Parser {
    private ClassDescriberRepository classRepository;
    private ImportingClassResolver classResolver;
    private ResourceProvider resourceProvider;
    private GenericTypeNavigator typeNavigator;
    private Map<String, List<ElementComponentMetadata>> avaliableComponents = new HashMap<String, List<ElementComponentMetadata>>();
    private Map<String, List<AttributeComponentMetadata>> avaliableAttrComponents = new HashMap<String, List<AttributeComponentMetadata>>();
    private Map<String, ElementComponentMetadata> components = new HashMap<String, ElementComponentMetadata>();
    private Map<String, AttributeComponentMetadata> attrComponents = new HashMap<String, AttributeComponentMetadata>();
    private List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private Map<String, Deque<ValueType>> variables = new HashMap<String, Deque<ValueType>>();
    private Source source;
    private int position;

    public Parser(ClassDescriberRepository classRepository, ClassResolver classResolver, ResourceProvider resourceProvider) {
        this.classRepository = classRepository;
        this.classResolver = new ImportingClassResolver(classResolver);
        this.resourceProvider = resourceProvider;
        this.classResolver.importPackage("java.lang");
        this.typeNavigator = new GenericTypeNavigator(classRepository);
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public boolean wasSuccessful() {
        return this.diagnostics.isEmpty();
    }

    public List<TemplateNode> parse(Reader reader, String className) throws IOException {
        this.source = new Source(reader);
        this.use((Segment)this.source, "std", "org.teavm.flavour.components.standard");
        this.use((Segment)this.source, "event", "org.teavm.flavour.components.events");
        this.use((Segment)this.source, "attr", "org.teavm.flavour.components.attributes");
        this.use((Segment)this.source, "html", "org.teavm.flavour.components.html");
        ClassDescriber cls = this.classRepository.describe(className);
        TypeArgument[] typeArguments = new TypeArgument[]{};
        if (cls != null) {
            TypeVar[] typeVariables = cls.getTypeVariables();
            typeArguments = new TypeArgument[typeVariables.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                Set upperBound = typeVariables[i].getUpperBound();
                typeArguments[i] = new TypeArgument(Variance.COVARIANT, upperBound.isEmpty() ? GenericType.OBJECT : (GenericType)upperBound.iterator().next());
            }
        }
        this.pushVar("this", (ValueType)new GenericClass(className, typeArguments));
        this.position = this.source.getBegin();
        ArrayList<TemplateNode> nodes = new ArrayList<TemplateNode>();
        this.parseSegment(this.source.getEnd(), nodes, elem -> true);
        this.popVar("this");
        this.source = null;
        return nodes;
    }

    private void parseSegment(int limit, List<TemplateNode> result, Predicate<Element> filter) {
        while (this.position < limit) {
            DOMText text;
            Tag tag = this.source.getNextTag(this.position);
            if (tag == null || tag.getBegin() > limit) {
                if (this.position < limit) {
                    text = new DOMText(this.parseText(this.position, limit));
                    text.setLocation(new Location(this.position, limit));
                    result.add(text);
                }
                this.position = limit;
                break;
            }
            if (this.position < tag.getBegin()) {
                text = new DOMText(this.parseText(this.position, tag.getBegin()));
                text.setLocation(new Location(this.position, tag.getBegin()));
                result.add(text);
            }
            this.position = tag.getEnd();
            this.parseTag(tag, result, filter);
        }
    }

    private String parseText(int start, int end) {
        CharacterReference ref;
        StringBuilder sb = new StringBuilder();
        while (start < end && (ref = this.source.getNextCharacterReference(start)) != null && ref.getBegin() < end) {
            sb.append(this.source.subSequence(start, ref.getBegin()));
            sb.append(ref.getChar());
            start = ref.getEnd();
        }
        sb.append(this.source.subSequence(start, end));
        return sb.toString();
    }

    private void parseTag(Tag tag, List<TemplateNode> result, Predicate<Element> filter) {
        if (tag instanceof StartTag) {
            StartTag startTag = (StartTag)tag;
            if (startTag.getStartTagType() == StartTagType.XML_PROCESSING_INSTRUCTION) {
                this.parseProcessingInstruction(startTag);
            } else if (startTag.getStartTagType() == StartTagType.NORMAL) {
                if (filter.test(tag.getElement())) {
                    TemplateNode node = this.parseElement(tag.getElement());
                    if (node != null) {
                        result.add(node);
                    }
                } else {
                    this.position = tag.getElement().getEnd();
                }
            }
        }
    }

    private TemplateNode parseElement(Element elem) {
        if (elem.getName().indexOf(58) > 0) {
            return this.parseComponent(elem);
        }
        return this.parseDomElement(elem);
    }

    private TemplateNode parseDomElement(Element elem) {
        DOMElement templateElem = new DOMElement(elem.getName());
        templateElem.setLocation(new Location(elem.getBegin(), elem.getEnd()));
        for (int i = 0; i < elem.getAttributes().size(); ++i) {
            Attribute attr = (Attribute)elem.getAttributes().get(i);
            if (attr.getName().indexOf(58) > 0) {
                AttributeComponentBinding component = this.parseAttributeComponent(attr);
                if (component == null) continue;
                templateElem.getAttributeComponents().add(component);
                continue;
            }
            templateElem.setAttribute(attr.getName(), attr.getValue(), new Location(attr.getBegin(), attr.getEnd()));
        }
        HashSet<String> vars = new HashSet<String>();
        for (AttributeComponentBinding attrComponent : templateElem.getAttributeComponents()) {
            for (ComponentVariableBinding var : attrComponent.getVariables()) {
                vars.add(var.getName());
                this.pushVar(var.getName(), var.getValueType());
            }
        }
        this.parseSegment(elem.getEnd(), templateElem.getChildNodes(), child -> true);
        for (String var : vars) {
            this.popVar(var);
        }
        return templateElem;
    }

    private TemplateNode parseComponent(Element elem) {
        int prefixLength = elem.getName().indexOf(58);
        String prefix = elem.getName().substring(0, prefixLength);
        String name = elem.getName().substring(prefixLength + 1);
        String fullName = prefix + ":" + name;
        ElementComponentMetadata componentMeta = this.resolveComponent(prefix, name);
        if (componentMeta == null) {
            this.error(elem.getStartTag().getNameSegment(), "Undefined component " + fullName);
            return null;
        }
        ArrayList<PostponedComponentParse> postponedList = new ArrayList<PostponedComponentParse>();
        ComponentBinding node = this.parseComponent(componentMeta, prefix, name, elem, postponedList, new MapSubstitutions(new HashMap()));
        this.completeComponentParsing(postponedList, componentMeta, (Segment)elem);
        this.position = elem.getEnd();
        return node;
    }

    private ComponentBinding parseComponent(ElementComponentMetadata componentMeta, String prefix, String name, Element elem, List<PostponedComponentParse> postponed, MapSubstitutions typeVars) {
        TypeVar freshVar;
        ComponentBinding component = new ComponentBinding(componentMeta.cls.getName(), name);
        component.setLocation(new Location(elem.getBegin(), elem.getEnd()));
        if (componentMeta.nameSetter != null) {
            component.setElementNameMethodName(componentMeta.nameSetter.getName());
        }
        ArrayList<GenericReference> typeVarsBackup = new ArrayList<GenericReference>();
        HashMap<TypeVar, TypeVar> freshVarsMap = new HashMap<TypeVar, TypeVar>();
        for (TypeVar typeVar : componentMeta.typeVarsToRefresh) {
            freshVar = new TypeVar();
            freshVarsMap.put(typeVar, freshVar);
            typeVarsBackup.add(typeVars.getMap().put(typeVar, new GenericReference(freshVar)));
        }
        for (TypeVar typeVar : componentMeta.typeVarsToRefresh) {
            freshVar = (TypeVar)freshVarsMap.get(typeVar);
            if (!typeVar.getLowerBound().isEmpty()) {
                freshVar.withLowerBound((GenericType[])typeVar.getLowerBound().stream().map(bound -> bound.substitute((Substitutions)typeVars)).toArray(GenericType[]::new));
                continue;
            }
            freshVar.withUpperBound((GenericType[])typeVar.getUpperBound().stream().map(bound -> bound.substitute((Substitutions)typeVars)).toArray(GenericType[]::new));
        }
        ArrayList<PostponedAttributeParse> attributesParse = new ArrayList<PostponedAttributeParse>();
        for (ComponentAttributeMetadata attrMeta : componentMeta.attributes.values()) {
            Attribute attr = elem.getAttributes().get(attrMeta.name);
            if (attr == null) {
                if (!attrMeta.required) continue;
                this.error((Segment)elem.getStartTag(), "Missing required attribute: " + attrMeta.name);
                continue;
            }
            if (attrMeta.type == null || attrMeta.valueType == null) continue;
            PostponedAttributeParse attrParse = new PostponedAttributeParse();
            attrParse.meta = attrMeta;
            attrParse.node = attr;
            if (attrMeta.type == ComponentAttributeType.FUNCTION || attrMeta.type == ComponentAttributeType.BIDIRECTIONAL) {
                if (attrMeta.type == ComponentAttributeType.FUNCTION && this.isSettingsObject(attrMeta.valueType)) {
                    attrParse.objectExpr = this.parseObject(attr.getValueSegment());
                    attrParse.type = attrMeta.valueType;
                } else {
                    attrParse.expr = this.parseExpr(attr.getValueSegment());
                }
            }
            if (attrParse.meta.valueType != null) {
                attrParse.type = attrParse.meta.valueType;
                if (attrParse.type instanceof GenericType) {
                    attrParse.type = ((GenericType)attrParse.type).substitute((Substitutions)typeVars);
                }
            }
            if (attrParse.meta.sam != null) {
                attrParse.sam = attrParse.meta.sam.substitute((Substitutions)typeVars);
            }
            if (attrParse.meta.altSam != null) {
                attrParse.altSam = attrParse.meta.altSam.substitute((Substitutions)typeVars);
            }
            attributesParse.add(attrParse);
        }
        for (Attribute attr : elem.getAttributes()) {
            if (componentMeta.attributes.containsKey(attr.getName())) continue;
            this.error((Segment)attr, "Unknown attribute " + attr.getName() + " for component " + prefix + ":" + name);
        }
        PostponedComponentParse postponedComponentParse = new PostponedComponentParse(this.position, componentMeta, component, elem);
        postponedComponentParse.attributes.addAll(attributesParse);
        postponedComponentParse.freshTypeVars.addAll(freshVarsMap.values());
        postponed.add(postponedComponentParse);
        this.parseSegment(elem.getEnd(), new ArrayList<TemplateNode>(), child -> {
            int nestedPrefixLength = child.getName().indexOf(58);
            if (nestedPrefixLength > 0) {
                NestedComponent nested;
                String nestedPrefix = child.getName().substring(0, nestedPrefixLength);
                String nestedName = child.getName().substring(nestedPrefixLength + 1);
                if (nestedPrefix.equals(prefix) && (nested = this.resolveNestedComponent(componentMeta, nestedName)) != null) {
                    ComponentBinding nestedNode = this.parseComponent(nested.metadata, prefix, nestedName, (Element)child, postponed, typeVars);
                    NestedComponentBinding binding = this.getNestedComponentBinding(component, nested);
                    binding.getComponents().add(nestedNode);
                }
            }
            return false;
        });
        this.validateNestedComponents(component, componentMeta, elem, prefix);
        for (int i = 0; i < componentMeta.typeVarsToRefresh.size(); ++i) {
            TypeVar typeVar = componentMeta.typeVarsToRefresh.get(i);
            if (typeVarsBackup.get(i) != null) {
                typeVars.getMap().put(typeVar, typeVarsBackup.get(i));
                continue;
            }
            typeVars.getMap().remove(typeVar);
        }
        return component;
    }

    private boolean isSettingsObject(ValueType type) {
        if (!(type instanceof GenericClass)) {
            return false;
        }
        GenericMethod sam = this.typeNavigator.findSingleAbstractMethod((GenericClass)type);
        if (sam == null) {
            return false;
        }
        type = sam.getActualReturnType();
        if (type instanceof GenericClass) {
            String className = ((GenericClass)type).getName();
            ClassDescriber cls = this.classRepository.describe(className);
            return cls.getAnnotation(SettingsObject.class.getName()) != null;
        }
        return false;
    }

    private void completeComponentParsing(List<PostponedComponentParse> postponed, BaseComponentMetadata componentMetadata, Segment segment) {
        TypeInference inference = new TypeInference(this.typeNavigator);
        inference.addVariables(Arrays.asList(componentMetadata.cls.getTypeVariables()));
        TypeEstimator estimator = new TypeEstimator(inference, (ClassResolver)this.classResolver, this.typeNavigator, (Scope)new TemplateScope());
        boolean inferenceFailed = false;
        for (PostponedComponentParse postponedComponentParse : postponed) {
            inference.addVariables(postponedComponentParse.freshTypeVars);
            for (PostponedAttributeParse postponedAttributeParse : postponedComponentParse.attributes) {
                if (postponedAttributeParse.expr == null || postponedAttributeParse.meta.type != ComponentAttributeType.FUNCTION) continue;
                if (postponedAttributeParse.expr instanceof LambdaExpr) {
                    postponedAttributeParse.typeEstimate = estimator.estimateLambda((LambdaExpr)postponedAttributeParse.expr, postponedAttributeParse.sam);
                } else {
                    ValueType valueType = postponedAttributeParse.sam.getActualReturnType();
                    postponedAttributeParse.typeEstimate = estimator.estimate(postponedAttributeParse.expr, valueType);
                }
                if (postponedAttributeParse.typeEstimate == null || inferenceFailed || inference.subtypeConstraint(postponedAttributeParse.typeEstimate, postponedAttributeParse.sam.getActualReturnType())) continue;
                inferenceFailed = true;
            }
        }
        if (!inference.resolve()) {
            this.error(segment, "Could not infer component type");
            inferenceFailed = true;
        }
        if (inferenceFailed) {
            inference = new TypeInference(this.typeNavigator);
            inference.addVariables(Arrays.asList(componentMetadata.cls.getTypeVariables()));
        }
        TypeInference varInference = new TypeInference(this.typeNavigator);
        varInference.addVariables(Arrays.asList(componentMetadata.cls.getTypeVariables()));
        for (PostponedComponentParse postponedComponentParse : postponed) {
            varInference.addVariables(postponedComponentParse.freshTypeVars);
            for (PostponedAttributeParse postponedAttributeParse : postponedComponentParse.attributes) {
                TypedPlan plan;
                if (postponedAttributeParse.expr == null && postponedAttributeParse.objectExpr == null) continue;
                MethodDescriber setter = postponedAttributeParse.meta.setter;
                GenericClass type = postponedAttributeParse.sam.getActualOwner().substitute(inference.getSubstitutions());
                TypedPlan typedPlan = plan = postponedAttributeParse.expr != null ? this.compileExpr(postponedAttributeParse.node.getValueSegment(), postponedAttributeParse.expr, type) : this.compileSettingsObject(postponedAttributeParse.node.getValueSegment(), postponedAttributeParse.objectExpr, type);
                if (plan == null) continue;
                ComponentFunctionBinding computationBinding = new ComponentFunctionBinding(setter.getOwner().getName(), setter.getName(), (LambdaPlan)plan.getPlan(), postponedAttributeParse.sam.getActualOwner().getName());
                postponedComponentParse.component.getComputations().add(computationBinding);
                if (!varInference.equalConstraint(plan.getType(), (ValueType)postponedAttributeParse.sam.getActualOwner())) {
                    inferenceFailed = true;
                }
                if (postponedAttributeParse.meta.type != ComponentAttributeType.BIDIRECTIONAL) continue;
                setter = postponedAttributeParse.meta.altSetter;
                type = postponedAttributeParse.altSam.getActualOwner().substitute(inference.getSubstitutions());
                plan = this.compileExpr(postponedAttributeParse.node.getValueSegment(), postponedAttributeParse.expr, type);
                if (plan == null) continue;
                computationBinding = new ComponentFunctionBinding(setter.getOwner().getName(), setter.getName(), (LambdaPlan)plan.getPlan(), postponedAttributeParse.altSam.getActualOwner().getName());
                postponedComponentParse.component.getComputations().add(computationBinding);
            }
        }
        if (!varInference.resolve() && !inferenceFailed) {
            this.error(segment, "Could not infer component type");
        }
        HashMap<String, ValueType> hashMap = new HashMap<String, ValueType>();
        for (PostponedComponentParse postponedComponentParse : postponed) {
            for (PostponedAttributeParse attrParse : postponedComponentParse.attributes) {
                if (attrParse.meta.type != ComponentAttributeType.VARIABLE) continue;
                MethodDescriber getter = attrParse.meta.getter;
                String varName = attrParse.node.getValue();
                ValueType type = attrParse.type;
                if (type instanceof GenericType) {
                    type = ((GenericType)type).substitute(varInference.getSubstitutions());
                }
                if (hashMap.containsKey(varName)) {
                    this.error(attrParse.node.getValueSegment(), "Variable " + varName + " is already used by the same component");
                } else {
                    hashMap.put(varName, type);
                    this.pushVar(varName, type);
                }
                ComponentVariableBinding varBinding = new ComponentVariableBinding(getter.getOwner().getName(), getter.getName(), varName, getter.getRawReturnType(), type);
                postponedComponentParse.component.getVariables().add(varBinding);
            }
        }
        Set set = postponed.stream().map(parse -> parse.elem).collect(Collectors.toSet());
        for (PostponedComponentParse postponedComponentParse : postponed) {
            this.position = postponedComponentParse.position;
            this.parseSegment(postponedComponentParse.elem.getEnd(), postponedComponentParse.component.getContentNodes(), child -> !elementsToSkip.contains(child));
            if (postponedComponentParse.metadata.contentSetter != null) {
                postponedComponentParse.component.setContentMethodName(postponedComponentParse.metadata.contentSetter.getName());
                continue;
            }
            if (!postponedComponentParse.metadata.ignoreContent && !this.isEmptyContent(postponedComponentParse.component.getContentNodes())) {
                this.error((Segment)postponedComponentParse.elem, "Component " + postponedComponentParse.metadata.cls.getName() + " should not have any content");
            }
            postponedComponentParse.component.getContentNodes().clear();
        }
        for (String string : hashMap.keySet()) {
            this.popVar(string);
        }
    }

    private void validateNestedComponents(ComponentBinding component, ElementComponentMetadata metadata, Element elem, String prefix) {
        for (NestedComponent nestedMetadata : metadata.nestedComponents) {
            String name;
            NestedComponentBinding nestedComponent = this.findNestedComponentBinding(component, nestedMetadata);
            CharSequence[] nameRules = nestedMetadata.metadata.nameRules;
            String string = name = nameRules.length == 1 ? nameRules[0] : "{" + String.join((CharSequence)"|", nameRules) + "}";
            if (nestedMetadata.required) {
                if (nestedComponent != null) continue;
                this.error((Segment)elem, "Nested component " + prefix + ":" + name + " required but none encountered");
                continue;
            }
            if (nestedMetadata.multiple || nestedComponent.getComponents().size() <= 1) continue;
            this.error((Segment)elem, "Nested component " + prefix + ":" + name + " should encounter only once");
        }
    }

    private NestedComponentBinding getNestedComponentBinding(ComponentBinding component, NestedComponent metadata) {
        NestedComponentBinding binding = this.findNestedComponentBinding(component, metadata);
        if (binding == null) {
            binding = new NestedComponentBinding(metadata.setter.getDescriber().getOwner().getName(), metadata.setter.getDescriber().getName(), metadata.metadata.cls.getName(), metadata.multiple);
            component.getNestedComponents().add(binding);
        }
        return binding;
    }

    private NestedComponentBinding findNestedComponentBinding(ComponentBinding component, NestedComponent metadata) {
        for (NestedComponentBinding binding : component.getNestedComponents()) {
            if (!binding.getMethodName().equals(metadata.setter.getDescriber().getName()) || !binding.getMethodOwner().equals(metadata.setter.getDescriber().getOwner().getName())) continue;
            return binding;
        }
        return null;
    }

    private boolean isEmptyContent(List<TemplateNode> nodes) {
        for (TemplateNode node : nodes) {
            if (node instanceof DOMText) {
                DOMText text = (DOMText)node;
                if (this.isEmptyText(text.getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isEmptyText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c) || c == '\r' || c == '\n' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private AttributeComponentBinding parseAttributeComponent(Attribute attr) {
        int prefixLength = attr.getName().indexOf(58);
        String prefix = attr.getName().substring(0, prefixLength);
        String name = attr.getName().substring(prefixLength + 1);
        String fullName = prefix + ":" + name;
        AttributeComponentMetadata componentMeta = this.resolveAttrComponent(prefix, name);
        if (componentMeta == null) {
            this.error(attr.getNameSegment(), "Undefined component " + fullName);
            return null;
        }
        AttributeComponentBinding component = new AttributeComponentBinding(componentMeta.cls.getName(), name);
        component.setLocation(new Location(attr.getBegin(), attr.getEnd()));
        if (componentMeta.nameSetter != null) {
            component.setElementNameMethodName(componentMeta.nameSetter.getName());
        }
        MethodDescriber getter = componentMeta.getter;
        MethodDescriber setter = componentMeta.setter;
        switch (componentMeta.type) {
            case VARIABLE: {
                String varName = attr.getValue();
                ComponentVariableBinding varBinding = new ComponentVariableBinding(setter.getOwner().getName(), getter.getName(), varName, getter.getRawReturnType(), componentMeta.valueType);
                component.getVariables().add(varBinding);
                break;
            }
            case FUNCTION: 
            case BIDIRECTIONAL: {
                TypedPlan plan;
                TypeInference inference = new TypeInference(this.typeNavigator);
                inference.addVariables(Arrays.asList(componentMeta.cls.getTypeVariables()));
                TypeEstimator estimator = new TypeEstimator(inference, (ClassResolver)this.classResolver, this.typeNavigator, (Scope)new TemplateScope());
                Expr expr = null;
                if (this.isSettingsObject(componentMeta.valueType)) {
                    ObjectExpr objectExpr = this.parseObject(attr.getValueSegment());
                    if (objectExpr == null || (plan = this.compileSettingsObject(attr.getValueSegment(), objectExpr, componentMeta.sam.getActualOwner())) == null) {
                        break;
                    }
                } else {
                    expr = this.parseExpr(attr.getValueSegment());
                    if (expr == null) break;
                    if (expr instanceof LambdaExpr) {
                        estimator.estimateLambda((LambdaExpr)expr, componentMeta.sam);
                    } else {
                        estimator.estimate(expr, componentMeta.sam.getActualReturnType());
                    }
                    if (!inference.resolve()) {
                        this.error(attr.getValueSegment(), "Could not infer type");
                        return component;
                    }
                    plan = this.compileExpr(attr.getValueSegment(), expr, componentMeta.sam.getActualOwner().substitute(inference.getSubstitutions()));
                    if (plan == null) break;
                }
                ComponentFunctionBinding functionBinding = new ComponentFunctionBinding(setter.getOwner().getName(), setter.getName(), (LambdaPlan)plan.getPlan(), componentMeta.sam.getDescriber().getOwner().getName());
                component.getFunctions().add(functionBinding);
                if (componentMeta.type != ComponentAttributeType.BIDIRECTIONAL || expr == null) break;
                setter = componentMeta.altSetter;
                GenericClass type = componentMeta.altSam.getActualOwner().substitute(inference.getSubstitutions());
                plan = this.compileExpr(attr.getValueSegment(), expr, type);
                ComponentFunctionBinding computationBinding = new ComponentFunctionBinding(setter.getOwner().getName(), setter.getName(), (LambdaPlan)plan.getPlan(), componentMeta.altSam.getActualOwner().getName());
                component.getFunctions().add(computationBinding);
                break;
            }
        }
        return component;
    }

    private Expr parseExpr(Segment segment) {
        boolean hasErrors = false;
        org.teavm.flavour.expr.Parser exprParser = new org.teavm.flavour.expr.Parser((ClassResolver)this.classResolver);
        Expr expr = exprParser.parse(segment.toString());
        int offset = segment.getBegin();
        for (Diagnostic diagnostic : exprParser.getDiagnostics()) {
            diagnostic = new Diagnostic(offset + diagnostic.getStart(), offset + diagnostic.getEnd(), diagnostic.getMessage());
            this.diagnostics.add(diagnostic);
            hasErrors = true;
        }
        if (hasErrors) {
            return null;
        }
        return expr;
    }

    private ObjectExpr parseObject(Segment segment) {
        boolean hasErrors = false;
        org.teavm.flavour.expr.Parser exprParser = new org.teavm.flavour.expr.Parser((ClassResolver)this.classResolver);
        ObjectExpr expr = exprParser.parseObject(segment.toString());
        int offset = segment.getBegin();
        for (Diagnostic diagnostic : exprParser.getDiagnostics()) {
            diagnostic = new Diagnostic(offset + diagnostic.getStart(), offset + diagnostic.getEnd(), diagnostic.getMessage());
            this.diagnostics.add(diagnostic);
            hasErrors = true;
        }
        if (hasErrors) {
            return null;
        }
        return expr;
    }

    private TypedPlan compileExpr(Segment segment, Expr expr, GenericClass type) {
        boolean hasErrors = false;
        Compiler compiler = new Compiler(this.classRepository, (ClassResolver)this.classResolver, (Scope)new TemplateScope());
        TypedPlan result = compiler.compileLambda(expr, type);
        PlanOffsetVisitor offsetVisitor = new PlanOffsetVisitor(segment.getBegin());
        result.getPlan().acceptVisitor((PlanVisitor)offsetVisitor);
        int offset = segment.getBegin();
        for (Diagnostic diagnostic : compiler.getDiagnostics()) {
            diagnostic = new Diagnostic(offset + diagnostic.getStart(), offset + diagnostic.getEnd(), diagnostic.getMessage());
            this.diagnostics.add(diagnostic);
            hasErrors = true;
        }
        if (hasErrors) {
            return null;
        }
        return result;
    }

    private TypedPlan compileSettingsObject(Segment segment, ObjectExpr expr, GenericClass type) {
        boolean hasErrors = false;
        Compiler compiler = new Compiler(this.classRepository, (ClassResolver)this.classResolver, (Scope)new TemplateScope());
        GenericMethod sam = this.typeNavigator.findSingleAbstractMethod(type);
        if (sam.getActualParameterTypes().length != 0 || !(sam.getActualReturnType() instanceof GenericClass)) {
            this.diagnostics.add(new Diagnostic(segment.getBegin(), segment.getEnd(), "Wrong target lambda type"));
            return null;
        }
        GenericClass objectType = (GenericClass)sam.getActualReturnType();
        ObjectPlan objectPlan = new ObjectPlan(objectType.getName());
        Set<String> requiredFields = this.collectRequiredFields(objectType.getName());
        for (ObjectEntry entry : expr.getEntries()) {
            GenericMethod setter = this.findSetter(segment, objectType, entry.getKey());
            if (setter == null) continue;
            requiredFields.remove(entry.getKey());
            TypedPlan valuePlan = compiler.compile(entry.getValue(), setter.getActualParameterTypes()[0]);
            ObjectPlanEntry planEntry = new ObjectPlanEntry(setter.getDescriber().getName(), CompilerCommons.methodToDesc((MethodDescriber)setter.getDescriber()), valuePlan.getPlan());
            objectPlan.getEntries().add(planEntry);
        }
        LambdaPlan plan = new LambdaPlan((Plan)objectPlan, type.getName(), sam.getDescriber().getName(), CompilerCommons.methodToDesc((MethodDescriber)sam.getDescriber()), Collections.emptyList());
        TypedPlan result = new TypedPlan((Plan)plan, (ValueType)type);
        if (!requiredFields.isEmpty()) {
            this.diagnostics.add(new Diagnostic(segment.getBegin(), segment.getEnd(), "Required field not set: " + requiredFields.iterator().next()));
        }
        PlanOffsetVisitor offsetVisitor = new PlanOffsetVisitor(segment.getBegin());
        plan.acceptVisitor((PlanVisitor)offsetVisitor);
        int offset = segment.getBegin();
        for (Diagnostic diagnostic : compiler.getDiagnostics()) {
            diagnostic = new Diagnostic(offset + diagnostic.getStart(), offset + diagnostic.getEnd(), diagnostic.getMessage());
            this.diagnostics.add(diagnostic);
            hasErrors = true;
        }
        if (hasErrors) {
            return null;
        }
        return result;
    }

    private Set<String> collectRequiredFields(String className) {
        ClassDescriber cls = this.classRepository.describe(className);
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (MethodDescriber method : cls.getMethods()) {
            if (!method.getName().startsWith("set") || method.getName().length() <= 3 || !Character.isUpperCase(method.getName().charAt(3)) || method.getParameterTypes().length != 1 || method.getAnnotation(OptionalBinding.class.getName()) != null) continue;
            char firstChar = Character.toLowerCase(method.getName().charAt(3));
            fields.add(firstChar + method.getName().substring(4));
        }
        return fields;
    }

    private GenericMethod findSetter(Segment segment, GenericClass cls, String name) {
        String methodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        GenericMethod[] candidates = this.typeNavigator.findMethods(cls, methodName, 1);
        if (candidates.length == 0) {
            this.diagnostics.add(new Diagnostic(segment.getBegin(), segment.getEnd(), "Setter not found for key: " + name));
            return null;
        }
        if (candidates.length > 1) {
            this.diagnostics.add(new Diagnostic(segment.getBegin(), segment.getEnd(), "Ambiguous key: " + name));
            return null;
        }
        return candidates[0];
    }

    private void pushVar(String name, ValueType type) {
        Deque stack = this.variables.computeIfAbsent(name, k -> new ArrayDeque());
        stack.push(type);
    }

    private void popVar(String name) {
        Deque<ValueType> stack = this.variables.get(name);
        if (stack != null) {
            stack.pop();
            if (stack.isEmpty()) {
                this.variables.remove(name);
            }
        }
    }

    private ElementComponentMetadata resolveComponent(String prefix, String name) {
        String fullName = prefix + ":" + name;
        ElementComponentMetadata component = this.components.get(fullName);
        if (component == null) {
            List<ElementComponentMetadata> byPrefix = this.avaliableComponents.get(prefix);
            if (byPrefix != null) {
                block0: for (ElementComponentMetadata testComponent : byPrefix) {
                    for (String rule : testComponent.nameRules) {
                        if (!this.matchRule(rule, name)) continue;
                        component = testComponent;
                        break block0;
                    }
                }
            }
            this.components.put(fullName, component);
        }
        return component;
    }

    private NestedComponent resolveNestedComponent(ElementComponentMetadata outer, String name) {
        for (NestedComponent nested : outer.nestedComponents) {
            if (!Arrays.stream(nested.metadata.nameRules).anyMatch(rule -> this.matchRule((String)rule, name))) continue;
            return nested;
        }
        return null;
    }

    private AttributeComponentMetadata resolveAttrComponent(String prefix, String name) {
        String fullName = prefix + ":" + name;
        AttributeComponentMetadata component = this.attrComponents.get(fullName);
        if (component == null) {
            List<AttributeComponentMetadata> byPrefix = this.avaliableAttrComponents.get(prefix);
            if (byPrefix != null) {
                block0: for (AttributeComponentMetadata testComponent : byPrefix) {
                    for (String rule : testComponent.nameRules) {
                        if (!this.matchRule(rule, name)) continue;
                        component = testComponent;
                        break block0;
                    }
                }
            }
            this.attrComponents.put(fullName, component);
        }
        return component;
    }

    private boolean matchRule(String rule, String name) {
        int index = rule.indexOf(42);
        if (index < 0) {
            return name.equals(rule);
        }
        String prefix = rule.substring(0, index);
        String suffix = rule.substring(index + 1);
        return name.startsWith(prefix) && name.endsWith(suffix) && prefix.length() + suffix.length() < name.length();
    }

    private void parseProcessingInstruction(StartTag tag) {
        if (tag.getName().equals("?import")) {
            this.parseImport(tag);
        } else if (tag.getName().equals("?use")) {
            this.parseUse(tag);
        }
    }

    private void parseImport(StartTag tag) {
        String importedName = this.normalizeQualifiedName(tag.getTagContent().toString());
        if (importedName.endsWith(".*")) {
            this.classResolver.importPackage(importedName);
        } else if (this.classResolver.findClass(importedName) == null) {
            this.error(tag.getTagContent(), "Class was not found: " + importedName);
        } else {
            this.classResolver.importClass(importedName);
        }
    }

    private void parseUse(StartTag tag) {
        String content = tag.getTagContent().toString();
        String[] parts = StringUtils.split((String)content, (String)":", (int)2);
        if (parts.length != 2) {
            this.error(tag.getTagContent(), "Illegal syntax for 'use' instruction");
            return;
        }
        String prefix = parts[0].trim();
        String packageName = this.normalizeQualifiedName(parts[1]);
        this.use(tag.getTagContent(), prefix, packageName);
    }

    private void use(Segment segment, String prefix, String packageName) {
        String resourceName = "META-INF/flavour/component-packages/" + packageName;
        try (InputStream input = this.resourceProvider.openResource(resourceName);){
            String line;
            if (input == null) {
                this.error(segment, "Component package was not found: " + packageName);
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            ArrayList<ElementComponentMetadata> componentList = new ArrayList<ElementComponentMetadata>();
            ArrayList<AttributeComponentMetadata> attributeComponentList = new ArrayList<AttributeComponentMetadata>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                String className = packageName + "." + line;
                ClassDescriber cls = this.classRepository.describe(className);
                if (cls == null) {
                    this.error(segment, "Class " + className + " declared by component package was not found");
                    continue;
                }
                ComponentParser componentParser = new ComponentParser(this.classRepository, this.diagnostics, segment);
                Object componentMetadata = componentParser.parse(cls);
                if (componentMetadata instanceof ElementComponentMetadata) {
                    ElementComponentMetadata elemComponentMeta = (ElementComponentMetadata)componentMetadata;
                    componentList.add(elemComponentMeta);
                    continue;
                }
                if (!(componentMetadata instanceof AttributeComponentMetadata)) continue;
                AttributeComponentMetadata attrComponentMeta = (AttributeComponentMetadata)componentMetadata;
                attributeComponentList.add(attrComponentMeta);
            }
            this.avaliableComponents.put(prefix, componentList);
            this.avaliableAttrComponents.put(prefix, attributeComponentList);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception occurred parsing HTML input", e);
        }
    }

    private String normalizeQualifiedName(String text) {
        Object[] parts = StringUtils.split((String)text.trim(), (char)'.');
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = ((String)parts[i]).trim();
        }
        return StringUtils.join((Object[])parts, (char)'.');
    }

    private void error(Segment segment, String message) {
        this.diagnostics.add(new Diagnostic(segment.getBegin(), segment.getEnd(), message));
    }

    class TemplateScope
    implements Scope {
        TemplateScope() {
        }

        public ValueType variableType(String variableName) {
            Deque stack = (Deque)Parser.this.variables.get(variableName);
            return stack != null && !stack.isEmpty() ? (ValueType)stack.peek() : null;
        }
    }

    static class PostponedAttributeParse {
        ComponentAttributeMetadata meta;
        Attribute node;
        Expr expr;
        ObjectExpr objectExpr;
        ValueType type;
        ValueType typeEstimate;
        GenericMethod sam;
        GenericMethod altSam;

        PostponedAttributeParse() {
        }
    }

    static class PostponedComponentParse {
        int position;
        ElementComponentMetadata metadata;
        ComponentBinding component;
        Element elem;
        List<PostponedAttributeParse> attributes = new ArrayList<PostponedAttributeParse>();
        List<TypeVar> freshTypeVars = new ArrayList<TypeVar>();

        PostponedComponentParse(int position, ElementComponentMetadata metadata, ComponentBinding component, Element elem) {
            this.position = position;
            this.metadata = metadata;
            this.component = component;
            this.elem = elem;
        }
    }
}

