/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.parsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.htmlparser.jericho.Segment;
import org.teavm.flavour.expr.Diagnostic;
import org.teavm.flavour.expr.type.GenericClass;
import org.teavm.flavour.expr.type.GenericMethod;
import org.teavm.flavour.expr.type.GenericReference;
import org.teavm.flavour.expr.type.GenericType;
import org.teavm.flavour.expr.type.GenericTypeNavigator;
import org.teavm.flavour.expr.type.MapSubstitutions;
import org.teavm.flavour.expr.type.Substitutions;
import org.teavm.flavour.expr.type.TypeArgument;
import org.teavm.flavour.expr.type.TypeVar;
import org.teavm.flavour.expr.type.ValueType;
import org.teavm.flavour.expr.type.ValueTypeFormatter;
import org.teavm.flavour.expr.type.Variance;
import org.teavm.flavour.expr.type.meta.AnnotationDescriber;
import org.teavm.flavour.expr.type.meta.AnnotationList;
import org.teavm.flavour.expr.type.meta.AnnotationString;
import org.teavm.flavour.expr.type.meta.ClassDescriber;
import org.teavm.flavour.expr.type.meta.ClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.MethodDescriber;
import org.teavm.flavour.templates.BindAttribute;
import org.teavm.flavour.templates.BindAttributeComponent;
import org.teavm.flavour.templates.BindContent;
import org.teavm.flavour.templates.BindElement;
import org.teavm.flavour.templates.BindElementName;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.IgnoreContent;
import org.teavm.flavour.templates.ModifierTarget;
import org.teavm.flavour.templates.OptionalBinding;
import org.teavm.flavour.templates.Slot;
import org.teavm.flavour.templates.parsing.AttributeComponentMetadata;
import org.teavm.flavour.templates.parsing.BaseComponentMetadata;
import org.teavm.flavour.templates.parsing.ComponentAttributeMetadata;
import org.teavm.flavour.templates.parsing.ComponentAttributeType;
import org.teavm.flavour.templates.parsing.ElementComponentMetadata;
import org.teavm.flavour.templates.parsing.NestedComponent;

class ComponentParser {
    private ClassDescriberRepository classRepository;
    private List<Diagnostic> diagnostics;
    private Segment segment;
    private GenericTypeNavigator typeNavigator;

    ComponentParser(ClassDescriberRepository classRepository, List<Diagnostic> diagnostics, Segment segment) {
        this.classRepository = classRepository;
        this.diagnostics = diagnostics;
        this.segment = segment;
        this.typeNavigator = new GenericTypeNavigator(classRepository);
    }

    public Object parse(ClassDescriber cls) {
        AnnotationDescriber annot = cls.getAnnotation(BindElement.class.getName());
        AnnotationDescriber attrAnnot = cls.getAnnotation(BindAttributeComponent.class.getName());
        if (annot != null) {
            return this.parseElement(cls, annot);
        }
        if (attrAnnot != null) {
            return this.parseAttribute(cls, attrAnnot);
        }
        this.error("Class " + cls.getName() + " declared by component package is not marked either by " + BindElement.class.getName() + " or by " + BindAttributeComponent.class.getName());
        return null;
    }

    private ElementComponentMetadata parseElement(ClassDescriber cls, AnnotationDescriber annot) {
        return this.parseElement(this.typeNavigator.getGenericClass(cls.getName()), annot, true);
    }

    private ElementComponentMetadata parseElement(GenericClass genericCls, AnnotationDescriber annot, boolean top) {
        ElementComponentMetadata metadata = new ElementComponentMetadata();
        metadata.nameRules = this.parseNames(annot);
        metadata.cls = this.typeNavigator.getClassRepository().describe(genericCls.getName());
        ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>();
        for (TypeArgument arg : genericCls.getArguments()) {
            if (arg.getVariance() == Variance.INVARIANT) {
                typeArguments.add(arg);
                continue;
            }
            TypeVar freshVar = new TypeVar();
            if (arg.getVariance() == Variance.COVARIANT) {
                freshVar.withUpperBound(new GenericType[]{arg.getBound()});
            } else {
                freshVar.withLowerBound(new GenericType[]{arg.getBound()});
            }
            typeArguments.add(TypeArgument.invariant((GenericType)new GenericReference(freshVar)));
            metadata.typeVarsToRefresh.add(freshVar);
        }
        genericCls = new GenericClass(genericCls.getName(), typeArguments);
        if (top) {
            this.parseConstructor(metadata);
        } else {
            this.parseNestedConstructor(metadata);
        }
        this.parseIgnoreContent(metadata);
        for (GenericMethod method : this.collectMethods(genericCls)) {
            this.parseMethod(metadata, method);
        }
        return metadata;
    }

    private AttributeComponentMetadata parseAttribute(ClassDescriber cls, AnnotationDescriber annot) {
        AttributeComponentMetadata metadata = new AttributeComponentMetadata();
        metadata.nameRules = this.parseNames(annot);
        metadata.cls = cls;
        this.parseAttributeConstructor(metadata);
        GenericClass genericCls = this.typeNavigator.getGenericClass(cls.getName());
        for (GenericMethod method : this.collectMethods(genericCls)) {
            this.parseAttributeMethod(metadata, method);
        }
        if (metadata.type == null) {
            return null;
        }
        return metadata;
    }

    private String[] parseNames(AnnotationDescriber annot) {
        List names = ((AnnotationList)annot.getValue((String)"name")).value;
        String[] result = new String[names.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((AnnotationString)names.get((int)i)).value;
        }
        return result;
    }

    private void parseConstructor(ElementComponentMetadata metadata) {
        ClassDescriber cls = metadata.cls;
        metadata.constructor = cls.getMethod("<init>", new ValueType[]{new GenericClass(Slot.class.getName())});
        if (metadata.constructor == null) {
            this.error("Class " + cls.getName() + " declared by component package does not have constructor that takes " + Slot.class.getName());
        }
    }

    private void parseNestedConstructor(ElementComponentMetadata metadata) {
        ClassDescriber cls = metadata.cls;
        metadata.constructor = cls.getMethod("<init>", new ValueType[0]);
        if (metadata.constructor == null) {
            this.error("Class " + cls.getName() + " declared by component package does not have constructor that takes zero arguments");
        }
    }

    private void parseAttributeConstructor(AttributeComponentMetadata metadata) {
        ClassDescriber cls = metadata.cls;
        metadata.constructor = cls.getMethod("<init>", new ValueType[]{new GenericClass(ModifierTarget.class.getName())});
        if (metadata.constructor == null) {
            this.error("Class " + cls.getName() + " declared by component package does not have constructor that takes " + ModifierTarget.class.getName());
        }
    }

    private void parseIgnoreContent(ElementComponentMetadata metadata) {
        if (metadata.cls.getAnnotation(IgnoreContent.class.getName()) != null) {
            metadata.ignoreContent = true;
        }
    }

    private List<GenericMethod> collectMethods(GenericClass genericCls) {
        ArrayList<GenericMethod> methods = new ArrayList<GenericMethod>();
        this.collectMethodsRec(genericCls, new HashSet<GenericClass>(), new HashSet<MethodWithParams>(), methods);
        return methods;
    }

    private void collectMethodsRec(GenericClass genericCls, Set<GenericClass> visited, Set<MethodWithParams> visitedMethods, List<GenericMethod> methods) {
        if (!visited.add(genericCls)) {
            return;
        }
        this.collectMethods(genericCls, visitedMethods, methods);
        GenericClass parent = this.typeNavigator.getParent(genericCls);
        if (parent != null) {
            this.collectMethodsRec(parent, visited, new HashSet<MethodWithParams>(visitedMethods), methods);
        }
        for (GenericClass iface : this.typeNavigator.getInterfaces(genericCls)) {
            this.collectMethodsRec(iface, visited, new HashSet<MethodWithParams>(visitedMethods), methods);
        }
    }

    private void collectMethods(GenericClass genericCls, Set<MethodWithParams> visitedMethods, List<GenericMethod> methods) {
        ClassDescriber clsDesc = this.classRepository.describe(genericCls.getName());
        if (clsDesc == null) {
            return;
        }
        HashMap<TypeVar, GenericType> vars = new HashMap<TypeVar, GenericType>();
        TypeVar[] typeVars = clsDesc.getTypeVariables();
        for (int i = 0; i < typeVars.length; ++i) {
            vars.put(typeVars[i], ((TypeArgument)genericCls.getArguments().get(i)).getBound());
        }
        MapSubstitutions subst = new MapSubstitutions(vars);
        for (MethodDescriber methodDesc : clsDesc.getMethods()) {
            ValueType[] argumentTypes = methodDesc.getParameterTypes();
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (!(argumentTypes[i] instanceof GenericType)) continue;
                argumentTypes[i] = ((GenericType)argumentTypes[i]).substitute((Substitutions)subst);
            }
            ValueType returnType = methodDesc.getReturnType();
            if (returnType instanceof GenericType) {
                returnType = ((GenericType)returnType).substitute((Substitutions)subst);
            }
            GenericMethod method = new GenericMethod(methodDesc, genericCls, argumentTypes, returnType);
            if (!visitedMethods.add(new MethodWithParams(methodDesc.getName(), argumentTypes))) continue;
            methods.add(method);
        }
    }

    private void parseMethod(ElementComponentMetadata metadata, GenericMethod method) {
        HashSet<AnnotationDescriber> bindings = new HashSet<AnnotationDescriber>();
        this.parseBindContent(metadata, method, bindings);
        this.parseBindAttribute(metadata, method, bindings);
        this.parseBindElement(metadata, method, bindings);
        this.parseBindName(metadata, method);
    }

    private void parseAttributeMethod(AttributeComponentMetadata metadata, GenericMethod method) {
        this.parseBindAttributeContent(metadata, method);
        this.parseBindName(metadata, method);
    }

    private void parseBindContent(ElementComponentMetadata metadata, GenericMethod method, Set<AnnotationDescriber> bindings) {
        AnnotationDescriber binding = method.getDescriber().getAnnotation(BindContent.class.getName());
        if (binding == null) {
            return;
        }
        bindings.add(binding);
        if (metadata.contentSetter != null) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindContent.class.getName() + " but another method is already bound to content of component " + metadata.cls.getName() + ": " + this.methodToString(metadata.contentSetter));
            return;
        }
        metadata.contentSetter = method.getDescriber();
        ValueType[] arguments = method.getActualParameterTypes();
        if (arguments.length != 1) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked with " + BindContent.class.getName() + " and therefore should take exactly 1 argument, but takes " + arguments.length);
            return;
        }
        if (!arguments[0].equals(new GenericClass(Fragment.class.getName()))) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked with " + BindContent.class.getName() + " and therefore should take " + Fragment.class.getName() + " as an argument, but takes " + arguments[0]);
        }
    }

    private void parseBindAttributeContent(AttributeComponentMetadata metadata, GenericMethod method) {
        AnnotationDescriber binding = method.getDescriber().getAnnotation(BindContent.class.getName());
        if (binding == null) {
            return;
        }
        if (metadata.type != null) {
            if (!this.tryBidirectional(metadata, method)) {
                this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindContent.class.getName() + " but another method is already bound to content of component " + metadata.cls.getName() + ": " + this.methodToString(metadata.setter));
            }
            return;
        }
        metadata.setter = method.getDescriber();
        ValueType[] arguments = method.getActualParameterTypes();
        if (arguments.length != 1) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindContent.class.getName() + " and therefore must take exactly 1 argument, but takes " + arguments.length);
            return;
        }
        metadata.setter = method.getDescriber();
        ComponentAttributeMetadata attrMeta = new ComponentAttributeMetadata();
        if (!this.parseAttributeType(attrMeta, arguments[0], method.getActualReturnType())) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " takes argument of type that can't be mapped to an attribute: " + arguments[0]);
        } else {
            metadata.type = attrMeta.type;
            metadata.valueType = attrMeta.valueType;
            metadata.sam = attrMeta.sam;
        }
    }

    private void parseBindAttribute(ElementComponentMetadata metadata, GenericMethod method, Set<AnnotationDescriber> bindings) {
        AnnotationDescriber binding = method.getDescriber().getAnnotation(BindAttribute.class.getName());
        if (binding == null) {
            return;
        }
        bindings.add(binding);
        String name = ((AnnotationString)binding.getValue((String)"name")).value;
        ComponentAttributeMetadata existing = metadata.attributes.get(name);
        if (existing != null) {
            if (!this.tryBidirectional(existing, method)) {
                this.error("Method " + this.methodToString(method.getDescriber()) + " is bound to " + name + " attribute, but it is already bound to another method: " + this.methodToString(existing.setter));
            }
            return;
        }
        ComponentAttributeMetadata attrMetadata = new ComponentAttributeMetadata();
        attrMetadata.name = name;
        metadata.attributes.put(name, attrMetadata);
        attrMetadata.required = method.getDescriber().getAnnotation(OptionalBinding.class.getName()) == null;
        ValueType[] arguments = method.getActualParameterTypes();
        if (method.getActualReturnType() == null) {
            if (arguments.length != 1) {
                this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindAttribute.class.getName() + " and therefore must take exactly 1 argument, but takes " + arguments.length);
                return;
            }
            attrMetadata.setter = method.getDescriber();
        } else {
            if (arguments.length != 0) {
                this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindAttribute.class.getName() + " and therefore must not take arguments, but takes " + arguments.length);
                return;
            }
            attrMetadata.getter = method.getDescriber();
        }
        if (!this.parseAttributeType(attrMetadata, arguments.length == 1 ? arguments[0] : null, method.getActualReturnType())) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " should either take lambda or return value, since it is mapped to an attribute: " + arguments[0]);
        }
    }

    private boolean tryBidirectional(ComponentAttributeMetadata attribute, GenericMethod method) {
        if (attribute.type != ComponentAttributeType.FUNCTION) {
            return false;
        }
        if (method.getActualReturnType() != null || method.getActualParameterTypes().length != 1) {
            return false;
        }
        ValueType valueType = method.getActualParameterTypes()[0];
        if (!(valueType instanceof GenericClass)) {
            return false;
        }
        GenericMethod sam = this.typeNavigator.findSingleAbstractMethod((GenericClass)valueType);
        if (ComponentParser.isGetterLike(sam) && ComponentParser.isSetterLike(attribute.sam)) {
            attribute.type = ComponentAttributeType.BIDIRECTIONAL;
            attribute.altSam = attribute.sam;
            attribute.altSetter = attribute.setter;
            attribute.altValueType = attribute.valueType;
            attribute.sam = sam;
            attribute.setter = method.getDescriber();
            attribute.valueType = valueType;
            return true;
        }
        if (ComponentParser.isSetterLike(sam) && ComponentParser.isGetterLike(attribute.sam)) {
            attribute.type = ComponentAttributeType.BIDIRECTIONAL;
            attribute.altSam = sam;
            attribute.altSetter = method.getDescriber();
            attribute.altValueType = valueType;
            return true;
        }
        return false;
    }

    private boolean tryBidirectional(AttributeComponentMetadata attribute, GenericMethod method) {
        if (attribute.type != ComponentAttributeType.FUNCTION) {
            return false;
        }
        if (method.getActualReturnType() != null || method.getActualParameterTypes().length != 1) {
            return false;
        }
        ValueType valueType = method.getActualParameterTypes()[0];
        if (!(valueType instanceof GenericClass)) {
            return false;
        }
        GenericMethod sam = this.typeNavigator.findSingleAbstractMethod((GenericClass)valueType);
        if (ComponentParser.isGetterLike(sam) && ComponentParser.isSetterLike(attribute.sam)) {
            attribute.type = ComponentAttributeType.BIDIRECTIONAL;
            attribute.altSam = attribute.sam;
            attribute.altSetter = attribute.setter;
            attribute.altValueType = attribute.valueType;
            attribute.sam = sam;
            attribute.setter = method.getDescriber();
            attribute.valueType = valueType;
            return true;
        }
        if (ComponentParser.isSetterLike(sam) && ComponentParser.isGetterLike(attribute.sam)) {
            attribute.type = ComponentAttributeType.BIDIRECTIONAL;
            attribute.altSam = sam;
            attribute.altSetter = method.getDescriber();
            attribute.altValueType = valueType;
            return true;
        }
        return false;
    }

    private static boolean isGetterLike(GenericMethod sam) {
        return sam.getActualParameterTypes().length == 0 && sam.getActualReturnType() != null;
    }

    private static boolean isSetterLike(GenericMethod sam) {
        return sam.getActualParameterTypes().length == 1 && sam.getActualReturnType() == null;
    }

    private void parseBindElement(ElementComponentMetadata metadata, GenericMethod method, Set<AnnotationDescriber> bindings) {
        List path;
        AnnotationDescriber binding = method.getDescriber().getAnnotation(BindElement.class.getName());
        if (binding == null) {
            return;
        }
        bindings.add(binding);
        ValueType[] arguments = method.getActualParameterTypes();
        if (method.getActualReturnType() != null || arguments.length != 1) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindElement.class.getName() + " and therefore must take exactly one parameter and return void");
            return;
        }
        if (!(arguments[0] instanceof GenericType)) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindElement.class.getName() + " and therefore must not take primitive value");
            return;
        }
        boolean multiple = false;
        GenericType type = (GenericType)arguments[0];
        if (type instanceof GenericClass && (path = this.typeNavigator.sublassPath((GenericClass)type, "java.util.List")) != null) {
            type = ((TypeArgument)((GenericClass)path.get(path.size() - 1)).getArguments().get(0)).getBound();
            multiple = true;
        }
        if (!(type instanceof GenericClass)) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindElement.class.getName() + " and therefore must take class, not array");
            return;
        }
        NestedComponent nestedComponent = new NestedComponent();
        nestedComponent.multiple = multiple;
        nestedComponent.metadata = this.parseElement((GenericClass)type, binding, false);
        nestedComponent.setter = method;
        nestedComponent.required = method.getDescriber().getAnnotation(OptionalBinding.class.getName()) == null;
        metadata.nestedComponents.add(nestedComponent);
    }

    private boolean parseAttributeType(ComponentAttributeMetadata attrMetadata, ValueType valueType, ValueType returnType) {
        GenericMethod sam;
        if (valueType == null) {
            attrMetadata.type = ComponentAttributeType.VARIABLE;
            attrMetadata.valueType = returnType;
            return true;
        }
        if (valueType instanceof GenericClass && (sam = this.typeNavigator.findSingleAbstractMethod((GenericClass)valueType)) != null) {
            attrMetadata.sam = sam;
            attrMetadata.type = ComponentAttributeType.FUNCTION;
            attrMetadata.valueType = sam.getActualOwner();
            return true;
        }
        return false;
    }

    private void parseBindName(BaseComponentMetadata component, GenericMethod method) {
        AnnotationDescriber annot = method.getDescriber().getAnnotation(BindElementName.class.getName());
        if (annot == null) {
            return;
        }
        if (component.nameSetter != null) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " declares binding to annotation name that is already bound to " + this.methodToString(component.nameSetter));
            return;
        }
        ValueType[] args = method.getActualParameterTypes();
        if (args.length != 1) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " is marked by " + BindElementName.class.getName() + " and therefore must take exactly 1 argument, but takes " + args.length);
            return;
        }
        if (!args[0].equals(new GenericClass(String.class.getName()))) {
            this.error("Method " + this.methodToString(method.getDescriber()) + " takes argument of type that can't be mapped to component's name: " + args[0]);
        }
        component.nameSetter = method.getDescriber();
    }

    private String methodToString(MethodDescriber method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getOwner().getName()).append('.').append(method.getName()).append('(');
        ValueTypeFormatter formatter = new ValueTypeFormatter();
        ValueType[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            formatter.format(args[i], sb);
        }
        return sb.toString();
    }

    private void error(String message) {
        this.diagnostics.add(new Diagnostic(this.segment.getBegin(), this.segment.getEnd(), message));
    }

    static class MethodWithParams {
        final String name;
        final ValueType[] params;

        MethodWithParams(String name, ValueType[] params) {
            this.name = name;
            this.params = (ValueType[])params.clone();
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + Arrays.hashCode(this.params);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MethodWithParams)) {
                return false;
            }
            MethodWithParams other = (MethodWithParams)obj;
            return this.name.equals(other.name) && Arrays.equals(this.params, other.params);
        }
    }
}

