/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.emitting;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.teavm.flavour.expr.ClassPathClassResolver;
import org.teavm.flavour.expr.ClassResolver;
import org.teavm.flavour.expr.Diagnostic;
import org.teavm.flavour.expr.type.meta.ClassDescriberRepository;
import org.teavm.flavour.expr.type.meta.ClassPathClassDescriberRepository;
import org.teavm.flavour.templates.BindTemplate;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.emitting.OffsetToLineMapper;
import org.teavm.flavour.templates.emitting.TemplateEmitter;
import org.teavm.flavour.templates.parsing.ClassPathResourceProvider;
import org.teavm.flavour.templates.parsing.Parser;
import org.teavm.flavour.templates.tree.TemplateNode;
import org.teavm.metaprogramming.Diagnostics;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.SourceLocation;
import org.teavm.metaprogramming.Value;

public class TemplatingProxyGenerator {
    public void generate(Value<Object> model, ReflectClass<Object> modelType) {
        TemplateInfo template = this.parseForModel(modelType, Metaprogramming.getLocation());
        if (template != null) {
            TemplateEmitter emitter = new TemplateEmitter(template.locationMapper);
            Value<Fragment> fragment = emitter.emitTemplate(model, template.sourceFileName, template.body);
            Metaprogramming.exit(() -> (Fragment)fragment.get());
        } else {
            Metaprogramming.unsupportedCase();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TemplateInfo parseForModel(ReflectClass<Object> cls, SourceLocation location) {
        List<TemplateNode> fragment;
        Diagnostics diagnostics = Metaprogramming.getDiagnostics();
        BindTemplate annot = (BindTemplate)cls.getAnnotation(BindTemplate.class);
        if (annot == null) {
            return null;
        }
        String path = annot.value();
        ClassLoader classLoader = Metaprogramming.getClassLoader();
        ClassPathClassDescriberRepository classRepository = new ClassPathClassDescriberRepository(classLoader);
        ClassPathClassResolver classResolver = new ClassPathClassResolver(classLoader);
        ClassPathResourceProvider resourceProvider = new ClassPathResourceProvider(classLoader);
        Parser parser = new Parser((ClassDescriberRepository)classRepository, (ClassResolver)classResolver, resourceProvider);
        try (InputStream input = classLoader.getResourceAsStream(path);){
            if (input == null) {
                diagnostics.error(location, "Can't create template for {{c0}}: template " + path + " was not found", new Object[]{cls.getName()});
                TemplateInfo templateInfo = null;
                return templateInfo;
            }
            fragment = parser.parse(new InputStreamReader(input, "UTF-8"), cls.getName());
        }
        catch (IOException e) {
            diagnostics.error(location, "Can't create template for {{c0}}: template " + path + " was not found", new Object[]{cls.getName()});
            return null;
        }
        OffsetToLineMapper mapper = new OffsetToLineMapper();
        try (InputStreamReader reader = new InputStreamReader(classLoader.getResourceAsStream(path), "UTF-8");){
            mapper.prepare(reader);
        }
        catch (IOException e) {
            diagnostics.error(location, "Can't create template for {{c0}}: template " + path + " was not found", new Object[]{cls.getName()});
            return null;
        }
        if (!parser.getDiagnostics().isEmpty()) {
            for (Diagnostic diagnostic : parser.getDiagnostics()) {
                SourceLocation diagnosticLocation = location != null ? new SourceLocation(location.getMethod(), path, mapper.getLine(diagnostic.getStart()) + 1) : null;
                diagnostics.error(diagnosticLocation, diagnostic.getMessage(), new Object[0]);
            }
        }
        TemplateInfo info = new TemplateInfo();
        info.sourceFileName = path;
        info.body = fragment;
        info.locationMapper = mapper;
        return info;
    }

    static class TemplateInfo {
        String sourceFileName;
        OffsetToLineMapper locationMapper;
        List<TemplateNode> body;

        TemplateInfo() {
        }
    }
}

