/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.emitting;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teavm.flavour.expr.plan.LambdaPlan;
import org.teavm.flavour.templates.Component;
import org.teavm.flavour.templates.DomBuilder;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.Modifier;
import org.teavm.flavour.templates.ModifierTarget;
import org.teavm.flavour.templates.Renderable;
import org.teavm.flavour.templates.Slot;
import org.teavm.flavour.templates.emitting.EmitContext;
import org.teavm.flavour.templates.emitting.ExprPlanEmitter;
import org.teavm.flavour.templates.emitting.FragmentEmitter;
import org.teavm.flavour.templates.emitting.TemplateVariable;
import org.teavm.flavour.templates.tree.AttributeComponentBinding;
import org.teavm.flavour.templates.tree.ComponentBinding;
import org.teavm.flavour.templates.tree.ComponentFunctionBinding;
import org.teavm.flavour.templates.tree.ComponentVariableBinding;
import org.teavm.flavour.templates.tree.DOMAttribute;
import org.teavm.flavour.templates.tree.DOMElement;
import org.teavm.flavour.templates.tree.DOMText;
import org.teavm.flavour.templates.tree.NestedComponentBinding;
import org.teavm.flavour.templates.tree.TemplateNode;
import org.teavm.flavour.templates.tree.TemplateNodeVisitor;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.reflect.ReflectMethod;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.ValueType;

class TemplateNodeEmitter
implements TemplateNodeVisitor {
    private static final int COMPLEXITY_THRESHOLD = 20;
    private EmitContext context;
    private Value<DomBuilder> builder;
    private Value<DomBuilder> initialBuilder;
    private int complexity;

    TemplateNodeEmitter(EmitContext context, Value<DomBuilder> builder) {
        this.context = context;
        this.builder = builder;
        this.initialBuilder = builder;
    }

    @Override
    public void visit(DOMElement node) {
        this.context.location(node.getLocation());
        boolean hasInnerComponents = node.getChildNodes().stream().anyMatch(child -> child instanceof ComponentBinding);
        String tagName = node.getName();
        Object tmpBuilder = this.builder;
        if (hasInnerComponents) {
            this.updateBuilder((Value<DomBuilder>)Metaprogramming.emit(() -> ((DomBuilder)tmpBuilder.get()).openSlot(tagName)));
        } else {
            this.updateBuilder((Value<DomBuilder>)Metaprogramming.emit(() -> ((DomBuilder)tmpBuilder.get()).open(tagName)));
        }
        for (DOMAttribute attr : node.getAttributes()) {
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            Value<DomBuilder> tmpBuilder2 = this.builder;
            this.context.location(attr.getLocation());
            this.updateBuilder((Value<DomBuilder>)Metaprogramming.emit(() -> ((DomBuilder)tmpBuilder2.get()).attribute(attrName, attrValue)));
        }
        for (AttributeComponentBinding binding : node.getAttributeComponents()) {
            Value<DomBuilder> tmpBuilder3 = this.builder;
            Value<Modifier> modifier = this.emitAttributeComponent(binding);
            this.updateBuilder((Value<DomBuilder>)Metaprogramming.emit(() -> ((DomBuilder)tmpBuilder3.get()).add((Modifier)modifier.get())));
        }
        for (TemplateNode child2 : node.getChildNodes()) {
            child2.acceptVisitor(this);
        }
        tmpBuilder = this.builder;
        this.context.endLocation(node.getLocation());
        this.updateBuilder((Value<DomBuilder>)Metaprogramming.emit(() -> TemplateNodeEmitter.lambda$visit$5((Value)tmpBuilder)));
    }

    @Override
    public void visit(DOMText node) {
        this.context.location(node.getLocation());
        String value = node.getValue();
        Value<DomBuilder> tmpBuilder = this.builder;
        this.updateBuilder((Value<DomBuilder>)Metaprogramming.emit(() -> ((DomBuilder)tmpBuilder.get()).text(value)));
    }

    @Override
    public void visit(ComponentBinding node) {
        this.context.location(node.getLocation());
        ReflectClass componentType = Metaprogramming.findClass((String)node.getClassName());
        ReflectMethod ctor = componentType.getJMethod("<init>", new Class[]{Slot.class});
        Value component = Metaprogramming.emit(() -> (Component)ctor.construct(new Object[]{Slot.create()}));
        List<NestedComponentInstance> nestedInstances = this.emitElementComponent(node, component, component);
        this.context.pushBoundVars();
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        Map<ComponentBinding, Value<?>> instances = nestedInstances.stream().collect(Collectors.toMap(nested -> nested.node, nested -> nested.instance));
        instances.put(node, (Value)component);
        this.emitVariables(node, variables, instances);
        this.emitComponentContent(node, node, component, variables);
        for (NestedComponentInstance nestedInstance : nestedInstances) {
            this.emitComponentContent(node, nestedInstance.node, nestedInstance.instance, variables);
        }
        this.context.popBoundVars();
        Value<DomBuilder> tmpBuilder = this.builder;
        this.updateBuilder((Value<DomBuilder>)Metaprogramming.emit(() -> ((DomBuilder)tmpBuilder.get()).add((Component)component.get())));
    }

    private List<NestedComponentInstance> emitElementComponent(ComponentBinding node, Value<?> component, Value<?> root) {
        ReflectClass componentType = Metaprogramming.findClass((String)node.getClassName());
        for (ComponentFunctionBinding computation : node.getComputations()) {
            this.emitFunction(computation, component);
        }
        if (node.getElementNameMethodName() != null) {
            this.context.location(node.getLocation());
            this.emitElementName(node.getElementNameMethodName(), node.getName(), component, componentType);
        }
        ArrayList<NestedComponentInstance> nestedInstances = new ArrayList<NestedComponentInstance>();
        for (NestedComponentBinding nestedComponent : node.getNestedComponents()) {
            nestedInstances.addAll(this.emitNestedComponent(nestedComponent, component, root));
        }
        return nestedInstances;
    }

    private void emitComponentContent(ComponentBinding rootNode, ComponentBinding node, Value<?> component, List<TemplateVariable> variables) {
        this.context.location(node.getLocation());
        if (node.getContentMethodName() != null) {
            ReflectClass componentType = Metaprogramming.findClass((String)node.getClassName());
            Value<Fragment> contentFragment = new FragmentEmitter(this.context).emitTemplate(rootNode, node.getContentNodes(), variables);
            ReflectMethod setter = componentType.getJMethod(node.getContentMethodName(), new Class[]{Fragment.class});
            this.context.location(node.getLocation());
            Metaprogramming.emit(() -> setter.invoke((Object)component, new Object[]{contentFragment}));
        }
    }

    private void emitVariables(ComponentBinding component, List<TemplateVariable> variables, Map<ComponentBinding, Value<?>> instances) {
        Value<?> instance = instances.get(component);
        ReflectClass componentType = Metaprogramming.findClass((String)component.getClassName());
        for (ComponentVariableBinding varBinding : component.getVariables()) {
            ReflectMethod getter = componentType.getMethod(varBinding.getMethodName(), new ReflectClass[0]);
            Value source = Metaprogramming.lazy(() -> getter.invoke(instance.get(), new Object[0]));
            variables.add(new TemplateVariable(varBinding.getName(), (Value<Object>)source));
        }
        for (NestedComponentBinding nestedBinding : component.getNestedComponents()) {
            for (ComponentBinding nestedComponent : nestedBinding.getComponents()) {
                this.emitVariables(nestedComponent, variables, instances);
            }
        }
    }

    private Value<Modifier> emitAttributeComponent(AttributeComponentBinding binding) {
        this.context.location(binding.getLocation());
        ReflectClass componentClass = Metaprogramming.findClass((String)binding.getClassName()).asSubclass(Renderable.class);
        ReflectMethod ctor = componentClass.getJMethod("<init>", new Class[]{ModifierTarget.class});
        return Metaprogramming.proxy(Modifier.class, (instance, method, args) -> {
            Value elem = Metaprogramming.emit(() -> (ModifierTarget)args[0]);
            Value result = Metaprogramming.emit(() -> (Renderable)ctor.construct(new Object[]{elem.get()}));
            for (ComponentFunctionBinding function : binding.getFunctions()) {
                this.emitFunction(function, result);
            }
            if (binding.getElementNameMethodName() != null) {
                this.context.location(binding.getLocation());
                this.emitElementName(binding.getElementNameMethodName(), binding.getName(), result, componentClass);
            }
            this.context.location(binding.getLocation());
            Metaprogramming.exit(() -> (Renderable)result.get());
        });
    }

    private void emitFunction(ComponentFunctionBinding function, Value<?> component) {
        ExprPlanEmitter exprEmitter = new ExprPlanEmitter(this.context);
        LambdaPlan plan = function.getPlan();
        ValueType[] signature = MethodDescriptor.parseSignature((String)function.getPlan().getMethodDesc());
        exprEmitter.emitLambda(plan, signature[signature.length - 1] == ValueType.VOID);
        Value<Object> functionInstance = exprEmitter.var;
        ReflectClass cls = Metaprogramming.findClass((String)function.getMethodOwner());
        ReflectClass lambdaCls = Metaprogramming.findClass((String)function.getLambdaType());
        ReflectMethod setter = cls.getMethod(function.getMethodName(), new ReflectClass[]{lambdaCls});
        Metaprogramming.emit(() -> setter.invoke((Object)component, new Object[]{functionInstance}));
    }

    private List<NestedComponentInstance> emitNestedComponent(NestedComponentBinding nested, Value<?> component, Value<?> root) {
        ArrayList<NestedComponentInstance> instancesToFill = new ArrayList<NestedComponentInstance>();
        ReflectClass cls = Metaprogramming.findClass((String)nested.getMethodOwner());
        if (nested.isMultiple()) {
            ReflectMethod setter = cls.getJMethod(nested.getMethodName(), new Class[]{List.class});
            int capacity = nested.getComponents().size();
            Value list = Metaprogramming.emit(() -> new ArrayList(capacity));
            for (ComponentBinding nestedComponentBinding : nested.getComponents()) {
                Value<Object> nestedComponent = this.emitNestedComponent(nestedComponentBinding, root, instancesToFill);
                Metaprogramming.emit(() -> ((List)list.get()).add(nestedComponent));
                instancesToFill.add(new NestedComponentInstance(nestedComponentBinding, nestedComponent, root));
            }
            Metaprogramming.emit(() -> setter.invoke((Object)component, new Object[]{list}));
        } else {
            ReflectClass componentType = Metaprogramming.findClass((String)nested.getComponentType());
            ReflectMethod setter = cls.getMethod(nested.getMethodName(), new ReflectClass[]{componentType});
            Value<Object> nestedComponent = this.emitNestedComponent(nested.getComponents().get(0), root, instancesToFill);
            Metaprogramming.emit(() -> setter.invoke((Object)component, new Object[]{nestedComponent}));
            instancesToFill.add(new NestedComponentInstance(nested.getComponents().get(0), nestedComponent, root));
        }
        return instancesToFill;
    }

    private Value<Object> emitNestedComponent(ComponentBinding node, Value<?> root, List<NestedComponentInstance> instances) {
        this.context.location(node.getLocation());
        ReflectClass componentType = Metaprogramming.findClass((String)node.getClassName());
        ReflectMethod ctor = componentType.getMethod("<init>", new ReflectClass[0]);
        Value component = Metaprogramming.emit(() -> ctor.construct(new Object[0]));
        instances.addAll(this.emitElementComponent(node, component, root));
        return component;
    }

    private void emitElementName(String methodName, String elementName, Value<?> component, ReflectClass<?> componentType) {
        ReflectMethod setter = componentType.getJMethod(methodName, new Class[]{String.class});
        Metaprogramming.emit(() -> setter.invoke(component.get(), new Object[]{elementName}));
    }

    private void updateBuilder(Value<DomBuilder> newBuilder) {
        if (++this.complexity > 20) {
            this.complexity = 0;
            this.builder = this.initialBuilder;
        } else {
            this.builder = newBuilder;
        }
    }

    private static /* synthetic */ DomBuilder lambda$visit$5(Value tmpBuilder) {
        return ((DomBuilder)tmpBuilder.get()).close();
    }

    static class NestedComponentInstance {
        ComponentBinding node;
        Value<?> instance;
        Value<?> root;

        NestedComponentInstance(ComponentBinding node, Value<?> instance, Value<?> root) {
            this.node = node;
            this.instance = instance;
            this.root = root;
        }
    }
}

