/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.emitting;

import java.util.ArrayList;
import java.util.List;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.emitting.EmitContext;
import org.teavm.flavour.templates.emitting.FragmentEmitter;
import org.teavm.flavour.templates.emitting.OffsetToLineMapper;
import org.teavm.flavour.templates.emitting.TemplateVariable;
import org.teavm.flavour.templates.tree.TemplateNode;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.Value;

public class TemplateEmitter {
    private OffsetToLineMapper locationMapper;

    public TemplateEmitter(OffsetToLineMapper locationMapper) {
        this.locationMapper = locationMapper;
    }

    public Value<Fragment> emitTemplate(Value<Object> model, String sourceFileName, List<TemplateNode> fragment) {
        Value<Fragment> innerFragment = this.emitInnerFragment(sourceFileName, model, fragment);
        return this.emitWorker(innerFragment);
    }

    private Value<Fragment> emitInnerFragment(String sourceFileName, Value<Object> model, List<TemplateNode> fragment) {
        EmitContext context = new EmitContext(this.locationMapper);
        context.sourceFileName = sourceFileName;
        context.addVariable("this", () -> Metaprogramming.emit(() -> model));
        context.model = model;
        return new FragmentEmitter(context).emitTemplate(null, fragment, new ArrayList<TemplateVariable>());
    }

    private Value<Fragment> emitWorker(Value<Fragment> innerFragment) {
        return Metaprogramming.proxy(Fragment.class, (instance, method, args) -> {
            int argCount = args.length;
            Value innerArgs = Metaprogramming.emit(() -> new Object[argCount]);
            int i = 0;
            while (i < argCount) {
                int index = i++;
                Metaprogramming.emit(() -> {
                    Value value = args[index];
                    ((Object[])innerArgs.get())[index] = value;
                    return value;
                });
            }
            Value result = Metaprogramming.emit(() -> method.invoke((Object)innerFragment, (Object[])innerArgs.get()));
            Metaprogramming.exit(() -> result.get());
        });
    }
}

