/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.emitting;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;

class OffsetToLineMapper {
    int[] lines;

    OffsetToLineMapper() {
    }

    public void prepare(Reader reader) throws IOException {
        ArrayList<Integer> lineList = new ArrayList<Integer>();
        boolean cr = false;
        int offset = 0;
        while (true) {
            int code;
            if ((code = reader.read()) < 0) {
                if (!cr) break;
                lineList.add(offset);
                break;
            }
            ++offset;
            if (code == 13) {
                cr = true;
                continue;
            }
            if (code == 10) {
                cr = false;
                lineList.add(offset);
                continue;
            }
            if (!cr) continue;
            cr = false;
            lineList.add(offset - 1);
        }
        this.lines = new int[lineList.size()];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = (Integer)lineList.get(i);
        }
    }

    public int getLine(int offset) {
        int line = Arrays.binarySearch(this.lines, offset);
        if (line < 0) {
            line = -line - 1;
        }
        return line;
    }
}

