/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.emitting;

import java.util.List;
import org.teavm.flavour.templates.Component;
import org.teavm.flavour.templates.DomBuilder;
import org.teavm.flavour.templates.DomComponentHandler;
import org.teavm.flavour.templates.DomComponentTemplate;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.emitting.EmitContext;
import org.teavm.flavour.templates.emitting.TemplateNodeEmitter;
import org.teavm.flavour.templates.emitting.TemplateVariable;
import org.teavm.flavour.templates.emitting.VariableImpl;
import org.teavm.flavour.templates.tree.ComponentBinding;
import org.teavm.flavour.templates.tree.TemplateNode;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;

class FragmentEmitter {
    EmitContext context;

    FragmentEmitter(EmitContext context) {
        this.context = context;
    }

    public Value<Fragment> emitTemplate(ComponentBinding component, List<TemplateNode> fragment, List<TemplateVariable> variables) {
        if (component != null) {
            this.context.location(component.getLocation());
        }
        ReflectClass componentType = component != null ? Metaprogramming.findClass((String)component.getClassName()).asSubclass(Component.class) : null;
        return Metaprogramming.proxy(Fragment.class, (fProxy, fMethod, fArgs) -> {
            this.context.pushBoundVars();
            for (TemplateVariable variable : variables) {
                Value dest = Metaprogramming.emit(() -> new VariableImpl());
                this.context.addVariable(variable.name, () -> Metaprogramming.emit(() -> ((VariableImpl)dest.get()).value));
                variable.destination = dest;
            }
            Value handler = Metaprogramming.proxy(DomComponentHandler.class, (proxy, method, args) -> {
                switch (method.getName()) {
                    case "update": {
                        if (componentType == null) break;
                        this.emitUpdateMethod(variables);
                        break;
                    }
                    case "buildDom": {
                        this.emitBuildDomMethod((Value<DomBuilder>)Metaprogramming.emit(() -> (DomBuilder)args[0]), fragment);
                    }
                }
            });
            Value result = Metaprogramming.emit(() -> new DomComponentTemplate((DomComponentHandler)handler.get()));
            Metaprogramming.exit(() -> (Component)result.get());
        });
    }

    private void emitBuildDomMethod(Value<DomBuilder> builder, List<TemplateNode> fragment) {
        TemplateNodeEmitter nodeEmitter = new TemplateNodeEmitter(this.context, builder);
        for (TemplateNode node : fragment) {
            this.context.location(node.getLocation());
            node.acceptVisitor(nodeEmitter);
        }
    }

    private void emitUpdateMethod(List<TemplateVariable> variables) {
        for (TemplateVariable var : variables) {
            Value<Object> source = var.source;
            Value<VariableImpl> dest = var.destination;
            Metaprogramming.emit(() -> {
                ((VariableImpl)dest.get()).value = source.get();
                return ((VariableImpl)dest.get()).value;
            });
        }
    }
}

