/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.emitting;

import java.util.ArrayList;
import org.teavm.flavour.expr.InterpretationException;
import org.teavm.flavour.expr.plan.ArithmeticCastPlan;
import org.teavm.flavour.expr.plan.ArrayConstructionPlan;
import org.teavm.flavour.expr.plan.ArrayLengthPlan;
import org.teavm.flavour.expr.plan.BinaryPlan;
import org.teavm.flavour.expr.plan.CastFromIntegerPlan;
import org.teavm.flavour.expr.plan.CastPlan;
import org.teavm.flavour.expr.plan.CastToIntegerPlan;
import org.teavm.flavour.expr.plan.ConditionalPlan;
import org.teavm.flavour.expr.plan.ConstantPlan;
import org.teavm.flavour.expr.plan.ConstructionPlan;
import org.teavm.flavour.expr.plan.FieldAssignmentPlan;
import org.teavm.flavour.expr.plan.FieldPlan;
import org.teavm.flavour.expr.plan.GetArrayElementPlan;
import org.teavm.flavour.expr.plan.InstanceOfPlan;
import org.teavm.flavour.expr.plan.InvocationPlan;
import org.teavm.flavour.expr.plan.LambdaPlan;
import org.teavm.flavour.expr.plan.LogicalBinaryPlan;
import org.teavm.flavour.expr.plan.NegatePlan;
import org.teavm.flavour.expr.plan.NotPlan;
import org.teavm.flavour.expr.plan.ObjectPlan;
import org.teavm.flavour.expr.plan.ObjectPlanEntry;
import org.teavm.flavour.expr.plan.Plan;
import org.teavm.flavour.expr.plan.PlanVisitor;
import org.teavm.flavour.expr.plan.ReferenceEqualityPlan;
import org.teavm.flavour.expr.plan.ThisPlan;
import org.teavm.flavour.expr.plan.VariablePlan;
import org.teavm.flavour.templates.Templates;
import org.teavm.flavour.templates.emitting.EmitContext;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.reflect.ReflectField;
import org.teavm.metaprogramming.reflect.ReflectMethod;

class ExprPlanEmitter
implements PlanVisitor {
    private EmitContext context;
    Value<Object> var;

    ExprPlanEmitter(EmitContext context) {
        this.context = context;
    }

    private void location(Plan plan) {
        this.context.location(plan.getLocation());
    }

    public void visit(ConstantPlan plan) {
        this.location((Plan)plan);
        Object value = plan.getValue();
        this.var = value == null ? Metaprogramming.lazy(() -> null) : Metaprogramming.lazy(() -> value);
    }

    public void visit(VariablePlan plan) {
        this.location((Plan)plan);
        this.emitVariable(plan.getName());
    }

    public void visit(ThisPlan plan) {
        this.location((Plan)plan);
        this.emitVariable("this");
    }

    private void emitVariable(String name) {
        this.var = this.context.getVariable(name).emit();
    }

    public void visit(BinaryPlan plan) {
        plan.getFirstOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> first = this.var;
        plan.getSecondOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> second = this.var;
        this.location((Plan)plan);
        block0 : switch (plan.getType()) {
            case ADD: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() + (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() + (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf(((Float)first.get()).floatValue() + ((Float)second.get()).floatValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() + (Double)second.get());
                    }
                }
                break;
            }
            case SUBTRACT: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() - (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() - (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf(((Float)first.get()).floatValue() - ((Float)second.get()).floatValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() - (Double)second.get());
                    }
                }
                break;
            }
            case MULTIPLY: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() * (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() * (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf(((Float)first.get()).floatValue() * ((Float)second.get()).floatValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() * (Double)second.get());
                    }
                }
                break;
            }
            case DIVIDE: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() / (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() / (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf(((Float)first.get()).floatValue() / ((Float)second.get()).floatValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() / (Double)second.get());
                    }
                }
                break;
            }
            case REMAINDER: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() % (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() % (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf(((Float)first.get()).floatValue() % ((Float)second.get()).floatValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() % (Double)second.get());
                    }
                }
                break;
            }
            case EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> ((Integer)first.get()).intValue() == ((Integer)second.get()).intValue());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> ((Long)first.get()).longValue() == ((Long)second.get()).longValue());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> ((Float)first.get()).floatValue() == ((Float)second.get()).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> ((Double)first.get()).doubleValue() == ((Double)second.get()).doubleValue());
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> ((Integer)first.get()).intValue() != ((Integer)second.get()).intValue());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> ((Long)first.get()).longValue() != ((Long)second.get()).longValue());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> ((Float)first.get()).floatValue() != ((Float)second.get()).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> ((Double)first.get()).doubleValue() != ((Double)second.get()).doubleValue());
                    }
                }
                break;
            }
            case GREATER: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() > (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() > (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> ((Float)first.get()).floatValue() > ((Float)second.get()).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() > (Double)second.get());
                    }
                }
                break;
            }
            case GREATER_OR_EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() >= (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() >= (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> ((Float)first.get()).floatValue() >= ((Float)second.get()).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() >= (Double)second.get());
                    }
                }
                break;
            }
            case LESS: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() < (Integer)second.get());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() < (Long)second.get());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> ((Float)first.get()).floatValue() < ((Float)second.get()).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() < (Double)second.get());
                    }
                }
                break;
            }
            case LESS_OR_EQUAL: {
                switch (plan.getValueType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (Integer)first.get() <= (Integer)second.get());
                        break block0;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (Long)first.get() <= (Long)second.get());
                        break block0;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> ((Float)first.get()).floatValue() <= ((Float)second.get()).floatValue());
                        break block0;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (Double)first.get() <= (Double)second.get());
                    }
                }
            }
        }
    }

    public void visit(NegatePlan plan) {
        plan.getOperand().acceptVisitor((PlanVisitor)this);
        this.location((Plan)plan);
        Value<Object> operand = this.var;
        switch (plan.getValueType()) {
            case INT: {
                this.var = Metaprogramming.lazy(() -> -((Integer)operand.get()).intValue());
                break;
            }
            case LONG: {
                this.var = Metaprogramming.lazy(() -> -((Long)operand.get()).longValue());
                break;
            }
            case FLOAT: {
                this.var = Metaprogramming.lazy(() -> Float.valueOf(-((Float)operand.get()).floatValue()));
                break;
            }
            case DOUBLE: {
                this.var = Metaprogramming.lazy(() -> -((Double)operand.get()).doubleValue());
            }
        }
    }

    public void visit(ReferenceEqualityPlan plan) {
        plan.getFirstOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> first = this.var;
        plan.getSecondOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> second = this.var;
        this.location((Plan)plan);
        switch (plan.getType()) {
            case EQUAL: {
                this.var = Metaprogramming.lazy(() -> first == second);
                break;
            }
            case NOT_EQUAL: {
                this.var = Metaprogramming.lazy(() -> first != second);
            }
        }
    }

    public void visit(LogicalBinaryPlan plan) {
        plan.getFirstOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> first = this.var;
        plan.getSecondOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> second = this.var;
        this.location((Plan)plan);
        switch (plan.getType()) {
            case AND: {
                this.var = Metaprogramming.lazy(() -> (Boolean)first.get() != false && (Boolean)second.get() != false);
                break;
            }
            case OR: {
                this.var = Metaprogramming.lazy(() -> (Boolean)first.get() != false || (Boolean)second.get() != false);
            }
        }
    }

    public void visit(NotPlan plan) {
        plan.getOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> operand = this.var;
        this.location((Plan)plan);
        this.var = Metaprogramming.lazy(() -> (Boolean)operand.get() == false);
    }

    public void visit(CastPlan plan) {
        plan.getOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> operand = this.var;
        TypeParser typeParser = new TypeParser(plan.getTargetType());
        ReflectClass cls = typeParser.parse().asSubclass(Object.class);
        this.location((Plan)plan);
        this.var = Metaprogramming.lazy(() -> cls.cast(operand.get()));
    }

    public void visit(ArithmeticCastPlan plan) {
        plan.getOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> operand = this.var;
        this.location((Plan)plan);
        block0 : switch (plan.getSourceType()) {
            case INT: {
                switch (plan.getTargetType()) {
                    case INT: {
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (long)((Integer)operand.get()).intValue());
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf(((Integer)operand.get()).intValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (double)((Integer)operand.get()).intValue());
                    }
                }
                break;
            }
            case LONG: {
                switch (plan.getTargetType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (int)((Long)operand.get()).longValue());
                        break;
                    }
                    case LONG: {
                        break;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf(((Long)operand.get()).longValue()));
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (double)((Long)operand.get()).longValue());
                    }
                }
                break;
            }
            case FLOAT: {
                switch (plan.getTargetType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (int)((Float)operand.get()).floatValue());
                        break;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (long)((Float)operand.get()).floatValue());
                        break;
                    }
                    case FLOAT: {
                        break;
                    }
                    case DOUBLE: {
                        this.var = Metaprogramming.lazy(() -> (double)((Float)operand.get()).floatValue());
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (plan.getTargetType()) {
                    case INT: {
                        this.var = Metaprogramming.lazy(() -> (int)((Double)operand.get()).doubleValue());
                        break block0;
                    }
                    case LONG: {
                        this.var = Metaprogramming.lazy(() -> (long)((Double)operand.get()).doubleValue());
                        break block0;
                    }
                    case FLOAT: {
                        this.var = Metaprogramming.lazy(() -> Float.valueOf((float)((Double)operand.get()).doubleValue()));
                        break block0;
                    }
                }
            }
        }
    }

    public void visit(CastFromIntegerPlan plan) {
        plan.getOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> value = this.var;
        this.location((Plan)plan);
        Value intValue = Metaprogramming.lazy(() -> (Integer)value.get());
        switch (plan.getType()) {
            case BYTE: {
                this.var = Metaprogramming.lazy(() -> (byte)((Integer)intValue.get()).intValue());
                break;
            }
            case SHORT: {
                this.var = Metaprogramming.lazy(() -> (short)((Integer)intValue.get()).intValue());
                break;
            }
            case CHAR: {
                this.var = Metaprogramming.lazy(() -> Character.valueOf((char)((Integer)intValue.get()).intValue()));
            }
        }
    }

    public void visit(CastToIntegerPlan plan) {
        plan.getOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> value = this.var;
        this.location((Plan)plan);
        switch (plan.getType()) {
            case BYTE: {
                this.var = Metaprogramming.lazy(() -> (int)((Byte)value.get()).byteValue());
                break;
            }
            case SHORT: {
                this.var = Metaprogramming.lazy(() -> (int)((Short)value.get()).shortValue());
                break;
            }
            case CHAR: {
                this.var = Metaprogramming.lazy(() -> (int)((Character)value.get()).charValue());
            }
        }
    }

    public void visit(GetArrayElementPlan plan) {
        plan.getArray().acceptVisitor((PlanVisitor)this);
        Value<Object> array = this.var;
        plan.getIndex().acceptVisitor((PlanVisitor)this);
        Value<Object> index = this.var;
        this.location((Plan)plan);
        this.var = Metaprogramming.lazy(() -> ((Object[])array.get())[(Integer)index.get()]);
    }

    public void visit(ArrayLengthPlan plan) {
        plan.getArray().acceptVisitor((PlanVisitor)this);
        Value<Object> array = this.var;
        this.location((Plan)plan);
        this.var = Metaprogramming.lazy(() -> ((Object[])array.get()).length);
    }

    public void visit(FieldPlan plan) {
        ReflectClass cls = Metaprogramming.findClass((String)plan.getClassName());
        ReflectField field = cls.getField(plan.getFieldName());
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor((PlanVisitor)this);
            Value<Object> instance = this.var;
            this.location((Plan)plan);
            this.var = Metaprogramming.lazy(() -> field.get(instance.get()));
        } else {
            this.location((Plan)plan);
            this.var = Metaprogramming.lazy(() -> field.get(null));
        }
    }

    public void visit(FieldAssignmentPlan plan) {
        ReflectClass cls = Metaprogramming.findClass((String)plan.getClassName());
        ReflectField field = cls.getField(plan.getFieldName());
        plan.getValue().acceptVisitor((PlanVisitor)this);
        Value<Object> value = this.var;
        if (plan.getInstance() != null) {
            plan.getInstance().acceptVisitor((PlanVisitor)this);
            Value<Object> instance = this.var;
            this.location((Plan)plan);
            this.var = Metaprogramming.lazy(() -> {
                field.set(instance.get(), value.get());
                return null;
            });
        } else {
            this.location((Plan)plan);
            this.var = Metaprogramming.lazy(() -> {
                field.set(null, value.get());
                return null;
            });
        }
    }

    public void visit(InstanceOfPlan plan) {
        ReflectClass<?> cls = new TypeDecoder(plan.getClassName()).decode();
        plan.getOperand().acceptVisitor((PlanVisitor)this);
        Value<Object> value = this.var;
        this.location((Plan)plan);
        this.var = Metaprogramming.lazy(() -> cls.isInstance(value.get()));
    }

    public void visit(InvocationPlan plan) {
        this.var = Metaprogramming.lazyFragment(() -> {
            Value<Object> instance;
            if (plan.getInstance() != null) {
                plan.getInstance().acceptVisitor((PlanVisitor)this);
                instance = this.var;
            } else {
                instance = null;
            }
            this.location((Plan)plan);
            ReflectClass cls = Metaprogramming.findClass((String)plan.getClassName());
            ReflectMethod method = this.findMethod(cls, plan.getMethodName(), plan.getMethodDesc());
            int argCount = method.getParameterCount();
            Value arguments = Metaprogramming.emit(() -> new Object[argCount]);
            for (int i = 0; i < plan.getArguments().size(); ++i) {
                int index = i;
                ((Plan)plan.getArguments().get(i)).acceptVisitor((PlanVisitor)this);
                Value<Object> argValue = this.var;
                Metaprogramming.emit(() -> {
                    Object object = argValue.get();
                    ((Object[])arguments.get())[index] = object;
                    return object;
                });
            }
            return Metaprogramming.emit(() -> method.invoke((Object)instance, (Object[])arguments.get()));
        });
    }

    public void visit(ConstructionPlan plan) {
        this.var = Metaprogramming.lazyFragment(() -> {
            this.location((Plan)plan);
            ReflectClass cls = Metaprogramming.findClass((String)plan.getClassName());
            ReflectMethod method = this.findMethod(cls, "<init>", plan.getMethodDesc());
            int argCount = method.getParameterCount();
            Value arguments = Metaprogramming.emit(() -> new Object[argCount]);
            for (int i = 0; i < plan.getArguments().size(); ++i) {
                int index = i;
                ((Plan)plan.getArguments().get(i)).acceptVisitor((PlanVisitor)this);
                Value<Object> argValue = this.var;
                Metaprogramming.emit(() -> {
                    Object object = argValue.get();
                    ((Object[])arguments.get())[index] = object;
                    return object;
                });
            }
            return Metaprogramming.emit(() -> method.construct((Object[])arguments.get()));
        });
    }

    public void visit(ArrayConstructionPlan plan) {
        ArrayList<Value<Object>> elements = new ArrayList<Value<Object>>();
        for (Plan elemPlan : plan.getElements()) {
            elemPlan.acceptVisitor((PlanVisitor)this);
            elements.add(this.var);
        }
        ReflectClass cls = new TypeParser(plan.getElementType()).parse().asSubclass(Object.class);
        this.var = Metaprogramming.lazyFragment(() -> {
            this.location((Plan)plan);
            int sz = elements.size();
            Value array = Metaprogramming.emit(() -> cls.createArray(sz));
            int i = 0;
            while (i < sz) {
                Value elem = (Value)elements.get(i);
                int index = i++;
                Metaprogramming.emit(() -> {
                    Object object = elem.get();
                    ((Object[])array.get())[index] = object;
                    return object;
                });
            }
            return Metaprogramming.emit(() -> (Object[])array.get());
        });
    }

    private ReflectMethod findMethod(ReflectClass<?> owner, String name, String desc) {
        TypeParser parser = new TypeParser(desc);
        ++parser.index;
        ArrayList argumentTypes = new ArrayList();
        while (parser.text.charAt(parser.index) != ')') {
            ReflectClass<?> argumentType = parser.parse();
            if (argumentType == null) {
                return null;
            }
            argumentTypes.add(argumentType);
        }
        return owner.getMethod(name, argumentTypes.toArray(new ReflectClass[0]));
    }

    public void visit(ConditionalPlan plan) {
        plan.getCondition().acceptVisitor((PlanVisitor)this);
        Value<Object> condition = this.var;
        plan.getConsequent().acceptVisitor((PlanVisitor)this);
        Value<Object> consequent = this.var;
        plan.getAlternative().acceptVisitor((PlanVisitor)this);
        Value<Object> alternative = this.var;
        this.location((Plan)plan);
        this.var = Metaprogramming.lazy(() -> (Boolean)condition.get() != false ? consequent.get() : alternative.get());
    }

    public void visit(LambdaPlan plan) {
        this.emitLambda(plan, false);
    }

    public void visit(ObjectPlan plan) {
        ReflectClass cls = Metaprogramming.findClass((String)plan.getClassName());
        ReflectMethod constructor = cls.getMethod("<init>", new ReflectClass[0]);
        Value instance = Metaprogramming.emit(() -> constructor.construct(new Object[0]));
        for (ObjectPlanEntry entry : plan.getEntries()) {
            ReflectMethod setter = this.findMethod(cls, entry.getSetterName(), entry.getSetterDesc());
            entry.getValue().acceptVisitor((PlanVisitor)this);
            Value<Object> value = this.var;
            Metaprogramming.emit(() -> setter.invoke((Object)instance, new Object[]{value}));
        }
        this.var = Metaprogramming.emit(() -> instance);
    }

    public void emitLambda(LambdaPlan plan, boolean updateTemplates) {
        this.location((Plan)plan);
        ReflectClass cls = Metaprogramming.findClass((String)plan.getClassName()).asSubclass(Object.class);
        this.var = Metaprogramming.proxy((ReflectClass)cls, (instance, method, args) -> {
            this.context.pushBoundVars();
            for (int i = 0; i < args.length; ++i) {
                Value arg = args[i];
                this.context.addVariable((String)plan.getBoundVars().get(i), () -> Metaprogramming.emit(() -> arg.get()));
            }
            this.location((Plan)plan);
            plan.getBody().acceptVisitor((PlanVisitor)this);
            Value<Object> result = this.var;
            Value valueToReturn = Metaprogramming.emit(() -> result.get());
            if (updateTemplates) {
                Metaprogramming.emit(() -> Templates.update());
            }
            if (method.getReturnType() != Metaprogramming.findClass(Void.TYPE)) {
                Metaprogramming.exit(() -> valueToReturn.get());
            }
            this.context.popBoundVars();
        });
    }

    class TypeDecoder {
        int position;
        final String text;

        TypeDecoder(String text) {
            this.text = text;
        }

        ReflectClass<?> decode() {
            switch (this.text.charAt(this.position++)) {
                case 'Z': {
                    return Metaprogramming.findClass(Boolean.TYPE);
                }
                case 'C': {
                    return Metaprogramming.findClass(Character.TYPE);
                }
                case 'B': {
                    return Metaprogramming.findClass(Byte.TYPE);
                }
                case 'S': {
                    return Metaprogramming.findClass(Short.TYPE);
                }
                case 'I': {
                    return Metaprogramming.findClass(Integer.TYPE);
                }
                case 'J': {
                    return Metaprogramming.findClass(Long.TYPE);
                }
                case 'F': {
                    return Metaprogramming.findClass(Float.TYPE);
                }
                case 'D': {
                    return Metaprogramming.findClass(Double.TYPE);
                }
                case 'V': {
                    return Metaprogramming.findClass(Void.TYPE);
                }
                case 'L': {
                    int index = this.text.indexOf(59, this.position);
                    ReflectClass cls = Metaprogramming.findClass((String)this.text.substring(this.position, index).replace('/', '.'));
                    this.position = index + 1;
                    return cls;
                }
                case '[': {
                    return Metaprogramming.arrayClass(this.decode());
                }
            }
            throw new InterpretationException("Error parsing type descriptor");
        }
    }

    class TypeParser {
        int index;
        String text;

        TypeParser(String text) {
            this.text = text;
        }

        ReflectClass<?> parse() {
            if (this.index >= this.text.length()) {
                return null;
            }
            char c = this.text.charAt(this.index);
            switch (c) {
                case 'V': {
                    ++this.index;
                    return Metaprogramming.findClass(Void.TYPE);
                }
                case 'Z': {
                    ++this.index;
                    return Metaprogramming.findClass(Boolean.TYPE);
                }
                case 'B': {
                    ++this.index;
                    return Metaprogramming.findClass(Byte.TYPE);
                }
                case 'S': {
                    ++this.index;
                    return Metaprogramming.findClass(Short.TYPE);
                }
                case 'I': {
                    ++this.index;
                    return Metaprogramming.findClass(Integer.TYPE);
                }
                case 'J': {
                    ++this.index;
                    return Metaprogramming.findClass(Long.TYPE);
                }
                case 'F': {
                    ++this.index;
                    return Metaprogramming.findClass(Float.TYPE);
                }
                case 'D': {
                    ++this.index;
                    return Metaprogramming.findClass(Double.TYPE);
                }
                case 'L': {
                    int next = this.text.indexOf(59, ++this.index);
                    if (next < 0) {
                        return null;
                    }
                    ReflectClass cls = Metaprogramming.findClass((String)this.text.substring(this.index, next).replace('/', '.'));
                    this.index = next + 1;
                    return cls;
                }
                case '[': {
                    ++this.index;
                    ReflectClass<?> component = this.parse();
                    return component != null ? Metaprogramming.arrayClass(component) : null;
                }
            }
            return null;
        }
    }
}

