/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates.emitting;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.flavour.expr.Location;
import org.teavm.flavour.templates.emitting.OffsetToLineMapper;
import org.teavm.flavour.templates.emitting.VariableEmitter;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.Value;

class EmitContext {
    OffsetToLineMapper locationMapper;
    String sourceFileName;
    Value<Object> model;
    List<Map<String, VariableEmitter>> boundVariableStack = new ArrayList<Map<String, VariableEmitter>>();
    Map<String, Deque<VariableEmitter>> variables = new HashMap<String, Deque<VariableEmitter>>();

    EmitContext(OffsetToLineMapper locationMapper) {
        this.locationMapper = locationMapper;
    }

    public void pushBoundVars() {
        this.boundVariableStack.add(new HashMap());
    }

    public Map<String, VariableEmitter> popBoundVars() {
        Map<String, VariableEmitter> vars = this.boundVariableStack.get(this.boundVariableStack.size() - 1);
        this.boundVariableStack.remove(this.boundVariableStack.size() - 1);
        return vars;
    }

    public VariableEmitter getVariable(String name) {
        Deque<VariableEmitter> stack = this.variables.get(name);
        VariableEmitter var = stack != null && !stack.isEmpty() ? stack.peek() : null;
        this.boundVariableStack.get(this.boundVariableStack.size() - 1).put(name, var);
        return var;
    }

    public void addVariable(String name, VariableEmitter value) {
        Deque stack = this.variables.computeIfAbsent(name, k -> new ArrayDeque());
        stack.push(value);
    }

    public void removeVariable(String name) {
        Deque<VariableEmitter> stack = this.variables.get(name);
        if (stack != null) {
            stack.pop();
            if (stack.isEmpty()) {
                this.variables.remove(name);
            }
        }
    }

    public void location(Location location) {
        if (location == null) {
            return;
        }
        int line = this.locationMapper.getLine(location.getStart());
        Metaprogramming.location((String)this.sourceFileName, (int)(line + 1));
    }

    public void endLocation(Location location) {
        if (location == null) {
            return;
        }
        int line = this.locationMapper.getLine(location.getEnd() - 1) + 1;
        Metaprogramming.location((String)this.sourceFileName, (int)line);
    }
}

