/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates;

import java.util.ArrayList;
import java.util.List;
import org.teavm.flavour.templates.AbstractComponent;
import org.teavm.flavour.templates.Component;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.Slot;
import org.teavm.flavour.templates.emitting.TemplatingProxyGenerator;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;

@CompileTime
public final class Templates {
    private static boolean updating;
    private static List<RootComponent> rootComponents;

    private Templates() {
    }

    public static Component bind(Object model, String id) {
        return Templates.bind(model, Window.current().getDocument().getElementById(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component bind(Object model, HTMLElement element) {
        Fragment fragment = Templates.create(model);
        Slot root = Slot.root((Node)element);
        RootComponent component = new RootComponent(root, fragment.create());
        rootComponents.add(component);
        updating = true;
        try {
            component.render();
            RootComponent rootComponent = component;
            return rootComponent;
        }
        finally {
            updating = false;
        }
    }

    public static Fragment create(Object model) {
        return Templates.create(model.getClass(), model);
    }

    @Meta
    private static native Fragment create(Class<?> var0, Object var1);

    private static void create(ReflectClass<Object> type, Value<Object> model) {
        new TemplatingProxyGenerator().generate(model, type);
    }

    public static void update() {
        if (updating) {
            return;
        }
        updating = true;
        try {
            for (RootComponent component : rootComponents) {
                component.render();
            }
        }
        finally {
            updating = false;
        }
    }

    static {
        rootComponents = new ArrayList<RootComponent>();
    }

    private static class RootComponent
    extends AbstractComponent {
        private Component inner;

        RootComponent(Slot slot, Component inner) {
            super(slot);
            this.inner = inner;
            slot.append(inner.getSlot());
        }

        @Override
        public void render() {
            this.inner.render();
        }

        @Override
        public void destroy() {
            this.inner.destroy();
            super.destroy();
            rootComponents.remove(this);
        }
    }
}

