/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates;

import org.teavm.flavour.templates.ContainerSlot;
import org.teavm.flavour.templates.RootSlot;
import org.teavm.flavour.templates.Space;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.dom.xml.Node;

public abstract class Slot
extends Space {
    Space first;
    Space last;

    Slot() {
    }

    public void append(Space slot) {
        this.insertBefore(slot, null);
    }

    public void insertBefore(Space space, Space successor) {
        Node successorDomNode;
        if (space.getParent() != null) {
            throw new IllegalArgumentException("The given space is already hosted by a slot");
        }
        if (successor != null && successor.getParent() != this) {
            throw new IllegalArgumentException("Successor does not belong to this slot");
        }
        space.parent = this;
        if (successor == null) {
            space.previous = this.last;
            if (this.last != null) {
                this.last.next = space;
            } else {
                this.first = space;
            }
            this.last = space;
        } else {
            space.next = successor;
            space.previous = successor.previous;
            if (space.next != null) {
                space.next.previous = space;
            } else {
                this.last = space;
            }
            if (space.previous != null) {
                space.previous.next = space;
            } else {
                this.first = space;
            }
        }
        RootSlot root = this.getRoot();
        if (root == null) {
            return;
        }
        JSArray domNodes = JSArray.create();
        space.getAllNodes((JSArray<Node>)domNodes);
        if (domNodes.getLength() == 0) {
            return;
        }
        if (successor != null) {
            successorDomNode = successor.getFirstNode();
        } else {
            Slot ancestor = this;
            successorDomNode = null;
            while (ancestor != null) {
                if (ancestor.next != null) {
                    successorDomNode = ancestor.next.getFirstNode();
                    break;
                }
                ancestor = ancestor.parent;
            }
        }
        for (int i = 0; i < domNodes.getLength(); ++i) {
            root.domNode.insertBefore((Node)domNodes.get(i), successorDomNode);
        }
    }

    @Override
    Node getFirstNode() {
        for (Space child = this.first; child != null; child = child.getNext()) {
            Node result = child.getFirstNode();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    Node getLastNode() {
        for (Space child = this.last; child != null; child = child.getPrevious()) {
            Node result = child.getLastNode();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    void getAllNodes(JSArray<Node> nodes) {
        for (Space child = this.first; child != null; child = child.getNext()) {
            child.getAllNodes(nodes);
        }
    }

    @Override
    void deleteDom() {
        for (Space child = this.first; child != null; child = child.getNext()) {
            child.deleteDom();
        }
    }

    public static Slot create() {
        return new ContainerSlot();
    }

    public static Slot root(Node domNode) {
        return new RootSlot(domNode);
    }
}

