/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates;

import java.util.List;
import org.teavm.flavour.templates.AbstractComponent;
import org.teavm.flavour.templates.DomBuilder;
import org.teavm.flavour.templates.DomComponentHandler;
import org.teavm.flavour.templates.Renderable;
import org.teavm.flavour.templates.Slot;

public class DomComponentTemplate
extends AbstractComponent {
    private DomComponentHandler handler;
    private List<Renderable> renderables;

    public DomComponentTemplate(DomComponentHandler handler) {
        super(Slot.create());
        this.handler = handler;
    }

    @Override
    public void render() {
        this.handler.update();
        if (this.renderables == null) {
            DomBuilder builder = new DomBuilder(this.getSlot());
            this.handler.buildDom(builder);
            this.renderables = builder.getRenderables();
        }
        for (Renderable renderable : this.renderables) {
            renderable.render();
        }
    }

    @Override
    public void destroy() {
        if (this.renderables != null) {
            for (Renderable renderable : this.renderables) {
                renderable.destroy();
            }
            this.renderables = null;
        }
        super.destroy();
    }
}

