/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.templates;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.teavm.flavour.templates.Component;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.Modifier;
import org.teavm.flavour.templates.ModifierTarget;
import org.teavm.flavour.templates.NodeHolder;
import org.teavm.flavour.templates.Renderable;
import org.teavm.flavour.templates.Slot;
import org.teavm.flavour.templates.ValueChangeListener;
import org.teavm.jso.JSBody;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Document;
import org.teavm.jso.dom.xml.Element;
import org.teavm.jso.dom.xml.Node;
import org.teavm.jso.dom.xml.Text;

public class DomBuilder {
    private static final Document document = Window.current().getDocument();
    private Slot slot;
    private Deque<Item> stack = new ArrayDeque<Item>();
    private List<Renderable> renderables = new ArrayList<Renderable>();

    public DomBuilder(Slot slot) {
        this.slot = slot;
    }

    public DomBuilder open(String tagName) {
        return this.open(tagName, false);
    }

    public DomBuilder openSlot(String tagName) {
        return this.open(tagName, true);
    }

    private DomBuilder open(String tagName, boolean slot) {
        Element elem = document.createElement(tagName);
        Item item = new Item();
        item.element = elem;
        if (slot) {
            item.slot = Slot.root((Node)elem);
        }
        this.stack.push(item);
        return this;
    }

    public DomBuilder close() {
        this.appendNode((Node)this.stack.pop().element);
        return this;
    }

    public DomBuilder text(String text) {
        Text node = document.createTextNode(text);
        this.appendNode((Node)node);
        return this;
    }

    public DomBuilder attribute(String name, String value) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Can't set attribute to root node");
        }
        this.stack.peek().element.setAttribute(name, value);
        return this;
    }

    public DomBuilder add(Component component) {
        if (this.stack.isEmpty()) {
            this.slot.append(component.getSlot());
        } else {
            Item item = this.stack.peek();
            if (item.slot == null) {
                Slot elemSlot = Slot.root((Node)item.element);
                elemSlot.append(component.getSlot());
            } else {
                item.slot.append(component.getSlot());
            }
        }
        component.render();
        this.renderables.add(component);
        return this;
    }

    public DomBuilder add(Fragment fragment) {
        return this.add(fragment.create());
    }

    public DomBuilder add(Modifier modifier) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Can't apply modifier to root node");
        }
        Renderable renderable = modifier.apply(this.stack.peek());
        this.renderables.add(renderable);
        return this;
    }

    private void appendNode(Node node) {
        if (this.stack.isEmpty()) {
            this.slot.append(new NodeHolder(node));
        } else {
            Item item = this.stack.peek();
            if (item.slot == null) {
                item.element.appendChild(node);
            } else {
                item.slot.append(new NodeHolder(node));
            }
        }
    }

    public List<Renderable> getRenderables() {
        return this.renderables;
    }

    static class Item
    implements ModifierTarget {
        Element element;
        Slot slot;
        Object valueChangeListeners;
        private EventListener<Event> changeListener;

        Item() {
        }

        @Override
        public HTMLElement getElement() {
            return (HTMLElement)this.element;
        }

        @Override
        public void updateValue(String value) {
            Item.updateValueNative(this.element, value);
            this.triggerValueChanged(value);
        }

        private void triggerValueChanged(String value) {
            if (this.valueChangeListeners == null) {
                return;
            }
            if (this.valueChangeListeners instanceof List) {
                List listeners = (List)this.valueChangeListeners;
                for (ValueChangeListener listener : listeners) {
                    listener.changed(value);
                }
            } else {
                ValueChangeListener listener = (ValueChangeListener)this.valueChangeListeners;
                listener.changed(value);
            }
        }

        @Override
        public void addValueChangeListener(ValueChangeListener<String> listener) {
            if (this.valueChangeListeners == null) {
                this.valueChangeListeners = listener;
                HTMLElement htmlElement = (HTMLElement)this.element;
                this.createChangeListener();
                htmlElement.addEventListener("change", this.changeListener);
            } else if (this.valueChangeListeners instanceof List) {
                List listeners = (List)this.valueChangeListeners;
                listeners.add(listener);
            } else {
                ArrayList<ValueChangeListener<String>> listeners = new ArrayList<ValueChangeListener<String>>(2);
                listeners.add((ValueChangeListener)this.valueChangeListeners);
                listeners.add(listener);
                this.valueChangeListeners = listeners;
            }
        }

        @Override
        public void removeValueChangeListener(ValueChangeListener<String> listener) {
            if (this.valueChangeListeners != null) {
                if (this.valueChangeListeners == listener) {
                    HTMLElement htmlElement = (HTMLElement)this.element;
                    htmlElement.removeEventListener("change", this.changeListener);
                    this.changeListener = null;
                    this.valueChangeListeners = null;
                } else if (this.valueChangeListeners instanceof List) {
                    List listeners = (List)this.valueChangeListeners;
                    listeners.remove(listener);
                    if (listeners.size() == 1) {
                        this.valueChangeListeners = listeners.get(0);
                    }
                }
            }
        }

        private void createChangeListener() {
            this.changeListener = event -> this.triggerValueChanged(this.getValue());
        }

        @Override
        public String getValue() {
            return Item.getValueNative(this.element);
        }

        @JSBody(params={"element", "value"}, script="element.value = value;")
        private static native void updateValueNative(Element var0, String var1);

        @JSBody(params={"element"}, script="return element.value;")
        private static native String getValueNative(Element var0);
    }
}

