/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.components.standard;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import org.teavm.flavour.templates.AbstractComponent;
import org.teavm.flavour.templates.BindAttribute;
import org.teavm.flavour.templates.BindContent;
import org.teavm.flavour.templates.BindElement;
import org.teavm.flavour.templates.Component;
import org.teavm.flavour.templates.Fragment;
import org.teavm.flavour.templates.OptionalBinding;
import org.teavm.flavour.templates.Slot;

@BindElement(name={"foreach"})
public class ForEachComponent<T>
extends AbstractComponent {
    private Supplier<Iterable<T>> collection;
    private T elementVariable;
    private int indexVariable;
    private Fragment body;
    private List<Component> childComponents = new LinkedList<Component>();
    private List<T> computedCollection = new LinkedList<T>();

    public ForEachComponent(Slot slot) {
        super(slot);
    }

    @BindAttribute(name="in")
    public void setCollection(Supplier<Iterable<T>> collection) {
        this.collection = collection;
    }

    @BindAttribute(name="var")
    public T getElementVariable() {
        return this.elementVariable;
    }

    @BindAttribute(name="index")
    @OptionalBinding
    public int getIndexVariable() {
        return this.indexVariable;
    }

    @BindContent
    public void setBody(Fragment body) {
        this.body = body;
    }

    @Override
    public void render() {
        block4: {
            Slot nextSlot;
            int newDataLimit;
            ListIterator<Component> upperComponentIterator;
            ListIterator<Component> lowerComponentIterator;
            ListIterator<T> lowerNewDataIterator;
            ListIterator<T> lowerDataIterator;
            block3: {
                Component component;
                List<T> newComputedCollection = this.initNewCollection();
                lowerDataIterator = this.computedCollection.listIterator();
                lowerNewDataIterator = newComputedCollection.listIterator();
                lowerComponentIterator = this.childComponents.listIterator();
                ListIterator<T> upperDataIterator = this.computedCollection.listIterator(this.computedCollection.size());
                ListIterator<T> upperNewDataIterator = newComputedCollection.listIterator(newComputedCollection.size());
                upperComponentIterator = this.childComponents.listIterator(this.childComponents.size());
                this.findLastChangedItem(upperDataIterator, upperNewDataIterator, upperComponentIterator);
                int dataLimit = upperDataIterator.nextIndex();
                newDataLimit = upperNewDataIterator.nextIndex();
                while (lowerDataIterator.hasNext() && lowerDataIterator.nextIndex() < dataLimit && lowerNewDataIterator.hasNext() && lowerNewDataIterator.nextIndex() < newDataLimit) {
                    component = lowerComponentIterator.next();
                    this.indexVariable = lowerDataIterator.nextIndex();
                    this.elementVariable = lowerNewDataIterator.next();
                    lowerDataIterator.next();
                    component.render();
                }
                if (!lowerDataIterator.hasNext() || lowerDataIterator.nextIndex() >= dataLimit) break block3;
                while (lowerDataIterator.hasNext() && lowerDataIterator.nextIndex() < dataLimit) {
                    component = lowerComponentIterator.next();
                    lowerComponentIterator.remove();
                    component.destroy();
                    lowerDataIterator.next();
                    lowerDataIterator.remove();
                    --dataLimit;
                }
                break block4;
            }
            if (!lowerNewDataIterator.hasNext() || lowerNewDataIterator.nextIndex() >= newDataLimit) break block4;
            Component nextComponent = upperComponentIterator.hasNext() ? upperComponentIterator.next() : null;
            Slot slot = nextSlot = nextComponent != null ? nextComponent.getSlot() : null;
            while (lowerNewDataIterator.hasNext() && lowerNewDataIterator.nextIndex() < newDataLimit) {
                this.indexVariable = lowerNewDataIterator.nextIndex();
                this.elementVariable = lowerNewDataIterator.next();
                lowerDataIterator.add(this.elementVariable);
                Component childComponent = this.body.create();
                childComponent.render();
                lowerComponentIterator.add(childComponent);
                this.getSlot().insertBefore(childComponent.getSlot(), nextSlot);
            }
        }
    }

    private List<T> initNewCollection() {
        LinkedList<T> newComputedCollection;
        Iterable<T> items = this.collection.get();
        if (items instanceof List) {
            newComputedCollection = (LinkedList<T>)items;
        } else if (items instanceof Collection) {
            Collection safeItems = (Collection)items;
            newComputedCollection = new LinkedList(safeItems);
        } else {
            newComputedCollection = new LinkedList<T>();
            for (T item : items) {
                newComputedCollection.add(item);
            }
        }
        return newComputedCollection;
    }

    private void findLastChangedItem(ListIterator<T> dataIterator, ListIterator<T> newDataIterator, ListIterator<Component> componentIterator) {
        while (dataIterator.hasPrevious() && newDataIterator.hasPrevious()) {
            this.indexVariable = newDataIterator.previousIndex();
            this.elementVariable = newDataIterator.previous();
            if (this.elementVariable != dataIterator.previous()) {
                dataIterator.next();
                newDataIterator.next();
                break;
            }
            Component component = componentIterator.previous();
            component.render();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        for (int i = this.childComponents.size() - 1; i >= 0; --i) {
            this.childComponents.get(i).destroy();
        }
    }
}

