/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.components.standard;

import java.util.List;
import org.teavm.flavour.components.standard.ChooseClause;
import org.teavm.flavour.components.standard.OtherwiseClause;
import org.teavm.flavour.templates.AbstractComponent;
import org.teavm.flavour.templates.BindElement;
import org.teavm.flavour.templates.Component;
import org.teavm.flavour.templates.OptionalBinding;
import org.teavm.flavour.templates.Slot;

@BindElement(name={"choose"})
public class ChooseComponent
extends AbstractComponent {
    private List<ChooseClause> clauses;
    private OtherwiseClause otherwiseClause;
    private Component child;
    private ChooseClause currentClause;
    private boolean dirty = true;

    public ChooseComponent(Slot slot) {
        super(slot);
    }

    @BindElement(name={"option"})
    public void setClauses(List<ChooseClause> clauses) {
        this.clauses = clauses;
    }

    @BindElement(name={"otherwise"})
    @OptionalBinding
    public void setOtherwiseClause(OtherwiseClause otherwiseClause) {
        this.otherwiseClause = otherwiseClause;
    }

    @Override
    public void render() {
        ChooseClause newClause = null;
        for (ChooseClause clause : this.clauses) {
            if (!clause.predicate.getAsBoolean()) continue;
            newClause = clause;
            break;
        }
        if (this.dirty || this.currentClause != newClause) {
            if (this.child != null) {
                this.child.destroy();
                this.child = null;
            }
            this.currentClause = newClause;
            if (this.currentClause != null) {
                this.child = this.currentClause.content.create();
            } else if (this.otherwiseClause != null) {
                this.child = this.otherwiseClause.content.create();
            }
            this.getSlot().append(this.child.getSlot());
            this.dirty = false;
        }
        if (this.child != null) {
            this.child.render();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.child != null) {
            this.child.destroy();
            this.child = null;
        }
    }
}

