/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.components.html;

import java.util.Objects;
import java.util.function.Supplier;
import org.teavm.flavour.templates.BindAttributeComponent;
import org.teavm.flavour.templates.BindContent;
import org.teavm.flavour.templates.ModifierTarget;
import org.teavm.flavour.templates.Renderable;
import org.teavm.jso.dom.html.HTMLInputElement;

@BindAttributeComponent(name={"value"})
public class ValueBinder<T>
implements Renderable {
    HTMLInputElement element;
    private Supplier<T> value;
    private Object cachedValue;

    public ValueBinder(ModifierTarget target) {
        this.element = (HTMLInputElement)target.getElement();
    }

    @BindContent
    public void setValue(Supplier<T> value) {
        this.value = value;
    }

    @Override
    public void render() {
        T newValue = this.value.get();
        if (!Objects.equals(newValue, this.cachedValue)) {
            this.cachedValue = newValue;
            this.element.setValue(String.valueOf(newValue));
        }
    }

    @Override
    public void destroy() {
    }
}

