/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.components.html;

import java.util.Objects;
import java.util.function.Supplier;
import org.teavm.flavour.templates.AbstractComponent;
import org.teavm.flavour.templates.BindAttribute;
import org.teavm.flavour.templates.BindElement;
import org.teavm.flavour.templates.IgnoreContent;
import org.teavm.flavour.templates.NodeHolder;
import org.teavm.flavour.templates.Slot;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.xml.Node;

@BindElement(name={"text"})
@IgnoreContent
public class TextComponent<T>
extends AbstractComponent {
    private Supplier<T> value;
    private NodeHolder textSlot;
    private T cachedValue;
    private boolean cacheInitialized;

    public TextComponent(Slot slot) {
        super(slot);
    }

    @BindAttribute(name="value")
    public void setValue(Supplier<T> value) {
        this.value = value;
    }

    @Override
    public void render() {
        T computedValue = this.value.get();
        if (this.cacheInitialized && Objects.equals(this.cachedValue, computedValue)) {
            return;
        }
        this.cacheInitialized = true;
        this.cachedValue = computedValue;
        if (this.textSlot != null) {
            this.textSlot.delete();
            this.textSlot = null;
        }
        this.textSlot = new NodeHolder((Node)Window.current().getDocument().createTextNode(String.valueOf(computedValue)));
        this.getSlot().append(this.textSlot);
    }
}

