/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.components.html;

import java.util.Objects;
import java.util.function.Supplier;
import org.teavm.flavour.templates.BindAttributeComponent;
import org.teavm.flavour.templates.BindContent;
import org.teavm.flavour.templates.ModifierTarget;
import org.teavm.flavour.templates.Renderable;
import org.teavm.flavour.templates.ValueChangeListener;
import org.teavm.jso.dom.html.HTMLInputElement;

@BindAttributeComponent(name={"bidir-value"})
public class BidirectionalValueBinder<T>
implements Renderable {
    private ModifierTarget target;
    private HTMLInputElement element;
    private Supplier<T> value;
    private Object cachedValue;
    private ValueChangeListener<String> listener;
    private boolean bound;

    public BidirectionalValueBinder(ModifierTarget target) {
        this.target = target;
        this.element = (HTMLInputElement)target.getElement();
    }

    @BindContent
    public void setValue(Supplier<T> value) {
        this.value = value;
    }

    @BindContent
    public void setListener(ValueChangeListener<String> listener) {
        this.listener = listener;
    }

    @Override
    public void render() {
        T newValue = this.value.get();
        if (!Objects.equals(newValue, this.cachedValue)) {
            this.cachedValue = newValue;
            this.element.setValue(String.valueOf(newValue));
        }
        if (!this.bound) {
            this.bound = true;
            this.target.addValueChangeListener(this.listener);
        }
    }

    @Override
    public void destroy() {
        if (this.bound) {
            this.bound = false;
            this.target.removeValueChangeListener(this.listener);
        }
    }
}

