/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.components.events;

import java.util.function.Consumer;
import org.teavm.flavour.templates.BindContent;
import org.teavm.flavour.templates.BindElementName;
import org.teavm.flavour.templates.ModifierTarget;
import org.teavm.flavour.templates.Renderable;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLElement;

public abstract class BaseAsyncEventBinder<T extends Event>
implements Renderable {
    private HTMLElement element;
    private String eventName;
    private EventListener<T> action;
    private boolean bound;

    public BaseAsyncEventBinder(ModifierTarget target) {
        this.element = target.getElement();
    }

    @BindElementName
    public void setEventName(String eventName) {
        this.eventName = eventName.substring("async-".length());
    }

    @BindContent
    public void setHandler(Consumer<T> handler) {
        this.action = evt -> new Thread(() -> handler.accept(evt)).start();
    }

    @Override
    public void render() {
        if (!this.bound) {
            this.bound = true;
            this.element.addEventListener(this.eventName, this.action);
        }
    }

    @Override
    public void destroy() {
        if (this.bound) {
            this.bound = false;
            this.element.removeEventListener(this.eventName, this.action);
        }
    }
}

