/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.components.attributes;

import java.util.Objects;
import java.util.function.Supplier;
import org.teavm.flavour.templates.BindAttributeComponent;
import org.teavm.flavour.templates.BindContent;
import org.teavm.flavour.templates.BindElementName;
import org.teavm.flavour.templates.ModifierTarget;
import org.teavm.flavour.templates.Renderable;
import org.teavm.jso.dom.html.HTMLElement;

@BindAttributeComponent(name={"*"})
public class ComputedAttribute
implements Renderable {
    private HTMLElement element;
    private Supplier<?> value;
    private Object cachedValue;
    private String name;

    public ComputedAttribute(ModifierTarget target) {
        this.element = target.getElement();
    }

    @BindContent
    public void setValue(Supplier<?> value) {
        this.value = value;
    }

    @BindElementName
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void render() {
        Object newValue = this.value.get();
        if (!Objects.equals(newValue, this.cachedValue)) {
            this.cachedValue = newValue;
            this.element.setAttribute(this.name, String.valueOf(newValue));
        }
    }

    @Override
    public void destroy() {
        this.element.removeAttribute(this.name);
    }
}

