/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.serializer;

import java.util.Map;
import org.teavm.flavour.json.serializer.JsonSerializer;
import org.teavm.flavour.json.serializer.JsonSerializerContext;
import org.teavm.flavour.json.serializer.NullableSerializer;
import org.teavm.flavour.json.tree.Node;
import org.teavm.flavour.json.tree.ObjectNode;
import org.teavm.flavour.json.tree.StringNode;

public class MapSerializer
extends NullableSerializer {
    private JsonSerializer keySerializer;
    private JsonSerializer valueSerializer;

    public MapSerializer(JsonSerializer keySerializer, JsonSerializer valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public Node serializeNonNull(JsonSerializerContext context, Object value) {
        ObjectNode result = ObjectNode.create();
        for (Map.Entry entry : ((Map)value).entrySet()) {
            StringNode key = (StringNode)this.keySerializer.serialize(context, entry.getKey());
            result.set(key.getValue(), this.valueSerializer.serialize(context, entry.getValue()));
        }
        return result;
    }
}

