/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.emit;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.teavm.flavour.json.JSON;
import org.teavm.flavour.json.JsonPersistable;
import org.teavm.flavour.json.emit.ClassInformation;
import org.teavm.flavour.json.emit.ClassInformationProvider;
import org.teavm.flavour.json.emit.DateFormatInformation;
import org.teavm.flavour.json.emit.GenericTypeProvider;
import org.teavm.flavour.json.emit.PropertyInformation;
import org.teavm.flavour.json.serializer.ArraySerializer;
import org.teavm.flavour.json.serializer.BooleanArraySerializer;
import org.teavm.flavour.json.serializer.BooleanSerializer;
import org.teavm.flavour.json.serializer.ByteArraySerializer;
import org.teavm.flavour.json.serializer.CharArraySerializer;
import org.teavm.flavour.json.serializer.CharacterSerializer;
import org.teavm.flavour.json.serializer.DoubleArraySerializer;
import org.teavm.flavour.json.serializer.DoubleSerializer;
import org.teavm.flavour.json.serializer.EnumSerializer;
import org.teavm.flavour.json.serializer.FloatArraySerializer;
import org.teavm.flavour.json.serializer.IntArraySerializer;
import org.teavm.flavour.json.serializer.IntegerSerializer;
import org.teavm.flavour.json.serializer.JsonSerializer;
import org.teavm.flavour.json.serializer.JsonSerializerContext;
import org.teavm.flavour.json.serializer.ListSerializer;
import org.teavm.flavour.json.serializer.LongArraySerializer;
import org.teavm.flavour.json.serializer.MapSerializer;
import org.teavm.flavour.json.serializer.ObjectSerializer;
import org.teavm.flavour.json.serializer.ShortArraySerializer;
import org.teavm.flavour.json.serializer.StringSerializer;
import org.teavm.flavour.json.tree.ArrayNode;
import org.teavm.flavour.json.tree.BooleanNode;
import org.teavm.flavour.json.tree.Node;
import org.teavm.flavour.json.tree.NullNode;
import org.teavm.flavour.json.tree.NumberNode;
import org.teavm.flavour.json.tree.ObjectNode;
import org.teavm.flavour.json.tree.StringNode;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.reflect.ReflectAnnotatedElement;
import org.teavm.metaprogramming.reflect.ReflectField;
import org.teavm.metaprogramming.reflect.ReflectMethod;

public class JsonSerializerEmitter {
    private ClassInformationProvider informationProvider;
    private GenericTypeProvider genericTypeProvider = new GenericTypeProvider(Metaprogramming.getClassLoader());
    private static Map<String, Class<?>> predefinedSerializers = new HashMap();

    public JsonSerializerEmitter() {
        this.informationProvider = ClassInformationProvider.getInstance();
    }

    public void returnClassSerializer(ReflectClass<?> cls) {
        Value<JsonSerializer> serializer = this.getClassSerializer(cls);
        if (serializer == null) {
            Metaprogramming.unsupportedCase();
            return;
        }
        Metaprogramming.exit(() -> (JsonSerializer)serializer.get());
    }

    public Value<JsonSerializer> getClassSerializer(ReflectClass<?> cls) {
        Value<JsonSerializer> serializer = this.tryGetPredefinedSerializer(cls);
        if (serializer == null) {
            serializer = this.emitClassSerializer(cls);
        }
        return serializer;
    }

    private Value<JsonSerializer> tryGetPredefinedSerializer(ReflectClass<?> cls) {
        Class<?> serializerType;
        Class<?> clazz = serializerType = !cls.isArray() ? predefinedSerializers.get(cls.getName()) : null;
        if (serializerType != null) {
            ReflectMethod ctor = Metaprogramming.findClass(serializerType).getDeclaredMethod("<init>", new ReflectClass[0]);
            return Metaprogramming.emit(() -> (JsonSerializer)ctor.construct(new Object[0]));
        }
        if (cls.isEnum()) {
            if (cls.getAnnotation(JsonPersistable.class) == null) {
                return null;
            }
            return Metaprogramming.emit(() -> new EnumSerializer());
        }
        if (Metaprogramming.findClass(Map.class).isAssignableFrom(cls)) {
            Value<JsonSerializer> itemSerializer = this.createObjectSerializer(Object.class);
            return Metaprogramming.emit(() -> new MapSerializer((JsonSerializer)itemSerializer.get(), (JsonSerializer)itemSerializer.get()));
        }
        if (Metaprogramming.findClass(Collection.class).isAssignableFrom(cls)) {
            Value<JsonSerializer> itemSerializer = this.createObjectSerializer(Object.class);
            return Metaprogramming.emit(() -> new ListSerializer((JsonSerializer)itemSerializer.get()));
        }
        return null;
    }

    private Value<JsonSerializer> emitClassSerializer(ReflectClass<?> cls) {
        if (cls.isArray()) {
            Value objectComponentSerializer;
            ReflectClass componentType = cls.getComponentType();
            Value<JsonSerializer> componentSerializer = this.getPrimitiveSerializer(componentType);
            if (componentSerializer != null) {
                return Metaprogramming.proxy(JsonSerializer.class, (instance, method, args) -> {
                    Value context = Metaprogramming.emit(() -> (JsonSerializerContext)args[0]);
                    Value value = args[1];
                    Metaprogramming.exit(() -> {
                        ArrayNode target = ArrayNode.create();
                        int sz = cls.getArrayLength(value.get());
                        for (int i = 0; i < sz; ++i) {
                            Object component = cls.getArrayElement(value.get(), i);
                            target.add(((JsonSerializer)componentSerializer.get()).serialize((JsonSerializerContext)context.get(), component));
                        }
                        return target;
                    });
                });
            }
            if (componentType.getName().equals("java.lang.Object")) {
                objectComponentSerializer = Metaprogramming.emit(() -> ObjectSerializer.INSTANCE);
            } else {
                if (this.getClassSerializer(componentType) == null) {
                    return null;
                }
                objectComponentSerializer = Metaprogramming.proxy(JsonSerializer.class, (instance, method, args) -> {
                    Value context = args[0];
                    Value value = args[1];
                    Value result = Metaprogramming.emit(() -> JSON.serialize((JsonSerializerContext)context.get(), componentType.cast(value.get())));
                    Metaprogramming.exit(() -> (Node)result.get());
                });
            }
            return Metaprogramming.emit(() -> new ArraySerializer((JsonSerializer)objectComponentSerializer.get()));
        }
        ClassInformation information = this.informationProvider.get(cls.getName());
        if (information == null || !information.persistable) {
            return null;
        }
        return Metaprogramming.proxy(JsonSerializer.class, (instance, method, args) -> {
            Value context = Metaprogramming.emit(() -> (JsonSerializerContext)args[0]);
            Value value = args[1];
            Value target = Metaprogramming.emit(() -> ObjectNode.create());
            this.emitIdentity(information, (Value<Object>)value, (Value<JsonSerializerContext>)context, (Value<ObjectNode>)target);
            this.emitProperties(information, (Value<Object>)value, (Value<JsonSerializerContext>)context, (Value<ObjectNode>)target);
            Value<? extends Node> result = this.emitInheritance(information, (Value<ObjectNode>)target);
            Metaprogramming.exit(() -> (Node)result.get());
        });
    }

    private Value<JsonSerializer> getPrimitiveSerializer(ReflectClass<?> cls) {
        if (cls.isPrimitive()) {
            switch (cls.getName()) {
                case "boolean": {
                    return Metaprogramming.emit(() -> new BooleanSerializer());
                }
                case "char": {
                    return Metaprogramming.emit(() -> new CharacterSerializer());
                }
                case "byte": 
                case "short": 
                case "int": {
                    return Metaprogramming.emit(() -> new IntegerSerializer());
                }
                case "long": 
                case "float": 
                case "double": {
                    return Metaprogramming.emit(() -> new DoubleSerializer());
                }
            }
        } else if (cls.getName().equals(String.class.getName())) {
            return Metaprogramming.emit(() -> new StringSerializer());
        }
        return null;
    }

    private void emitIdentity(ClassInformation information, Value<Object> value, Value<JsonSerializerContext> context, Value<ObjectNode> target) {
        switch (information.idGenerator) {
            case NONE: {
                Metaprogramming.emit(() -> ((JsonSerializerContext)context.get()).touch(value.get()));
                break;
            }
            case INTEGER: {
                this.emitIntegerIdentity(information, value, context, target);
                break;
            }
        }
    }

    private void emitIntegerIdentity(ClassInformation information, Value<Object> value, Value<JsonSerializerContext> context, Value<ObjectNode> target) {
        String idProperty = information.idProperty;
        Value has = Metaprogramming.emit(() -> ((JsonSerializerContext)context.get()).hasId(value.get()));
        Value id = Metaprogramming.emit(() -> NumberNode.create(((JsonSerializerContext)context.get()).getId(value.get())));
        Value returnIntegerId = Metaprogramming.lazyFragment(() -> {
            Metaprogramming.exit(() -> (NumberNode)id.get());
            return null;
        });
        Metaprogramming.emit(() -> {
            if (((Boolean)has.get()).booleanValue()) {
                returnIntegerId.get();
            } else {
                ((ObjectNode)target.get()).set(idProperty, (Node)id.get());
            }
        });
    }

    private void emitProperties(ClassInformation information, Value<Object> value, Value<JsonSerializerContext> context, Value<ObjectNode> target) {
        for (PropertyInformation property : information.properties.values()) {
            if (property.ignored) continue;
            if (property.getter != null) {
                this.emitGetter(property, value, context, target);
                continue;
            }
            if (property.field == null) continue;
            this.emitField(property, value, context, target);
        }
    }

    private Value<? extends Node> emitInheritance(ClassInformation information, Value<ObjectNode> target) {
        String typeName;
        if (information.inheritance.key == null) {
            return target;
        }
        switch (information.inheritance.value) {
            case CLASS: {
                typeName = information.className;
                break;
            }
            case MINIMAL_CLASS: {
                typeName = ClassInformationProvider.getUnqualifiedName(information.className);
                break;
            }
            case NAME: {
                typeName = !information.typeName.isEmpty() ? information.typeName : ClassInformationProvider.getUnqualifiedName(information.className);
                break;
            }
            default: {
                return target;
            }
        }
        String propertyName = information.inheritance.propertyName;
        switch (information.inheritance.key) {
            case PROPERTY: {
                Metaprogramming.emit(() -> ((ObjectNode)target.get()).set(propertyName, StringNode.create(typeName)));
                break;
            }
            case WRAPPER_OBJECT: {
                return Metaprogramming.emit(() -> {
                    ObjectNode wrapper = ObjectNode.create();
                    wrapper.set(typeName, (Node)target.get());
                    return wrapper;
                });
            }
            case WRAPPER_ARRAY: {
                return Metaprogramming.emit(() -> {
                    ArrayNode wrapper = ArrayNode.create();
                    wrapper.add(StringNode.create(typeName));
                    wrapper.add((Node)target.get());
                    return wrapper;
                });
            }
        }
        return target;
    }

    private void emitGetter(PropertyInformation property, Value<Object> value, Value<JsonSerializerContext> context, Value<ObjectNode> target) {
        ReflectMethod method = property.getter;
        String outputName = property.outputName;
        Method javaMethod = this.genericTypeProvider.findMethod(method);
        Type type = javaMethod.getGenericReturnType();
        Value<Node> propertyValue = this.convertValue((Value<Object>)Metaprogramming.emit(() -> method.invoke(value.get(), new Object[0])), context, type, (ReflectAnnotatedElement)method);
        Metaprogramming.emit(() -> ((ObjectNode)target.get()).set(outputName, (Node)propertyValue.get()));
    }

    private void emitField(PropertyInformation property, Value<Object> value, Value<JsonSerializerContext> context, Value<ObjectNode> target) {
        ReflectField field = property.field;
        Field javaField = this.genericTypeProvider.findField(field);
        String outputName = property.outputName;
        Value<Node> propertyValue = this.convertValue((Value<Object>)Metaprogramming.emit(() -> field.get(value.get())), context, javaField.getGenericType(), (ReflectAnnotatedElement)field);
        Metaprogramming.emit(() -> ((ObjectNode)target.get()).set(outputName, (Node)propertyValue.get()));
    }

    private Value<Node> convertValue(Value<Object> value, Value<JsonSerializerContext> context, Type type, ReflectAnnotatedElement annotations) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (!cls.isArray()) {
                if (cls.getName().equals(String.class.getName())) {
                    return Metaprogramming.emit(() -> StringNode.create((String)value.get()));
                }
                if (Metaprogramming.findClass(Date.class).isAssignableFrom(cls)) {
                    return this.convertDate(value, annotations);
                }
            }
            if (cls.isPrimitive()) {
                return this.convertPrimitive(value, cls);
            }
        }
        return this.convertNullable(value, context, type, annotations);
    }

    private Value<JsonSerializer> createSerializer(Type type, ReflectAnnotatedElement annotations) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isArray() ? this.createArraySerializer(cls.getComponentType(), annotations) : this.createObjectSerializer(cls);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (paramType.getRawType().equals(Map.class)) {
                return this.createMapSerializer(typeArgs[0], typeArgs[1], annotations);
            }
            if (paramType.getRawType().equals(List.class) || paramType.getRawType().equals(Set.class)) {
                return this.createListSerializer(typeArgs[0], annotations);
            }
            return this.createSerializer(paramType.getRawType(), annotations);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return this.createArraySerializer(arrayType, annotations);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            Type upperBound = wildcard.getUpperBounds()[0];
            Class upperCls = Object.class;
            if (upperBound instanceof Class) {
                upperCls = (Class)upperBound;
            }
            return this.createObjectSerializer(upperCls);
        }
        if (type instanceof TypeVariable) {
            TypeVariable tyvar = (TypeVariable)type;
            Type upperBound = tyvar.getBounds()[0];
            Class upperCls = Object.class;
            if (upperBound instanceof Class) {
                upperCls = (Class)upperBound;
            }
            return this.createObjectSerializer(upperCls);
        }
        return this.createObjectSerializer(Object.class);
    }

    private Value<JsonSerializer> createArraySerializer(Class<?> type, ReflectAnnotatedElement annotations) {
        if (type.isPrimitive()) {
            String name;
            switch (name = type.getName()) {
                case "boolean": {
                    return Metaprogramming.emit(() -> new BooleanArraySerializer());
                }
                case "byte": {
                    return Metaprogramming.emit(() -> new ByteArraySerializer());
                }
                case "short": {
                    return Metaprogramming.emit(() -> new ShortArraySerializer());
                }
                case "char": {
                    return Metaprogramming.emit(() -> new CharArraySerializer());
                }
                case "int": {
                    return Metaprogramming.emit(() -> new IntArraySerializer());
                }
                case "long": {
                    return Metaprogramming.emit(() -> new LongArraySerializer());
                }
                case "float": {
                    return Metaprogramming.emit(() -> new FloatArraySerializer());
                }
                case "double": {
                    return Metaprogramming.emit(() -> new DoubleArraySerializer());
                }
            }
        }
        Value<JsonSerializer> itemSerializer = this.createSerializer(type, annotations);
        return Metaprogramming.emit(() -> new ArraySerializer((JsonSerializer)itemSerializer.get()));
    }

    private Value<JsonSerializer> createArraySerializer(GenericArrayType type, ReflectAnnotatedElement annotations) {
        Value<JsonSerializer> itemSerializer = this.createSerializer(type.getGenericComponentType(), annotations);
        return Metaprogramming.emit(() -> new ArraySerializer((JsonSerializer)itemSerializer.get()));
    }

    private Value<JsonSerializer> createObjectSerializer(Class<?> type) {
        ReflectClass cls = Metaprogramming.findClass(type);
        return Metaprogramming.proxy(JsonSerializer.class, (instance, method, args) -> {
            Value castValue = Metaprogramming.emit(() -> cls.cast(args[1].get()));
            Value result = Metaprogramming.emit(() -> JSON.serialize((JsonSerializerContext)args[0].get(), castValue.get()));
            Metaprogramming.exit(() -> (Node)result.get());
        });
    }

    private Value<Node> convertNullable(Value<Object> value, Value<JsonSerializerContext> context, Type type, ReflectAnnotatedElement annotations) {
        Value result = Metaprogramming.lazyFragment(() -> {
            Value<JsonSerializer> serializer = this.createSerializer(type, annotations);
            return Metaprogramming.emit(() -> ((JsonSerializer)serializer.get()).serialize((JsonSerializerContext)context.get(), value.get()));
        });
        return Metaprogramming.emit(() -> value.get() == null ? NullNode.instance() : (Node)result.get());
    }

    private Value<Node> convertPrimitive(Value<Object> value, Class<?> type) {
        switch (type.getName()) {
            case "boolean": {
                return Metaprogramming.emit(() -> BooleanNode.get((Boolean)value.get()));
            }
            case "byte": {
                return Metaprogramming.emit(() -> NumberNode.create(((Byte)value.get()).byteValue()));
            }
            case "short": {
                return Metaprogramming.emit(() -> NumberNode.create(((Short)value.get()).shortValue()));
            }
            case "char": {
                return Metaprogramming.emit(() -> NumberNode.create(((Character)value.get()).charValue()));
            }
            case "int": {
                return Metaprogramming.emit(() -> NumberNode.create((Integer)value.get()));
            }
            case "long": {
                return Metaprogramming.emit(() -> NumberNode.create(((Long)value.get()).longValue()));
            }
            case "float": {
                return Metaprogramming.emit(() -> NumberNode.create(((Float)value.get()).floatValue()));
            }
            case "double": {
                return Metaprogramming.emit(() -> NumberNode.create((Double)value.get()));
            }
        }
        throw new AssertionError((Object)("Unknown primitive type: " + type));
    }

    private Value<JsonSerializer> createListSerializer(Type type, ReflectAnnotatedElement annotations) {
        Value<JsonSerializer> itemSerializer = this.createSerializer(type, annotations);
        return Metaprogramming.emit(() -> new ListSerializer((JsonSerializer)itemSerializer.get()));
    }

    private Value<JsonSerializer> createMapSerializer(Type keyType, Type valueType, ReflectAnnotatedElement annotations) {
        Value<JsonSerializer> keySerializer = this.createSerializer(keyType, annotations);
        Value<JsonSerializer> valueSerializer = this.createSerializer(valueType, annotations);
        return Metaprogramming.emit(() -> new MapSerializer((JsonSerializer)keySerializer.get(), (JsonSerializer)valueSerializer.get()));
    }

    private Value<Node> convertDate(Value<Object> value, ReflectAnnotatedElement annotations) {
        DateFormatInformation formatInfo = DateFormatInformation.get(annotations);
        if (formatInfo.asString) {
            String localeName = formatInfo.locale;
            String pattern = formatInfo.pattern;
            Value locale = formatInfo.locale != null ? Metaprogramming.emit(() -> new Locale(localeName)) : Metaprogramming.emit(() -> Locale.getDefault());
            return Metaprogramming.emit(() -> {
                if (value.get() == null) {
                    return NullNode.instance();
                }
                SimpleDateFormat format = new SimpleDateFormat(pattern, (Locale)locale.get());
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                return StringNode.create(format.format((Date)value.get()));
            });
        }
        return Metaprogramming.emit(() -> {
            Date date = (Date)value.get();
            return date != null ? NumberNode.create(date.getTime()) : NullNode.instance();
        });
    }

    static {
        predefinedSerializers.put(Boolean.class.getName(), BooleanSerializer.class);
        predefinedSerializers.put(Byte.class.getName(), IntegerSerializer.class);
        predefinedSerializers.put(Short.class.getName(), IntegerSerializer.class);
        predefinedSerializers.put(Character.class.getName(), CharacterSerializer.class);
        predefinedSerializers.put(Integer.class.getName(), IntegerSerializer.class);
        predefinedSerializers.put(Long.class.getName(), DoubleSerializer.class);
        predefinedSerializers.put(Float.class.getName(), DoubleSerializer.class);
        predefinedSerializers.put(Double.class.getName(), DoubleSerializer.class);
        predefinedSerializers.put(BigInteger.class.getName(), DoubleSerializer.class);
        predefinedSerializers.put(BigDecimal.class.getName(), DoubleSerializer.class);
        predefinedSerializers.put(String.class.getName(), StringSerializer.class);
    }
}

