/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.emit;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.json.emit.ClassInformation;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.reflect.ReflectField;
import org.teavm.metaprogramming.reflect.ReflectMethod;

class GenericTypeProvider {
    private ClassLoader classLoader;
    private Map<ReflectMethod, Method> methodCache = new HashMap<ReflectMethod, Method>();
    private Map<ReflectMethod, Constructor<?>> constructorCache = new HashMap();
    private Map<ReflectField, Field> fieldCache = new HashMap<ReflectField, Field>();
    private Map<String, Class<?>> classCache = new HashMap();

    GenericTypeProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    Method findMethod(ReflectMethod methodCache) {
        return this.methodCache.computeIfAbsent(methodCache, r -> {
            Class[] params = (Class[])Arrays.stream(methodCache.getParameterTypes()).map(this::convertType).toArray(Class[]::new);
            for (Class<?> owner = this.findClass(methodCache.getDeclaringClass().getName()); owner != null; owner = owner.getSuperclass()) {
                try {
                    return owner.getDeclaredMethod(methodCache.getName(), params);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            return null;
        });
    }

    Constructor<?> findConstructor(ReflectMethod method) {
        return this.constructorCache.computeIfAbsent(method, c -> {
            Class[] params = (Class[])Arrays.stream(method.getParameterTypes()).map(this::convertType).toArray(Class[]::new);
            for (Class<?> owner = this.findClass(method.getDeclaringClass().getName()); owner != null; owner = owner.getSuperclass()) {
                try {
                    return owner.getDeclaredConstructor(params);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            return null;
        });
    }

    Field findField(ReflectField field) {
        return this.fieldCache.computeIfAbsent(field, f -> {
            for (Class<?> owner = this.findClass(field.getDeclaringClass().getName()); owner != null; owner = owner.getSuperclass()) {
                try {
                    return owner.getDeclaredField(field.getName());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            return null;
        });
    }

    private Class<?> convertType(ReflectClass<?> type) {
        if (type.isPrimitive()) {
            switch (type.getName()) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
        } else if (type.isArray()) {
            Class<?> itemCls = this.convertType(type.getComponentType());
            return Array.newInstance(itemCls, 0).getClass();
        }
        return this.findClass(type.getName());
    }

    Class<?> findClass(String name) {
        return this.classCache.computeIfAbsent(name, n -> {
            try {
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can't find class " + name, e);
            }
        });
    }

    Type[] getGenericTypesForConstructor(ClassInformation information) {
        if (information.constructor.getName().equals("<init>")) {
            Constructor<?> javaCtor = this.findConstructor(information.constructor);
            return javaCtor.getGenericParameterTypes();
        }
        Method javaMethod = this.findMethod(information.constructor);
        return javaMethod.getGenericParameterTypes();
    }

    static Class<?> rawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return GenericTypeProvider.rawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(GenericTypeProvider.rawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return GenericTypeProvider.rawType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return GenericTypeProvider.rawType(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Don't know how to convert generic type: " + type);
    }
}

