/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.emit;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.teavm.flavour.json.JsonPersistable;
import org.teavm.flavour.json.emit.ClassInformation;
import org.teavm.flavour.json.emit.IdGeneratorType;
import org.teavm.flavour.json.emit.InheritanceKey;
import org.teavm.flavour.json.emit.InheritanceValue;
import org.teavm.flavour.json.emit.PropertyInformation;
import org.teavm.flavour.json.emit.Visibility;
import org.teavm.metaprogramming.Diagnostics;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.SourceLocation;
import org.teavm.metaprogramming.reflect.ReflectAnnotatedElement;
import org.teavm.metaprogramming.reflect.ReflectField;
import org.teavm.metaprogramming.reflect.ReflectMethod;

class ClassInformationProvider {
    private Map<String, ClassInformation> cache = new HashMap<String, ClassInformation>();
    private static Diagnostics diagnostics = Metaprogramming.getDiagnostics();
    private static ClassInformationProvider instance = new ClassInformationProvider();

    private ClassInformationProvider() {
    }

    public static ClassInformationProvider getInstance() {
        return instance;
    }

    public ClassInformation get(String className) {
        if (this.cache.containsKey(className)) {
            return this.cache.get(className);
        }
        ClassInformation info = this.createClassInformation(className);
        this.cache.put(className, info);
        if (info != null) {
            ReflectClass cls = Metaprogramming.findClass((String)className);
            this.getSubTypes(info, cls);
            if (info.isAbstract && info.persistable && info.inheritance.subTypes.isEmpty()) {
                diagnostics.error(null, "Class {{c0}} is persistable and abstract, but does not declare any subtypes", new Object[]{className});
            }
        }
        return info;
    }

    private ClassInformation createClassInformation(String className) {
        ReflectClass cls = Metaprogramming.findClass((String)className);
        if (cls == null) {
            return null;
        }
        if (cls.isInterface() || cls.isEnum()) {
            return null;
        }
        ClassInformation information = new ClassInformation();
        information.className = className;
        if (className.equals("java.lang.Object")) {
            return information;
        }
        if (cls.getSuperclass() != null && !cls.getSuperclass().getName().equals("java.lang.Object")) {
            ClassInformation parent;
            information.parent = parent = this.get(cls.getSuperclass().getName());
            for (PropertyInformation property : parent.properties.values()) {
                property = property.clone();
                information.properties.put(property.name, property);
                information.propertiesByOutputName.put(property.outputName, property);
            }
            information.inheritance = information.parent.inheritance.clone();
            information.typeName = information.parent.typeName;
            information.idGenerator = information.parent.idGenerator;
            information.idProperty = information.parent.idProperty;
        }
        information.persistable = cls.getAnnotation(JsonPersistable.class) != null;
        information.isAbstract = Modifier.isAbstract(cls.getModifiers());
        this.getAutoDetectModes(information, cls);
        this.getInheritance(information, cls);
        this.getIdentityInfo(information, cls);
        this.getIgnoredProperties(information, cls);
        this.scanCreators(information, cls);
        this.scanFields(information, cls);
        this.scanGetters(information, cls);
        this.scanSetters(information, cls);
        this.scanPropertyFields(information);
        return information;
    }

    private void getAutoDetectModes(ClassInformation information, ReflectClass<?> cls) {
        JsonAutoDetect annot;
        ClassInformation parent = information.parent;
        if (parent != null) {
            information.getterVisibility = parent.getterVisibility;
            information.isGetterVisibility = parent.isGetterVisibility;
            information.setterVisibility = parent.setterVisibility;
            information.fieldVisibility = parent.fieldVisibility;
            information.creatorVisibility = parent.creatorVisibility;
        }
        if ((annot = (JsonAutoDetect)cls.getAnnotation(JsonAutoDetect.class)) != null) {
            information.getterVisibility = this.getVisibility(annot.getterVisibility(), information.getterVisibility);
            information.isGetterVisibility = this.getVisibility(annot.isGetterVisibility(), information.isGetterVisibility);
            information.setterVisibility = this.getVisibility(annot.setterVisibility(), information.setterVisibility);
            information.fieldVisibility = this.getVisibility(annot.fieldVisibility(), information.fieldVisibility);
            information.creatorVisibility = this.getVisibility(annot.creatorVisibility(), information.creatorVisibility);
        }
    }

    private void getInheritance(ClassInformation information, ReflectClass<?> cls) {
        JsonTypeInfo typeInfo;
        JsonTypeName typeName = (JsonTypeName)cls.getAnnotation(JsonTypeName.class);
        if (information.typeName == null) {
            information.typeName = "";
        }
        if (typeName != null) {
            information.typeName = typeName.value();
            if (!information.persistable) {
                diagnostics.error(null, "Class {{c0}} can't declare '@JsonTypeName' as it's not persistable", new Object[]{cls.getName()});
            }
        }
        if (information.typeName.isEmpty()) {
            information.typeName = ClassInformationProvider.getUnqualifiedName(cls.getName());
        }
        if ((typeInfo = (JsonTypeInfo)cls.getAnnotation(JsonTypeInfo.class)) != null) {
            String defaultProperty = "";
            switch (typeInfo.use()) {
                case CLASS: {
                    information.inheritance.value = InheritanceValue.CLASS;
                    defaultProperty = "@class";
                    break;
                }
                case MINIMAL_CLASS: {
                    information.inheritance.value = InheritanceValue.MINIMAL_CLASS;
                    defaultProperty = "@c";
                    break;
                }
                case NAME: {
                    information.inheritance.value = InheritanceValue.NAME;
                    defaultProperty = "@type";
                    break;
                }
                case NONE: {
                    information.inheritance.value = InheritanceValue.NONE;
                    break;
                }
                default: {
                    diagnostics.warning(null, "{{t0}}: unsupported value " + typeInfo.use() + " in {{t1}}", new Object[]{cls, JsonTypeInfo.Id.class});
                }
            }
            if (information.inheritance.value != InheritanceValue.NONE) {
                switch (typeInfo.include()) {
                    case PROPERTY: {
                        information.inheritance.key = InheritanceKey.PROPERTY;
                        break;
                    }
                    case WRAPPER_ARRAY: {
                        information.inheritance.key = InheritanceKey.WRAPPER_ARRAY;
                        break;
                    }
                    case WRAPPER_OBJECT: {
                        information.inheritance.key = InheritanceKey.WRAPPER_OBJECT;
                        break;
                    }
                    default: {
                        diagnostics.warning(null, "{{t0}}: unsupported value " + typeInfo.include() + " in {{t1}}", new Object[]{cls, JsonTypeInfo.As.class});
                    }
                }
            }
            if (information.inheritance.key == InheritanceKey.PROPERTY) {
                String property = typeInfo.property();
                if (property.isEmpty()) {
                    property = defaultProperty;
                }
                information.inheritance.propertyName = property;
            }
        }
    }

    private void getIdentityInfo(ClassInformation information, ReflectClass<?> cls) {
        JsonIdentityInfo identity = (JsonIdentityInfo)cls.getAnnotation(JsonIdentityInfo.class);
        if (identity == null) {
            return;
        }
        Class generator = identity.generator();
        if (generator.equals(ObjectIdGenerators.IntSequenceGenerator.class)) {
            information.idGenerator = IdGeneratorType.INTEGER;
        } else if (generator.equals(ObjectIdGenerators.PropertyGenerator.class)) {
            information.idGenerator = IdGeneratorType.PROPERTY;
        } else if (generator.equals(ObjectIdGenerators.None.class)) {
            information.idGenerator = IdGeneratorType.NONE;
        } else {
            information.idGenerator = IdGeneratorType.NONE;
            diagnostics.warning(null, "{{t0}}: unsupported identity generator {{t1}}", new Object[]{cls, generator});
        }
        information.idProperty = information.idGenerator == IdGeneratorType.NONE ? null : identity.property();
    }

    static String getUnqualifiedName(String className) {
        return className.substring(Math.max(0, className.lastIndexOf(46)));
    }

    private void getIgnoredProperties(ClassInformation information, ReflectClass<?> cls) {
        JsonIgnoreProperties annot = (JsonIgnoreProperties)cls.getAnnotation(JsonIgnoreProperties.class);
        if (annot == null) {
            return;
        }
        for (String name : annot.value()) {
            PropertyInformation property = information.properties.get(name);
            if (property == null) {
                property = new PropertyInformation();
                property.name = name;
                information.properties.put(name, property);
            }
            property.ignored = true;
        }
    }

    private Visibility getVisibility(JsonAutoDetect.Visibility visibility, Visibility defaultVisibility) {
        switch (visibility) {
            case DEFAULT: {
                return defaultVisibility;
            }
            case ANY: {
                return Visibility.ANY;
            }
            case NON_PRIVATE: {
                return Visibility.NON_PRIVATE;
            }
            case NONE: {
                return Visibility.NONE;
            }
            case PROTECTED_AND_PUBLIC: {
                return Visibility.PROTECTED_AND_PUBLIC;
            }
            case PUBLIC_ONLY: {
                return Visibility.PUBLIC_ONLY;
            }
        }
        throw new AssertionError((Object)("Unsupported visibility:" + visibility));
    }

    private void getSubTypes(ClassInformation information, ReflectClass<?> cls) {
        JsonSubTypes annot = (JsonSubTypes)cls.getAnnotation(JsonSubTypes.class);
        if (annot == null) {
            return;
        }
        if (!information.persistable) {
            diagnostics.error(null, "Class {{c0}} is marked with `@JsonSubTypes` annotation, but it's not persistable", new Object[]{cls.getName()});
        }
        for (JsonSubTypes.Type subtype : annot.value()) {
            Class subclass = subtype.value();
            ClassInformation subtypeInformation = this.get(subclass.getName());
            if (subtypeInformation == null) continue;
            if (!subtypeInformation.persistable) {
                diagnostics.error(null, "Class {{c0}} declares subclass {{c1}}, but {{c1}} is not persistable", new Object[]{cls.getName(), subclass.getName()});
                continue;
            }
            information.inheritance.subTypes.add(subtypeInformation);
            if (!subtype.name().isEmpty()) {
                subtypeInformation.typeName = subtype.name();
            }
            if (subtypeInformation.typeName != null) continue;
            subtypeInformation.typeName = "";
        }
    }

    private void scanGetters(ClassInformation information, ReflectClass<?> cls) {
        for (ReflectMethod method : cls.getDeclaredMethods()) {
            String propertyName;
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (this.isGetterName(method.getName()) && method.getParameterCount() == 0 && method.getReturnType() != Metaprogramming.findClass(Void.TYPE)) {
                if (!this.hasExplicitPropertyDeclaration((ReflectAnnotatedElement)method) && !information.getterVisibility.match(method.getModifiers())) continue;
                propertyName = this.decapitalize(method.getName().substring(3));
                this.addGetter(information, propertyName, method);
                continue;
            }
            if (!this.isBooleanName(method.getName()) || method.getParameterCount() != 0 || method.getReturnType() != Metaprogramming.findClass(Boolean.TYPE) || !this.hasExplicitPropertyDeclaration((ReflectAnnotatedElement)method) && !information.isGetterVisibility.match(method.getModifiers())) continue;
            propertyName = this.decapitalize(method.getName().substring(2));
            this.addGetter(information, propertyName, method);
        }
    }

    private void scanSetters(ClassInformation information, ReflectClass<?> cls) {
        for (ReflectMethod method : cls.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !this.isSetterName(method.getName()) || method.getParameterCount() != 1 || method.getReturnType() != Metaprogramming.findClass(Void.TYPE) || !this.hasExplicitPropertyDeclaration((ReflectAnnotatedElement)method) && !information.setterVisibility.match(method.getModifiers())) continue;
            String propertyName = this.decapitalize(method.getName().substring(3));
            this.addSetter(information, propertyName, method);
        }
    }

    private void addGetter(ClassInformation information, String propertyName, ReflectMethod method) {
        PropertyInformation property = information.properties.get(propertyName);
        if (property != null) {
            information.propertiesByOutputName.remove(property.outputName);
        } else {
            property = new PropertyInformation();
            property.name = propertyName;
            property.outputName = propertyName;
            property.className = information.className;
            information.properties.put(propertyName, property);
        }
        if (property.ignored || this.isIgnored((ReflectAnnotatedElement)method)) {
            property.ignored = true;
            return;
        }
        property.outputName = this.getPropertyName((ReflectAnnotatedElement)method, property.outputName);
        PropertyInformation conflictingProperty = information.propertiesByOutputName.get(property.outputName);
        if (conflictingProperty != null) {
            SourceLocation location = new SourceLocation(method);
            diagnostics.error(location, "Duplicate property declaration " + propertyName + ". Already declared in {{c0}}", new Object[]{property.className});
            return;
        }
        information.propertiesByOutputName.put(property.outputName, property);
        property.getter = method;
    }

    private void addSetter(ClassInformation information, String propertyName, ReflectMethod method) {
        PropertyInformation property = information.properties.get(propertyName);
        if (property != null) {
            information.propertiesByOutputName.remove(property.outputName);
        } else {
            property = new PropertyInformation();
            property.name = propertyName;
            property.outputName = propertyName;
            property.className = information.className;
            information.properties.put(propertyName, property);
        }
        if (property.ignored || this.isIgnored((ReflectAnnotatedElement)method)) {
            property.ignored = true;
            return;
        }
        property.outputName = this.getPropertyName((ReflectAnnotatedElement)method, property.outputName);
        PropertyInformation conflictingProperty = information.propertiesByOutputName.get(property.outputName);
        if (conflictingProperty != null) {
            SourceLocation location = new SourceLocation(method);
            diagnostics.error(location, "Duplicate property declaration " + propertyName + ". Already declared in {{c0}}", new Object[]{property.className});
            return;
        }
        information.propertiesByOutputName.put(property.outputName, property);
        property.setter = method;
    }

    private void scanCreators(ClassInformation information, ReflectClass<?> cls) {
        ReflectMethod defaultCtor;
        ReflectMethod foundCreator = null;
        ReflectMethod duplicateCreator = null;
        boolean isFoundCreatorGuessed = false;
        for (ReflectMethod method : cls.getDeclaredMethods()) {
            boolean isCreator;
            boolean isExplicitCreator = method.getAnnotation(JsonCreator.class) != null;
            boolean bl = isCreator = (foundCreator == null || isFoundCreatorGuessed) && this.isGuessedCreator(method);
            if (!information.persistable) {
                if (!isExplicitCreator) continue;
                diagnostics.error(new SourceLocation(method), "Non-persistable class {{c0}} can't declare `@JsonCreator`", new Object[]{cls.getName()});
                continue;
            }
            if (!isExplicitCreator && !isCreator) continue;
            if (!(foundCreator == null || isExplicitCreator && isFoundCreatorGuessed)) {
                if (duplicateCreator != null) continue;
                duplicateCreator = method;
                continue;
            }
            if (isCreator) {
                isFoundCreatorGuessed = true;
            }
            foundCreator = method;
            if (duplicateCreator != null) {
                duplicateCreator = null;
            }
            if (!method.getName().equals("<init>") && Modifier.isStatic(method.getModifiers())) {
                diagnostics.error(new SourceLocation(method), "Creator should be either constructor  or static: {{m0}}", new Object[]{method});
                continue;
            }
            information.constructor = method;
            for (int i = 0; i < method.getParameterCount(); ++i) {
                PropertyInformation property = this.addParameter(information, method, i, method.getParameterAnnotations(i), method.getParameterType(i));
                information.constructorArgs.add(property);
            }
        }
        if (duplicateCreator != null) {
            diagnostics.error(new SourceLocation(foundCreator), "Duplicate creators declared: {{m0}} and {{m1}}", new Object[]{foundCreator, duplicateCreator});
            return;
        }
        if (information.constructor == null && information.persistable && (defaultCtor = cls.getDeclaredMethod("<init>", new ReflectClass[0])) != null) {
            information.constructor = defaultCtor;
        }
    }

    private boolean isGuessedCreator(ReflectMethod method) {
        if (!method.isConstructor()) {
            return false;
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (method.getParameterAnnotations(i).getAnnotation(JsonProperty.class) == null) continue;
            return true;
        }
        return false;
    }

    private PropertyInformation addParameter(ClassInformation information, ReflectMethod creator, int index, ReflectAnnotatedElement annotations, ReflectClass<?> type) {
        PropertyInformation conflictingProperty;
        String propertyName = this.getPropertyName(annotations, null);
        if (propertyName == null) {
            diagnostics.error(new SourceLocation(creator), "Parameter #" + index + " name was not specified", new Object[0]);
            return null;
        }
        PropertyInformation property = information.propertiesByOutputName.get(propertyName);
        if (property != null) {
            if (property.setter == null && property.creatorParameterIndex == null) {
                information.propertiesByOutputName.remove(propertyName);
            }
        } else {
            property = new PropertyInformation();
            property.className = information.className;
            property.outputName = propertyName;
            property.name = propertyName;
            information.properties.put(propertyName, property);
        }
        if ((conflictingProperty = information.propertiesByOutputName.get(property.outputName)) != null) {
            diagnostics.error(null, "Duplicate property declaration " + property.outputName + ". Already declared in {{c0}}", new Object[]{property.className});
            return null;
        }
        information.properties.put(property.name, property);
        information.propertiesByOutputName.put(property.outputName, property);
        if (property.ignored || this.isIgnored(annotations)) {
            property.ignored = true;
            return property;
        }
        property.creatorParameterIndex = index;
        property.type = type;
        return property;
    }

    private void scanFields(ClassInformation information, ReflectClass<?> cls) {
        for (ReflectField field : cls.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !this.hasExplicitPropertyDeclaration((ReflectAnnotatedElement)field) && !information.fieldVisibility.match(field.getModifiers())) continue;
            this.addField(information, field.getName(), field);
        }
    }

    private void scanPropertyFields(ClassInformation information) {
        block0: for (PropertyInformation property : information.properties.values()) {
            if (property.field != null) continue;
            ClassInformation ancestorInfo = information;
            while (ancestorInfo != null && ancestorInfo.properties.containsKey(property.name)) {
                ReflectClass ancestor = Metaprogramming.findClass((String)ancestorInfo.className);
                ReflectField field = ancestor.getDeclaredField(property.name);
                if (field != null) {
                    this.addField(information, property.name, field);
                    continue block0;
                }
                ancestorInfo = ancestorInfo.parent;
            }
        }
    }

    private void addField(ClassInformation information, String propertyName, ReflectField field) {
        PropertyInformation property = information.properties.get(propertyName);
        if (property != null) {
            information.propertiesByOutputName.remove(property.outputName);
        } else {
            property = new PropertyInformation();
            property.name = propertyName;
            property.outputName = propertyName;
            property.className = information.className;
            information.properties.put(propertyName, property);
        }
        if (property.ignored || this.isIgnored((ReflectAnnotatedElement)field)) {
            property.ignored = true;
            return;
        }
        property.outputName = this.getPropertyName((ReflectAnnotatedElement)field, property.outputName);
        PropertyInformation conflictingProperty = information.propertiesByOutputName.get(property.outputName);
        if (conflictingProperty != null) {
            diagnostics.error(null, "Duplicate property declaration " + propertyName + ". Already declared in {{c0}}", new Object[]{property.className});
            return;
        }
        information.propertiesByOutputName.put(property.outputName, property);
        property.field = field;
        property.type = field.getType();
    }

    private boolean isIgnored(ReflectAnnotatedElement annotations) {
        return annotations.getAnnotation(JsonIgnore.class) != null;
    }

    private boolean isGetterName(String name) {
        return name.startsWith("get") && name.length() > 3 && Character.toUpperCase(name.charAt(3)) == name.charAt(3);
    }

    private boolean isBooleanName(String name) {
        return name.startsWith("is") && name.length() > 2 && Character.toUpperCase(name.charAt(2)) == name.charAt(2);
    }

    private boolean isSetterName(String name) {
        return name.startsWith("set") && name.length() > 3 && Character.toUpperCase(name.charAt(3)) == name.charAt(3);
    }

    private String decapitalize(String name) {
        if (name.length() > 1 && name.charAt(1) == Character.toUpperCase(name.charAt(1))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private String getPropertyName(ReflectAnnotatedElement annotations, String fallbackName) {
        JsonProperty annot = (JsonProperty)annotations.getAnnotation(JsonProperty.class);
        if (annot == null) {
            return fallbackName;
        }
        return !annot.value().isEmpty() ? annot.value() : fallbackName;
    }

    private boolean hasExplicitPropertyDeclaration(ReflectAnnotatedElement annotations) {
        return annotations.getAnnotation(JsonProperty.class) != null;
    }
}

