/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.deserializer;

import org.teavm.flavour.json.JSON;
import org.teavm.flavour.json.deserializer.JsonDeserializer;
import org.teavm.flavour.json.deserializer.JsonDeserializerContext;
import org.teavm.flavour.json.tree.ArrayNode;
import org.teavm.flavour.json.tree.BooleanNode;
import org.teavm.flavour.json.tree.Node;
import org.teavm.flavour.json.tree.NumberNode;
import org.teavm.flavour.json.tree.StringNode;

public class ObjectDeserializer
extends JsonDeserializer {
    @Override
    public Object deserialize(JsonDeserializerContext context, Node node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            Object[] result = new Object[arrayNode.size()];
            for (int i = 0; i < arrayNode.size(); ++i) {
                result[i] = JSON.deserialize(arrayNode.get(i), Object.class);
            }
            return result;
        }
        if (node.isBoolean()) {
            return ((BooleanNode)node).getValue();
        }
        if (node.isNumber()) {
            NumberNode number = (NumberNode)node;
            return number.isInt() ? (double)number.getIntValue() : number.getValue();
        }
        if (node.isString()) {
            return ((StringNode)node).getValue();
        }
        throw new IllegalArgumentException("Don't know how to deserialize given JSON as a java.lang.Object: " + node.stringify());
    }
}

