/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.deserializer;

import java.util.HashMap;
import org.teavm.flavour.json.deserializer.JsonDeserializer;
import org.teavm.flavour.json.deserializer.JsonDeserializerContext;
import org.teavm.flavour.json.tree.Node;
import org.teavm.flavour.json.tree.ObjectNode;
import org.teavm.flavour.json.tree.StringNode;

public class MapDeserializer
extends JsonDeserializer {
    private JsonDeserializer keyDeserializer;
    private JsonDeserializer valueDeserializer;

    public MapDeserializer(JsonDeserializer keyDeserializer, JsonDeserializer valueDeserializer) {
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    @Override
    public Object deserialize(JsonDeserializerContext context, Node node) {
        if (node.isNull()) {
            return null;
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("Can't deserialize non-object node as a map");
        }
        ObjectNode objectNode = (ObjectNode)node;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (String key : objectNode.allKeys()) {
            Node valueNode = objectNode.get(key);
            map.put(this.keyDeserializer.deserialize(context, StringNode.create(key)), this.valueDeserializer.deserialize(context, valueNode));
        }
        return map;
    }
}

