/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.flavour.json.deserializer;

import java.lang.reflect.Array;
import org.teavm.flavour.json.deserializer.JsonDeserializer;
import org.teavm.flavour.json.deserializer.JsonDeserializerContext;
import org.teavm.flavour.json.tree.ArrayNode;
import org.teavm.flavour.json.tree.Node;

public class ArrayDeserializer
extends JsonDeserializer {
    private Class<?> itemType;
    private JsonDeserializer itemDeserializer;

    public ArrayDeserializer(Class<?> itemType, JsonDeserializer itemDeserializer) {
        this.itemType = itemType;
        this.itemDeserializer = itemDeserializer;
    }

    @Override
    public Object deserialize(JsonDeserializerContext context, Node node) {
        if (node.isNull()) {
            return null;
        }
        if (!node.isArray()) {
            throw new IllegalArgumentException("Can't deserialize non-array node as an array");
        }
        ArrayNode arrayNode = (ArrayNode)node;
        Object[] array = (Object[])Array.newInstance(this.itemType, arrayNode.size());
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.itemDeserializer.deserialize(context, arrayNode.get(i));
        }
        return array;
    }
}

