/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.tarantool.CommunicationException;

public abstract class TarantoolSelectorWorker
implements Runnable {
    private final Selector selector;
    private LinkedBlockingQueue<Reg> register = new LinkedBlockingQueue();

    public abstract void error(SelectionKey var1, Exception var2);

    public TarantoolSelectorWorker() throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
    }

    protected BlockingQueue<SelectionKey> register(SocketChannel channel, ChannelProcessor processor) {
        ArrayBlockingQueue<SelectionKey> queue = new ArrayBlockingQueue<SelectionKey>(1);
        if (this.register.offer(new Reg(channel, processor, queue))) {
            this.selector.wakeup();
            return queue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                while (!Thread.interrupted()) {
                    ChannelProcessor ps;
                    SelectionKey key2;
                    Set<SelectionKey> keys;
                    if (this.selector.select() > 0) {
                        keys = this.selector.selectedKeys();
                        Iterator<SelectionKey> i = keys.iterator();
                        while (i.hasNext()) {
                            key2 = i.next();
                            i.remove();
                            if (!key2.isValid()) continue;
                            ps = (ChannelProcessor)key2.attachment();
                            try {
                                if (key2.isReadable()) {
                                    ps.read();
                                    continue;
                                }
                                if (!key2.isWritable()) continue;
                                ps.write();
                            }
                            catch (Exception e) {
                                this.error(key2, e);
                                ps.close(e);
                            }
                        }
                    }
                    keys = this.selector.keys();
                    for (SelectionKey key2 : keys) {
                        if (!key2.isValid()) continue;
                        ps = (ChannelProcessor)key2.attachment();
                        try {
                            ps.idle();
                        }
                        catch (Exception e) {
                            this.error(key2, e);
                            ps.close(e);
                        }
                    }
                    while (!this.register.isEmpty()) {
                        Reg reg = this.register.poll();
                        if (reg == null) continue;
                        try {
                            reg.channel.configureBlocking(false);
                            key2 = reg.channel.register(this.selector, 1, reg.processor);
                            reg.result.offer(key2);
                        }
                        catch (Exception e) {
                            reg.processor.close(e);
                        }
                    }
                }
            }
            finally {
                this.selector.close();
            }
        }
        catch (IOException e) {
            throw new CommunicationException("IO Exception during key selection", e);
        }
    }

    public class Reg {
        SocketChannel channel;
        ChannelProcessor processor;
        BlockingQueue<SelectionKey> result;

        public Reg(SocketChannel channel, ChannelProcessor processor, BlockingQueue<SelectionKey> result) {
            this.channel = channel;
            this.processor = processor;
            this.result = result;
        }
    }

    public static interface ChannelProcessor {
        public void read();

        public void write();

        public void idle();

        public void close(Exception var1);
    }
}

