/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tarantool.Base64;
import org.tarantool.Code;
import org.tarantool.CommunicationException;
import org.tarantool.ConnectionState;
import org.tarantool.Key;
import org.tarantool.TarantoolException;
import org.tarantool.schema.FieldsMapping;
import org.tarantool.schema.IndexId;
import org.tarantool.schema.Space;
import org.tarantool.schema.SpaceId;

public abstract class TarantoolConnection16Base {
    protected final SocketChannel channel;
    protected final ConnectionState state;
    protected final String salt;

    protected SocketChannel getChannel() {
        return this.channel;
    }

    protected ConnectionState getState() {
        return this.state;
    }

    public TarantoolConnection16Base(SocketChannel channel) {
        try {
            this.channel = channel;
            this.state = new ConnectionState();
            ByteBuffer welcome = this.state.getWelcomeBuffer();
            this.readFully(welcome);
            String firstLine = new String(welcome.array(), 0, welcome.position());
            if (!firstLine.startsWith("Tarantool")) {
                channel.close();
                throw new CommunicationException("Welcome message should starts with tarantool but starts with '" + firstLine + "'");
            }
            welcome = this.state.getWelcomeBuffer();
            this.readFully(welcome);
            this.salt = new String(welcome.array(), 0, welcome.position());
        }
        catch (IOException e) {
            throw new CommunicationException("Can't connect with tarantool", e);
        }
    }

    protected int readFully(ByteBuffer buffer) {
        try {
            int code;
            while ((code = this.channel.read(buffer)) > -1 && buffer.remaining() > 0) {
            }
            if (code < 0) {
                throw new CommunicationException("Can't read bytes");
            }
            return code;
        }
        catch (IOException e) {
            throw new CommunicationException("Can't read bytes", e);
        }
    }

    protected Object read() {
        this.readPacket();
        return this.state.getBody().get(Key.DATA);
    }

    protected void readPacket() {
        this.readFully(this.state.getLengthReadBuffer());
        this.readFully(this.state.getPacketReadBuffer());
        this.state.unpack();
        long code = (Long)this.state.getHeader().get(Key.CODE);
        if (code != 0L) {
            Object error = this.state.getBody().get(Key.ERROR);
            throw new TarantoolException((int)code, error instanceof String ? (String)error : new String((byte[])error));
        }
    }

    protected int write(ByteBuffer buffer) {
        try {
            int code;
            while ((code = this.channel.write(buffer)) > -1 && buffer.remaining() > 0) {
            }
            if (code < 0) {
                throw new CommunicationException("Can't read bytes");
            }
            return code;
        }
        catch (IOException e) {
            throw new CommunicationException("Can't write bytes", e);
        }
    }

    public List select(int space, int index, Object key, int offset, int limit, int iterator) {
        return this.exec(Code.SELECT, Key.SPACE, space, Key.INDEX, index, Key.KEY, key, Key.ITERATOR, iterator, Key.LIMIT, limit, Key.OFFSET, offset);
    }

    public List insert(int space, Object tuple) {
        return this.exec(Code.INSERT, Key.SPACE, space, Key.TUPLE, tuple);
    }

    public List replace(int space, Object tuple) {
        return this.exec(Code.REPLACE, Key.SPACE, space, Key.TUPLE, tuple);
    }

    public List update(int space, Object key, Object ... args) {
        return this.exec(Code.UPDATE, Key.SPACE, space, Key.KEY, key, Key.TUPLE, args);
    }

    public void upsert(int space, Object key, Object def, Object ... args) {
        this.exec(Code.UPSERT, Key.SPACE, space, Key.KEY, key, Key.TUPLE, def, Key.UPSERT_OPS, args);
    }

    public List delete(int space, Object key) {
        return this.exec(Code.DELETE, Key.SPACE, space, Key.KEY, key);
    }

    public List call(String function, Object ... args) {
        return this.exec(Code.CALL, Key.FUNCTION, function, Key.TUPLE, args);
    }

    public List eval(String expression, Object ... args) {
        return this.exec(Code.EVAL, Key.EXPRESSION, expression, Key.TUPLE, args);
    }

    public void auth(String username, String password) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            ArrayList<Object> auth = new ArrayList<Object>(2);
            auth.add("chap-sha1");
            byte[] p = sha1.digest(password.getBytes());
            sha1.reset();
            byte[] p2 = sha1.digest(p);
            sha1.reset();
            sha1.update(Base64.decode(this.salt), 0, 20);
            sha1.update(p2);
            byte[] scramble = sha1.digest();
            int e = 20;
            for (int i = 0; i < e; ++i) {
                int n = i;
                p[n] = (byte)(p[n] ^ scramble[i]);
            }
            auth.add(p);
            this.exec(Code.AUTH, Key.USER_NAME, username, Key.TUPLE, auth);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CommunicationException("Can't use sha-1", e);
        }
    }

    public void ping() {
        this.exec(Code.PING, new Object[0]);
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public <T> T schema(T schema) {
        Field[] fields;
        Map<String, List> spaces = this.callMap(281, new int[]{2}, "");
        String idxSep = "_";
        Map<String, List> indexes = this.callMap(289, new int[]{0, 2}, "_");
        for (Field field : fields = schema.getClass().getFields()) {
            Space space = field.getAnnotation(Space.class);
            if (space == null) continue;
            String spaceName = space.value().isEmpty() ? field.getName() : space.value();
            List spaceMeta = spaces.get(spaceName);
            Integer spaceIndex = (Integer)spaceMeta.get(0);
            if (spaceIndex == null) {
                throw new IllegalStateException("Can't find ID for space " + spaceName);
            }
            try {
                Object spaceObject = field.get(schema);
                for (Field f : spaceObject.getClass().getFields()) {
                    Field[] spaceFields;
                    SpaceId spaceId = f.getAnnotation(SpaceId.class);
                    IndexId indexId = f.getAnnotation(IndexId.class);
                    FieldsMapping fieldsMapping = f.getAnnotation(FieldsMapping.class);
                    if (spaceId != null) {
                        f.set(spaceObject, f.getClass().isPrimitive() ? spaceIndex.intValue() : spaceIndex.intValue());
                        continue;
                    }
                    if (indexId != null) {
                        String indexName = indexId.value().isEmpty() ? f.getName() : indexId.value();
                        Integer indexIdx = (Integer)indexes.get(spaceIndex + "_" + indexName).get(1);
                        if (indexIdx == null) {
                            throw new IllegalStateException("Can't find index id " + spaceName + "." + indexName);
                        }
                        f.set(spaceObject, indexIdx);
                        continue;
                    }
                    if (fieldsMapping == null) continue;
                    List spaceFieldsMap = (List)spaceMeta.get(6);
                    HashMap fn = new HashMap();
                    for (int i = 0; i < spaceFieldsMap.size(); ++i) {
                        Map elem = (Map)spaceFieldsMap.get(i);
                        fn.put(elem.get("name"), i);
                    }
                    Object fieldsObj = f.get(spaceObject);
                    for (Field sf : spaceFields = fieldsObj.getClass().getFields()) {
                        String fieldName = fieldsMapping.value().isEmpty() ? sf.getName() : fieldsMapping.value();
                        Integer idx = (Integer)fn.get(fieldName);
                        if (idx == null) {
                            throw new IllegalStateException("Can't find field id " + spaceName + "." + fieldName);
                        }
                        sf.set(fieldsObj, sf.getClass().isPrimitive() ? idx.intValue() : idx.intValue());
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("All schema field should be accessible", e);
            }
        }
        return schema;
    }

    protected Map<String, List> callMap(int space, int[] key, String keySeparator) {
        List tuples = this.select(space, 0, Arrays.asList(new Object[0]), 0, 1000, 0);
        HashMap<String, List> result = new HashMap<String, List>();
        for (List tuple : tuples) {
            StringBuilder keyValue = new StringBuilder();
            int[] nArray = key;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer k = nArray[i];
                if (keyValue.length() > 0) {
                    keyValue.append(keySeparator);
                }
                keyValue.append(tuple.get(k));
            }
            result.put(keyValue.toString(), tuple);
        }
        return result;
    }

    protected abstract List exec(Code var1, Object ... var2);
}

