/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import org.tarantool.ByteBufferStreams;
import org.tarantool.Code;
import org.tarantool.Key;
import org.tarantool.MsgPackLite;

public class ConnectionState {
    protected EnumMap<Key, Object> header = new EnumMap(Key.class);
    protected EnumMap<Key, Object> body = new EnumMap(Key.class);
    protected ByteBufferStreams buffer = new ByteBufferStreams(ByteBuffer.allocate(32768), 1.1);

    public ByteBuffer getWelcomeBuffer() {
        ByteBuffer buf = this.buffer.getBuf();
        buf.clear();
        buf.limit(64);
        return buf;
    }

    public ByteBuffer getLengthReadBuffer() {
        ByteBuffer buf = this.buffer.getBuf();
        buf.clear();
        buf.limit(5);
        return buf;
    }

    public ByteBuffer getPacketReadBuffer() {
        ByteBuffer buf = this.buffer.getBuf();
        buf.limit(buf.position());
        buf.rewind();
        try {
            long size = (Long)MsgPackLite.unpack(this.buffer.asInputStream(), 0);
            buf.clear();
            this.buffer.checkCapacity((int)size);
            buf = this.buffer.getBuf();
            buf.position(0);
            buf.limit((int)size);
            return buf;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void unpack() {
        ByteBuffer buf = this.buffer.getBuf();
        buf.limit(buf.position());
        buf.rewind();
        this.body.clear();
        this.header.clear();
        try {
            this.toKeyMap(MsgPackLite.unpack(this.buffer.asInputStream(), 1), this.header);
            if (buf.remaining() > 0) {
                this.toKeyMap(MsgPackLite.unpack(this.buffer.asInputStream(), 1), this.body);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void toKeyMap(Object unpack, EnumMap<Key, Object> result) {
        Map map = (Map)unpack;
        for (Map.Entry entry : map.entrySet()) {
            Key key = Key.getById((Integer)entry.getKey());
            if (key == null) continue;
            result.put(key, entry.getValue());
        }
    }

    public ByteBuffer pack(Code code, Object[] args) {
        return this.pack(code, null, args);
    }

    public ByteBuffer pack(Code code, Long syncId, Object[] args) {
        this.beginBody();
        if (args != null) {
            int e = args.length;
            for (int i = 0; i < e; i += 2) {
                Object value = args[i + 1];
                this.put((Key)args[i], value);
            }
        }
        this.endBody();
        return this.pack(code, (Object)syncId, this.body);
    }

    public ByteBuffer pack(Code code, Object sync, EnumMap<Key, Object> body) {
        this.header.clear();
        this.header.put(Key.CODE, (Object)code);
        if (sync != null) {
            this.header.put(Key.SYNC, sync);
        }
        ByteBuffer buf = this.buffer.getBuf();
        buf.clear();
        buf.put((byte)-50);
        buf.putInt(0);
        try {
            MsgPackLite.pack(this.header, this.buffer.asOutputStream());
            MsgPackLite.pack(body, this.buffer.asOutputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        buf = this.buffer.getBuf();
        int size = buf.position();
        buf.putInt(1, size - 5);
        buf.limit(size);
        buf.rewind();
        return buf;
    }

    public ConnectionState beginBody() {
        this.body.clear();
        return this;
    }

    public ConnectionState put(Key key, Object value) {
        if (value != null) {
            this.body.put(key, value);
        }
        return this;
    }

    public EnumMap<Key, Object> endBody() {
        return this.body;
    }

    public EnumMap<Key, Object> getHeader() {
        return this.header;
    }

    public EnumMap<Key, Object> getBody() {
        return this.body;
    }
}

