/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferStreams {
    protected ByteBuffer buf;
    protected double resizeFactor = 1.1;
    protected OutputStream os = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            if (ByteBufferStreams.this.buf.remaining() < 1) {
                ByteBufferStreams.this.checkCapacity(ByteBufferStreams.this.buf.capacity() + 1);
            }
            ByteBufferStreams.this.buf.put((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > ByteBufferStreams.this.buf.remaining()) {
                ByteBufferStreams.this.checkCapacity(ByteBufferStreams.this.buf.capacity() + (len - ByteBufferStreams.this.buf.remaining()));
            }
            ByteBufferStreams.this.buf.put(b, off, len);
        }
    };
    protected InputStream is = new InputStream(){

        @Override
        public int read() throws IOException {
            return 0xFF & ByteBufferStreams.this.buf.get();
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!ByteBufferStreams.this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, ByteBufferStreams.this.buf.remaining());
            ByteBufferStreams.this.buf.get(bytes, off, len);
            return len;
        }
    };

    public ByteBufferStreams(ByteBuffer buf, double resizeFactor) {
        this.buf = buf;
        this.resizeFactor = resizeFactor;
    }

    public void checkCapacity(int size) {
        if (this.buf.capacity() < size) {
            ByteBuffer newBuf = ByteBuffer.allocate(size + size / 2);
            this.buf.flip();
            newBuf.put(this.buf);
            this.buf = newBuf;
        }
    }

    public OutputStream asOutputStream() {
        return this.os;
    }

    public InputStream asInputStream() {
        return this.is;
    }

    public void clear() {
        this.buf.clear();
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }
}

